/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.OneToOneContactInvitationProtocol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class DeviceCapabilitiesDiscoveryProtocol
extends ConcreteProtocol {
    static final int FINISHED_STATE_ID = 1;
    static final int INITIAL_FOR_ADDING_OWN_CAPABILITIES_MESSAGE_ID = 0;
    static final int INITIAL_SINGLE_CONTACT_DEVICE_MESSAGE_ID = 1;
    static final int INITIAL_SINGLE_OWNED_DEVICE_MESSAGE_ID = 2;
    static final int OWN_CAPABILITIES_TO_CONTACT_MESSAGE_ID = 3;
    static final int OWN_CAPABILITIES_TO_SELF_MESSAGE_ID = 4;

    public DeviceCapabilitiesDiscoveryProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 16;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{1};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return FinishedProtocolState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialForAddingOwnCapabilitiesMessage.class;
            }
            case 1: {
                return InitialSingleContactDeviceMessage.class;
            }
            case 2: {
                return InitialSingleOwnedDeviceMessage.class;
            }
            case 3: {
                return OwnCapabilitiesToContactMessage.class;
            }
            case 4: {
                return OwnCapabilitiesToSelfMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{AddOwnCapabilitiesAndSendThemToAllContactsAndOwnedDevicesStep.class, SendOwnCapabilitiesToContactDeviceStep.class, SendOwnCapabilitiesToOtherOwnedDeviceStep.class, ProcessReceivedContactDeviceCapabilitiesStep.class, ProcessReceivedOwnedDeviceCapabilitiesStep.class};
            }
        }
        return new Class[0];
    }

    public static class FinishedProtocolState
    extends ConcreteProtocolState {
        public FinishedProtocolState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public FinishedProtocolState() {
            super(1);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialForAddingOwnCapabilitiesMessage
    extends ConcreteProtocolMessage {
        private final List<ObvCapability> newOwnCapabilities;

        public InitialForAddingOwnCapabilitiesMessage(CoreProtocolMessage coreProtocolMessage, List<ObvCapability> newOwnCapabilities) {
            super(coreProtocolMessage);
            this.newOwnCapabilities = newOwnCapabilities;
        }

        public InitialForAddingOwnCapabilitiesMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            String[] rawCapabilities = receivedMessage.getInputs()[0].decodeStringArray();
            this.newOwnCapabilities = new ArrayList<ObvCapability>();
            for (String rawCapability : rawCapabilities) {
                ObvCapability capability = ObvCapability.fromString(rawCapability);
                if (capability == null) {
                    throw new Exception("Unknown capability: " + rawCapability);
                }
                this.newOwnCapabilities.add(capability);
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(ObvCapability.capabilityListToStringArray(this.newOwnCapabilities))};
        }
    }

    public static class InitialSingleContactDeviceMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final UID contactDeviceUid;
        private final boolean isResponse;

        public InitialSingleContactDeviceMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, UID contactDeviceUid, boolean isResponse) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.contactDeviceUid = contactDeviceUid;
            this.isResponse = isResponse;
        }

        public InitialSingleContactDeviceMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.contactDeviceUid = receivedMessage.getInputs()[1].decodeUid();
            this.isResponse = receivedMessage.getInputs()[2].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactDeviceUid), Encoded.of(this.isResponse)};
        }
    }

    public static class InitialSingleOwnedDeviceMessage
    extends ConcreteProtocolMessage {
        private final UID otherOwnedDeviceUid;
        private final boolean isResponse;

        public InitialSingleOwnedDeviceMessage(CoreProtocolMessage coreProtocolMessage, UID otherOwnedDeviceUid, boolean isResponse) {
            super(coreProtocolMessage);
            this.otherOwnedDeviceUid = otherOwnedDeviceUid;
            this.isResponse = isResponse;
        }

        public InitialSingleOwnedDeviceMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.otherOwnedDeviceUid = receivedMessage.getInputs()[0].decodeUid();
            this.isResponse = receivedMessage.getInputs()[1].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.otherOwnedDeviceUid), Encoded.of(this.isResponse)};
        }
    }

    public static class OwnCapabilitiesToContactMessage
    extends ConcreteProtocolMessage {
        private final String[] rawContactDeviceCapabilities;
        private final boolean isResponse;

        public OwnCapabilitiesToContactMessage(CoreProtocolMessage coreProtocolMessage, String[] rawContactDeviceCapabilities, boolean isResponse) {
            super(coreProtocolMessage);
            this.rawContactDeviceCapabilities = rawContactDeviceCapabilities;
            this.isResponse = isResponse;
        }

        public OwnCapabilitiesToContactMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.rawContactDeviceCapabilities = receivedMessage.getInputs()[0].decodeStringArray();
            this.isResponse = receivedMessage.getInputs()[1].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.rawContactDeviceCapabilities), Encoded.of(this.isResponse)};
        }
    }

    public static class OwnCapabilitiesToSelfMessage
    extends ConcreteProtocolMessage {
        private final String[] rawOtherOwnedDeviceCapabilities;
        private final boolean isResponse;

        public OwnCapabilitiesToSelfMessage(CoreProtocolMessage coreProtocolMessage, String[] rawOtherOwnedDeviceCapabilities, boolean isResponse) {
            super(coreProtocolMessage);
            this.rawOtherOwnedDeviceCapabilities = rawOtherOwnedDeviceCapabilities;
            this.isResponse = isResponse;
        }

        public OwnCapabilitiesToSelfMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.rawOtherOwnedDeviceCapabilities = receivedMessage.getInputs()[0].decodeStringArray();
            this.isResponse = receivedMessage.getInputs()[1].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.rawOtherOwnedDeviceCapabilities), Encoded.of(this.isResponse)};
        }
    }

    public static class AddOwnCapabilitiesAndSendThemToAllContactsAndOwnedDevicesStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialForAddingOwnCapabilitiesMessage receivedMessage;

        public AddOwnCapabilitiesAndSendThemToAllContactsAndOwnedDevicesStep(InitialProtocolState startState, InitialForAddingOwnCapabilitiesMessage receivedMessage, DeviceCapabilitiesDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            Identity[] contactIdentities;
            CoreProtocolMessage coreProtocolMessage;
            HashSet<ObvCapability> hashSet;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            List<ObvCapability> currentCapabilities = protocolManagerSession.identityDelegate.getCurrentDevicePublishedCapabilities(protocolManagerSession.session, this.getOwnedIdentity());
            HashSet<ObvCapability> currentSet = new HashSet<ObvCapability>(currentCapabilities);
            if (Objects.equals(currentSet, hashSet = new HashSet<ObvCapability>(this.receivedMessage.newOwnCapabilities))) {
                return new FinishedProtocolState();
            }
            boolean gainedOneToOneCapability = hashSet.contains((Object)ObvCapability.ONE_TO_ONE_CONTACTS) && !currentSet.contains((Object)ObvCapability.ONE_TO_ONE_CONTACTS);
            protocolManagerSession.identityDelegate.setCurrentDevicePublishedCapabilities(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.newOwnCapabilities);
            if (gainedOneToOneCapability) {
                UID childProtocolInstanceUid = new UID(this.getPrng());
                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 17, childProtocolInstanceUid);
                ChannelProtocolMessageToSend channelProtocolMessageToSend = new OneToOneContactInvitationProtocol.InitiateOneToOneStatusSyncWithAllContactsMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, channelProtocolMessageToSend, this.getPrng());
            }
            if ((contactIdentities = protocolManagerSession.identityDelegate.getContactsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity())).length > 0) {
                SendChannelInfo[] sendChannelInfos;
                for (SendChannelInfo sendChannelInfo : sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(contactIdentities, this.getOwnedIdentity())) {
                    try {
                        CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(sendChannelInfo);
                        ChannelProtocolMessageToSend messageToSend2 = new OwnCapabilitiesToContactMessage(coreProtocolMessage2, ObvCapability.capabilityListToStringArray(this.receivedMessage.newOwnCapabilities), false).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                    }
                    catch (Exception e) {
                        Logger.d("One contact with no channel during DeviceCapabilitiesDiscoveryProtocol.AddOwnCapabilitiesAndSendThemToAllContactsAndOwnedDevicesStep");
                    }
                }
            }
            if ((numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend channelProtocolMessageToSend = new OwnCapabilitiesToSelfMessage(coreProtocolMessage, ObvCapability.capabilityListToStringArray(this.receivedMessage.newOwnCapabilities), false).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, channelProtocolMessageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new FinishedProtocolState();
        }
    }

    public static class SendOwnCapabilitiesToContactDeviceStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialSingleContactDeviceMessage receivedMessage;

        public SendOwnCapabilitiesToContactDeviceStep(InitialProtocolState startState, InitialSingleContactDeviceMessage receivedMessage, DeviceCapabilitiesDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            List<ObvCapability> currentCapabilities = protocolManagerSession.identityDelegate.getCurrentDevicePublishedCapabilities(protocolManagerSession.session, this.getOwnedIdentity());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createObliviousChannelOrPreKeyInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity(), new UID[]{this.receivedMessage.contactDeviceUid}, true));
            ChannelProtocolMessageToSend messageToSend = new OwnCapabilitiesToContactMessage(coreProtocolMessage, ObvCapability.capabilityListToStringArray(currentCapabilities), this.receivedMessage.isResponse).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedProtocolState();
        }
    }

    public static class SendOwnCapabilitiesToOtherOwnedDeviceStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialSingleOwnedDeviceMessage receivedMessage;

        public SendOwnCapabilitiesToOtherOwnedDeviceStep(InitialProtocolState startState, InitialSingleOwnedDeviceMessage receivedMessage, DeviceCapabilitiesDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            List<ObvCapability> currentCapabilities = protocolManagerSession.identityDelegate.getCurrentDevicePublishedCapabilities(protocolManagerSession.session, this.getOwnedIdentity());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createObliviousChannelOrPreKeyInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), new UID[]{this.receivedMessage.otherOwnedDeviceUid}, true));
            ChannelProtocolMessageToSend messageToSend = new OwnCapabilitiesToSelfMessage(coreProtocolMessage, ObvCapability.capabilityListToStringArray(currentCapabilities), this.receivedMessage.isResponse).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedProtocolState();
        }
    }

    public static class ProcessReceivedContactDeviceCapabilitiesStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final OwnCapabilitiesToContactMessage receivedMessage;

        public ProcessReceivedContactDeviceCapabilitiesStep(InitialProtocolState startState, OwnCapabilitiesToContactMessage receivedMessage, DeviceCapabilitiesDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            String[] initialContactDeviceCapabilities = protocolManagerSession.identityDelegate.getContactDeviceCapabilities(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid());
            if (!this.receivedMessage.isResponse && initialContactDeviceCapabilities.length == 0) {
                UID childProtocolInstanceUid = new UID(this.getPrng());
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 16, childProtocolInstanceUid);
                ChannelProtocolMessageToSend messageToSend = new InitialSingleContactDeviceMessage(coreProtocolMessage, this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid(), true).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            protocolManagerSession.identityDelegate.setContactDeviceCapabilities(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid(), this.receivedMessage.rawContactDeviceCapabilities);
            return new FinishedProtocolState();
        }
    }

    public static class ProcessReceivedOwnedDeviceCapabilitiesStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final OwnCapabilitiesToSelfMessage receivedMessage;

        public ProcessReceivedOwnedDeviceCapabilitiesStep(InitialProtocolState startState, OwnCapabilitiesToSelfMessage receivedMessage, DeviceCapabilitiesDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            String[] initialOtherOwnedDeviceCapabilities = protocolManagerSession.identityDelegate.getOtherOwnedDeviceCapabilities(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid());
            if (!this.receivedMessage.isResponse && initialOtherOwnedDeviceCapabilities.length == 0) {
                UID childProtocolInstanceUid = new UID(this.getPrng());
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 16, childProtocolInstanceUid);
                ChannelProtocolMessageToSend messageToSend = new InitialSingleOwnedDeviceMessage(coreProtocolMessage, this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid(), true).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            protocolManagerSession.identityDelegate.setOtherOwnedDeviceCapabilities(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid(), this.receivedMessage.rawOtherOwnedDeviceCapabilities);
            return new FinishedProtocolState();
        }
    }
}

