/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.GroupInformation;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.EmptyProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryProtocol;
import io.olvid.engine.protocol.protocols.GroupManagementProtocol;
import java.util.HashSet;

public class ContactManagementProtocol
extends ConcreteProtocol {
    static final int FINAL_STATE_ID = 1;
    private static final int INITIATE_CONTACT_DELETION_MESSAGE_ID = 0;
    private static final int CONTACT_DELETION_NOTIFICATION_MESSAGE_ID = 1;
    private static final int PROPAGATE_CONTACT_DELETION_MESSAGE_ID = 2;
    private static final int INITIATE_CONTACT_DOWNGRADE_MESSAGE_ID = 3;
    private static final int CONTACT_DOWNGRADE_NOTIFICATION_MESSAGE_ID = 4;
    private static final int PROPAGATE_CONTACT_DOWNGRADE_MESSAGE_ID = 5;
    private static final int PERFORM_CONTACT_DEVICE_DISCOVERY_MESSAGE_ID = 6;

    public ContactManagementProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.eraseReceivedMessagesAfterReachingAFinalState = false;
    }

    @Override
    public int getProtocolId() {
        return 10;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{1};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return FinalState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitiateContactDeletionMessage.class;
            }
            case 1: {
                return ContactDeletionNotificationMessage.class;
            }
            case 2: {
                return PropagateContactDeletionMessage.class;
            }
            case 3: {
                return InitiateContactDowngradeMessage.class;
            }
            case 4: {
                return ContactDowngradeNotificationMessage.class;
            }
            case 5: {
                return PropagateContactDowngradeMessage.class;
            }
            case 6: {
                return PerformContactDeviceDiscoveryMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        if (stateId == 0) {
            return new Class[]{DeleteContactStep.class, ProcessContactDeletionNotificationStep.class, ProcessPropagatedContactDeletionStep.class, DowngradeContactStep.class, ProcessContactDowngradeNotificationStep.class, ProcessPropagatedContactDowngradeStep.class, ProcessPerformContactDeviceDiscoveryMessageStep.class};
        }
        return new Class[0];
    }

    public static class FinalState
    extends ConcreteProtocolState {
        public FinalState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        FinalState() {
            super(1);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitiateContactDeletionMessage
    extends ConcreteProtocolMessage {
        Identity contactIdentity;

        public InitiateContactDeletionMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
        }

        public InitiateContactDeletionMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity)};
        }
    }

    public static class ContactDeletionNotificationMessage
    extends EmptyProtocolMessage {
        public ContactDeletionNotificationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public ContactDeletionNotificationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }
    }

    public static class PropagateContactDeletionMessage
    extends ConcreteProtocolMessage {
        Identity contactIdentity;

        public PropagateContactDeletionMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
        }

        public PropagateContactDeletionMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity)};
        }
    }

    public static class InitiateContactDowngradeMessage
    extends ConcreteProtocolMessage {
        Identity contactIdentity;

        public InitiateContactDowngradeMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
        }

        public InitiateContactDowngradeMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity)};
        }
    }

    public static class ContactDowngradeNotificationMessage
    extends EmptyProtocolMessage {
        public ContactDowngradeNotificationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public ContactDowngradeNotificationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }
    }

    public static class PropagateContactDowngradeMessage
    extends ConcreteProtocolMessage {
        Identity contactIdentity;

        public PropagateContactDowngradeMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
        }

        public PropagateContactDowngradeMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity)};
        }
    }

    public static class PerformContactDeviceDiscoveryMessage
    extends EmptyProtocolMessage {
        protected PerformContactDeviceDiscoveryMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public PerformContactDeviceDiscoveryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 6;
        }
    }

    public static class DeleteContactStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateContactDeletionMessage receivedMessage;

        public DeleteContactStep(InitialProtocolState startState, InitiateContactDeletionMessage receivedMessage, ContactManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateContactDeletionMessage(coreProtocolMessage, this.receivedMessage.contactIdentity).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            try {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new ContactDeletionNotificationMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            catch (Exception coreProtocolMessage) {
                // empty catch block
            }
            protocolManagerSession.channelDelegate.deleteObliviousChannelsWithContact(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity);
            byte[][] groupOwnerAndUids = protocolManagerSession.identityDelegate.getGroupOwnerAndUidOfGroupsWhereContactIsPending(protocolManagerSession.session, this.receivedMessage.contactIdentity, this.getOwnedIdentity());
            HashSet<Identity> removedMemberIdentities = new HashSet<Identity>(1);
            removedMemberIdentities.add(this.receivedMessage.contactIdentity);
            for (byte[] groupOwnerAndUid : groupOwnerAndUids) {
                GroupInformation groupInformation = protocolManagerSession.identityDelegate.getGroupInformation(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerAndUid);
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 9, groupInformation.computeProtocolUid());
                ChannelProtocolMessageToSend messageToSend = new GroupManagementProtocol.RemoveGroupMembersMessage(coreProtocolMessage, groupInformation, removedMemberIdentities).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            protocolManagerSession.identityDelegate.deleteContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity, true);
            return new FinalState();
        }
    }

    public static class ProcessContactDeletionNotificationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final ContactDeletionNotificationMessage receivedMessage;

        public ProcessContactDeletionNotificationStep(InitialProtocolState startState, ContactDeletionNotificationMessage receivedMessage, ContactManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            Identity contactIdentity = this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            protocolManagerSession.channelDelegate.deleteObliviousChannelsWithContact(protocolManagerSession.session, this.getOwnedIdentity(), contactIdentity);
            try {
                byte[][] groupOwnerAndUids;
                for (byte[] groupOwnerAndUid : groupOwnerAndUids = protocolManagerSession.identityDelegate.getGroupOwnerAndUidsOfGroupsOwnedByContact(protocolManagerSession.session, this.getOwnedIdentity(), contactIdentity)) {
                    protocolManagerSession.identityDelegate.leaveGroup(protocolManagerSession.session, groupOwnerAndUid, this.getOwnedIdentity());
                }
                protocolManagerSession.identityDelegate.deleteContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), contactIdentity, true);
                groupOwnerAndUids = protocolManagerSession.identityDelegate.getGroupOwnerAndUidOfGroupsWhereContactIsPending(protocolManagerSession.session, contactIdentity, this.getOwnedIdentity());
                HashSet<Identity> removedMemberIdentities = new HashSet<Identity>(1);
                removedMemberIdentities.add(contactIdentity);
                for (byte[] groupOwnerAndUid : groupOwnerAndUids) {
                    GroupInformation groupInformation = protocolManagerSession.identityDelegate.getGroupInformation(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerAndUid);
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 9, groupInformation.computeProtocolUid());
                    ChannelProtocolMessageToSend messageToSend = new GroupManagementProtocol.RemoveGroupMembersMessage(coreProtocolMessage, groupInformation, removedMemberIdentities).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new FinalState();
        }
    }

    public static class ProcessPropagatedContactDeletionStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateContactDeletionMessage receivedMessage;

        public ProcessPropagatedContactDeletionStep(InitialProtocolState startState, PropagateContactDeletionMessage receivedMessage, ContactManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            protocolManagerSession.channelDelegate.deleteObliviousChannelsWithContact(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity);
            protocolManagerSession.identityDelegate.deleteContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity, false);
            return new FinalState();
        }
    }

    public static class DowngradeContactStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateContactDowngradeMessage receivedMessage;

        public DowngradeContactStep(InitialProtocolState startState, InitiateContactDowngradeMessage receivedMessage, ContactManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity, false);
            try {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new ContactDowngradeNotificationMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            catch (Exception coreProtocolMessage) {
                // empty catch block
            }
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateContactDowngradeMessage(coreProtocolMessage, this.receivedMessage.contactIdentity).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new FinalState();
        }
    }

    public static class ProcessContactDowngradeNotificationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final ContactDowngradeNotificationMessage receivedMessage;

        public ProcessContactDowngradeNotificationStep(InitialProtocolState startState, ContactDowngradeNotificationMessage receivedMessage, ContactManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), false);
            return new FinalState();
        }
    }

    public static class ProcessPropagatedContactDowngradeStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateContactDowngradeMessage receivedMessage;

        public ProcessPropagatedContactDowngradeStep(InitialProtocolState startState, PropagateContactDowngradeMessage receivedMessage, ContactManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity, false);
            return new FinalState();
        }
    }

    public static class ProcessPerformContactDeviceDiscoveryMessageStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PerformContactDeviceDiscoveryMessage receivedMessage;

        public ProcessPerformContactDeviceDiscoveryMessageStep(InitialProtocolState startState, PerformContactDeviceDiscoveryMessage receivedMessage, ContactManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
            ChannelProtocolMessageToSend message = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity()).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.getPrng());
            return new FinalState();
        }
    }
}

