/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocol_engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import java.util.Objects;

public abstract class ProtocolStep
extends Operation {
    protected final ConcreteProtocol protocol;
    private ConcreteProtocolState endState;

    public ConcreteProtocolState getEndState() {
        return this.endState;
    }

    public ProtocolStep(ReceptionChannelInfo expectedReceptionChannelInfo, ConcreteProtocolMessage receivedMessage, ConcreteProtocol protocol) throws Exception {
        if (expectedReceptionChannelInfo.getChannelType() == 3) {
            if (receivedMessage.getReceptionChannelInfo().getChannelType() != 1 && receivedMessage.getReceptionChannelInfo().getChannelType() != 5 || !Objects.equals(receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), protocol.getOwnedIdentity())) {
                Logger.d("Protocol expected ReceptionChannelInfo mismatch.");
                throw new Exception();
            }
        } else if (expectedReceptionChannelInfo.getChannelType() == 4) {
            if (receivedMessage.getReceptionChannelInfo().getChannelType() != 1 && receivedMessage.getReceptionChannelInfo().getChannelType() != 5) {
                Logger.d("Protocol expected ReceptionChannelInfo mismatch.");
                throw new Exception();
            }
        } else if (expectedReceptionChannelInfo.getChannelType() == 6) {
            if (receivedMessage.getReceptionChannelInfo().getChannelType() != 1) {
                Logger.d("Protocol expected ReceptionChannelInfo mismatch.");
                throw new Exception();
            }
        } else if (!receivedMessage.getReceptionChannelInfo().equals(expectedReceptionChannelInfo)) {
            Logger.d("Protocol expected ReceptionChannelInfo mismatch.");
            throw new Exception();
        }
        this.protocol = protocol;
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void doExecute() {
        try {
            this.endState = this.executeStep();
            this.setFinished();
        }
        catch (Exception e) {
            this.cancel(null);
            Logger.x(e);
        }
    }

    public Identity getOwnedIdentity() {
        return this.protocol.getOwnedIdentity();
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.protocol.getJsonObjectMapper();
    }

    public ProtocolManagerSession getProtocolManagerSession() {
        return this.protocol.getProtocolManagerSession();
    }

    public PRNGService getPrng() {
        return this.protocol.getPrng();
    }

    public UID getProtocolInstanceUid() {
        return this.protocol.getProtocolInstanceUid();
    }

    public int getProtocolId() {
        return this.protocol.getProtocolId();
    }

    public abstract ConcreteProtocolState executeStep() throws Exception;

    public CoreProtocolMessage buildCoreProtocolMessage(SendChannelInfo sendChannelInfo) {
        return new CoreProtocolMessage(sendChannelInfo, this.getProtocolId(), this.getProtocolInstanceUid());
    }
}

