/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocol_engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.protocol.databases.LinkBetweenProtocolInstances;
import io.olvid.engine.protocol.databases.ProtocolInstance;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.GenericProtocolMessageToSend;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSessionFactory;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import java.sql.SQLException;

public final class ProtocolOperation
extends PriorityOperation {
    public static final int RFC_DELEGATE_NOT_SET = 1;
    public static final int RFC_MESSAGE_NOT_FOUND = 2;
    public static final int RFC_UNABLE_TO_RECONSTRUCT_PROTOCOL = 3;
    public static final int RFC_UNABLE_TO_RECONSTRUCT_MESSAGE = 4;
    public static final int RFC_UNABLE_TO_FIND_STEP_TO_EXECUTE = 5;
    public static final int RFC_THE_STEP_TO_EXECUTE_FAILED = 6;
    public static final int RFC_DIALOG_RESPONSE_CANNOT_BE_PROCESSED = 7;
    private final ProtocolManagerSessionFactory protocolManagerSessionFactory;
    private final UID receivedMessageUid;
    private final int protocolId;
    private final int failedAttempts;
    private final long creationTime;
    private final PRNGService prng;
    private final ObjectMapper jsonObjectMapper;
    private UID protocolInstanceUid;
    private Identity protocolOwnedIdentity;

    public UID getReceivedMessageUid() {
        return this.receivedMessageUid;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public UID getProtocolInstanceUid() {
        return this.protocolInstanceUid;
    }

    public Identity getProtocolOwnedIdentity() {
        return this.protocolOwnedIdentity;
    }

    public ProtocolOperation(ProtocolManagerSessionFactory protocolManagerSessionFactory, UID receivedMessageUid, int protocolId, int failedAttempts, PRNGService prng, ObjectMapper jsonObjectMapper, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(receivedMessageUid, onFinishCallback, onCancelCallback);
        this.protocolManagerSessionFactory = protocolManagerSessionFactory;
        this.receivedMessageUid = receivedMessageUid;
        this.protocolId = protocolId;
        this.failedAttempts = failedAttempts;
        this.creationTime = System.currentTimeMillis();
        this.prng = prng;
        this.jsonObjectMapper = jsonObjectMapper;
    }

    @Override
    public long getPriority() {
        return (long)this.failedAttempts << (int)(60L + ConcreteProtocol.getProtocolPriority(this.protocolId)) << (int)(50L + this.creationTime);
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        try (ProtocolManagerSession protocolManagerSession = this.protocolManagerSessionFactory.getSession();){
            boolean finished = false;
            try {
                GenericProtocolMessageToSend parentNotificationMessage;
                ConcreteProtocol protocol;
                boolean protocolInstanceNeedsToBeInserted;
                ProtocolInstance protocolInstance;
                ReceivedMessage message;
                block52: {
                    message = ReceivedMessage.get(protocolManagerSession, this.receivedMessageUid);
                    if (message == null) {
                        this.cancel(2);
                        return;
                    }
                    this.protocolInstanceUid = message.getProtocolInstanceUid();
                    this.protocolOwnedIdentity = message.getToIdentity();
                    protocolManagerSession.session.startTransaction();
                    protocolInstance = null;
                    protocolInstanceNeedsToBeInserted = false;
                    protocol = null;
                    try {
                        protocolInstance = ProtocolInstance.get(protocolManagerSession, this.protocolInstanceUid, this.protocolOwnedIdentity);
                        if (protocolInstance == null) {
                            protocolInstance = ProtocolInstance.createNotInDb(protocolManagerSession, this.protocolInstanceUid, this.protocolOwnedIdentity, this.protocolId, new InitialProtocolState());
                            protocolInstanceNeedsToBeInserted = true;
                            if (protocolInstance != null) {
                                protocol = ConcreteProtocol.getConcreteProtocolInInitialState(protocolManagerSession, this.protocolId, this.protocolInstanceUid, this.protocolOwnedIdentity, this.prng, this.jsonObjectMapper);
                            }
                            break block52;
                        }
                        protocol = ConcreteProtocol.getConcreteProtocol(protocolInstance, this.prng, this.jsonObjectMapper);
                        if (protocol == null) {
                            protocolInstance.delete();
                            protocolManagerSession.session.commit();
                        }
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
                if (protocol == null) {
                    this.cancel(3);
                    return;
                }
                ConcreteProtocolMessage concreteProtocolMessage = protocol.getConcreteProtocolMessage(message);
                if (concreteProtocolMessage == null) {
                    this.cancel(4);
                    return;
                }
                ProtocolStep stepToExecute = protocol.getStepToExecute(concreteProtocolMessage);
                if (stepToExecute == null) {
                    if (message.getUserDialogUuid() != null) {
                        this.cancel(7);
                        return;
                    }
                    this.cancel(5);
                    return;
                }
                if (protocol.requiresProtocolInstanceToBeInsertedBeforeInitialStep && protocolInstanceNeedsToBeInserted) {
                    try {
                        protocolInstance.insert();
                        protocolInstanceNeedsToBeInserted = false;
                    }
                    catch (SQLException e) {
                        Logger.x(e);
                        this.cancel(3);
                        if (finished) {
                            protocolManagerSession.session.commit();
                            this.setFinished();
                        } else {
                            protocolManagerSession.session.rollback();
                            if (this.hasNoReasonForCancel()) {
                                this.cancel(null);
                            }
                            this.processCancel();
                        }
                        if (protocolManagerSession == null) return;
                        protocolManagerSession.close();
                        return;
                    }
                }
                Logger.d("Executing step " + stepToExecute.getClass().getName() + "\n  - state: " + protocol.currentState.getClass().getName() + "\n  - message: " + concreteProtocolMessage.getClass().getName());
                OperationQueue queue = new OperationQueue();
                queue.queue(stepToExecute);
                queue.execute(1, "Engine-ProtocolOperation");
                queue.join();
                if (stepToExecute.isCancelled() || stepToExecute.getEndState() == null) {
                    Logger.i("Step " + String.valueOf(stepToExecute.getClass()) + " failed");
                    this.cancel(6);
                    return;
                }
                Logger.d("Finished step " + stepToExecute.getClass().getName() + ". It reached state " + stepToExecute.getEndState().getClass().getName());
                ConcreteProtocolState endState = stepToExecute.getEndState();
                protocol.updateCurrentState(endState);
                if (protocol.mayBeRunAsLinkedChildProtocol && (parentNotificationMessage = LinkBetweenProtocolInstances.getGenericProtocolMessageToSendWhenChildProtocolInstanceReachesAState(protocolManagerSession, protocol.getProtocolInstanceUid(), protocol.getOwnedIdentity(), protocol.getCurrentState())) != null) {
                    if (protocolManagerSession.channelDelegate == null) {
                        Logger.w("Unable to run notify parent protocol as the ChannelDelegate is not set yet.");
                        throw new Exception();
                    }
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, parentNotificationMessage.generateChannelProtocolMessageToSend(), this.prng);
                }
                if (protocol.hasReachedFinalState()) {
                    if (!protocolInstanceNeedsToBeInserted) {
                        protocolInstance.delete();
                    }
                    if (protocol.eraseReceivedMessagesAfterReachingAFinalState) {
                        for (ReceivedMessage receivedMessage : ReceivedMessage.getAll(protocolManagerSession, protocol.getProtocolInstanceUid(), protocol.getOwnedIdentity())) {
                            receivedMessage.delete();
                        }
                    }
                } else {
                    protocolInstance.updateCurrentState(endState, protocolInstanceNeedsToBeInserted);
                }
                message.delete();
                finished = true;
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                return;
            }
            finally {
                if (finished) {
                    protocolManagerSession.session.commit();
                    this.setFinished();
                } else {
                    protocolManagerSession.session.rollback();
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

