/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocol_engine;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.GenericProtocolMessageToSend;

public abstract class ConcreteProtocolMessage {
    private final CoreProtocolMessage coreProtocolMessage;

    protected ConcreteProtocolMessage(CoreProtocolMessage coreProtocolMessage) {
        this.coreProtocolMessage = coreProtocolMessage;
    }

    public abstract int getProtocolMessageId();

    public abstract Encoded[] getInputs();

    public int getProtocolId() {
        return this.coreProtocolMessage.getProtocolId();
    }

    public ReceptionChannelInfo getReceptionChannelInfo() {
        return this.coreProtocolMessage.getReceptionChannelInfo();
    }

    public Identity getToIdentity() {
        return this.coreProtocolMessage.getToIdentity();
    }

    public long getServerTimestamp() {
        return this.coreProtocolMessage.getServerTimestamp();
    }

    public UID getProtocolInstanceUid() {
        return this.coreProtocolMessage.getProtocolInstanceUid();
    }

    public GenericProtocolMessageToSend generateGenericProtocolMessageToSend() {
        if (this.coreProtocolMessage.getSendChannelInfo() == null) {
            return null;
        }
        return new GenericProtocolMessageToSend(this.coreProtocolMessage.getSendChannelInfo(), this.coreProtocolMessage.getProtocolId(), this.coreProtocolMessage.getProtocolInstanceUid(), this.getProtocolMessageId(), this.getInputs(), this.coreProtocolMessage.hasUserContent());
    }

    public ChannelProtocolMessageToSend generateChannelProtocolMessageToSend() {
        return this.generateGenericProtocolMessageToSend().generateChannelProtocolMessageToSend();
    }

    public ChannelDialogMessageToSend generateChannelDialogMessageToSend() {
        return this.generateGenericProtocolMessageToSend().generateChannelDialogMessageToSend();
    }

    public ChannelServerQueryMessageToSend generateChannelServerQueryMessageToSend() {
        return this.generateGenericProtocolMessageToSend().generateChannelServerQueryMessageToSend();
    }
}

