/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.datatypes;

import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.Encoded;

public class GenericProtocolMessageToSend {
    private final SendChannelInfo sendChannelInfo;
    private final Encoded encodedElements;
    private final boolean hasUserContent;

    public GenericProtocolMessageToSend(SendChannelInfo sendChannelInfo, int protocolId, UID protocolInstanceUid, int protocolMessageId, Encoded[] inputs, boolean hasUserContent) {
        this.sendChannelInfo = sendChannelInfo;
        this.encodedElements = GenericProtocolMessageToSend.encode(protocolId, protocolInstanceUid, protocolMessageId, inputs);
        this.hasUserContent = hasUserContent;
    }

    private static Encoded encode(int protocolId, UID protocolInstanceUid, int protocolMessageId, Encoded[] inputs) {
        return Encoded.of(new Encoded[]{Encoded.of(protocolId), Encoded.of(protocolInstanceUid), Encoded.of(protocolMessageId), Encoded.of(inputs)});
    }

    public ChannelProtocolMessageToSend generateChannelProtocolMessageToSend() {
        switch (this.sendChannelInfo.getChannelType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return new ChannelProtocolMessageToSend(this.sendChannelInfo, this.encodedElements, this.hasUserContent);
            }
        }
        return null;
    }

    public ChannelDialogMessageToSend generateChannelDialogMessageToSend() {
        switch (this.sendChannelInfo.getChannelType()) {
            case 5: {
                return new ChannelDialogMessageToSend(this.sendChannelInfo.getDialogUuid(), this.sendChannelInfo.getToIdentity(), this.sendChannelInfo.getDialogType(), this.encodedElements);
            }
        }
        return null;
    }

    public ChannelServerQueryMessageToSend generateChannelServerQueryMessageToSend() {
        switch (this.sendChannelInfo.getChannelType()) {
            case 6: {
                return new ChannelServerQueryMessageToSend(this.sendChannelInfo.getToIdentity(), this.sendChannelInfo.getServerQueryType(), this.encodedElements);
            }
        }
        return null;
    }
}

