/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.datatypes;

import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;

public class ChildToParentProtocolMessageInputs {
    private final UID childProtocolInstanceUid;
    private final int childProtocolReachedStateId;
    private final Encoded childProtocolEncodedState;

    public ChildToParentProtocolMessageInputs(UID childProtocolInstanceUid, ConcreteProtocolState childProtocolState) {
        this.childProtocolInstanceUid = childProtocolInstanceUid;
        this.childProtocolReachedStateId = childProtocolState.id;
        this.childProtocolEncodedState = childProtocolState.encode();
    }

    public UID getChildProtocolInstanceUid() {
        return this.childProtocolInstanceUid;
    }

    public int getChildProtocolReachedStateId() {
        return this.childProtocolReachedStateId;
    }

    public Encoded getChildProtocolEncodedState() {
        return this.childProtocolEncodedState;
    }

    public ChildToParentProtocolMessageInputs(Encoded[] inputs) throws Exception {
        if (inputs.length != 3) {
            throw new Exception();
        }
        this.childProtocolInstanceUid = inputs[0].decodeUid();
        this.childProtocolReachedStateId = (int)inputs[1].decodeLong();
        this.childProtocolEncodedState = inputs[2];
    }

    public Encoded[] toEncodedInputs() {
        return new Encoded[]{Encoded.of(this.childProtocolInstanceUid), Encoded.of(this.childProtocolReachedStateId), this.childProtocolEncodedState};
    }
}

