/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TrustEstablishmentCommitmentReceived
implements ObvDatabase {
    static final String TABLE_NAME = "trust_establishment_commitment_received";
    private final ProtocolManagerSession protocolManagerSession;
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final byte[] commitment;
    static final String COMMITMENT = "commitment";

    public static TrustEstablishmentCommitmentReceived create(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] commitment) {
        if (ownedIdentity == null || commitment == null) {
            return null;
        }
        try {
            TrustEstablishmentCommitmentReceived trustEstablishmentCommitmentReceived = new TrustEstablishmentCommitmentReceived(protocolManagerSession, ownedIdentity, commitment);
            trustEstablishmentCommitmentReceived.insert();
            return trustEstablishmentCommitmentReceived;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private TrustEstablishmentCommitmentReceived(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] commitment) {
        this.protocolManagerSession = protocolManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.commitment = commitment;
    }

    private TrustEstablishmentCommitmentReceived(ProtocolManagerSession protocolManagerSession, ResultSet res) throws SQLException {
        this.protocolManagerSession = protocolManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.commitment = res.getBytes(COMMITMENT);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS trust_establishment_commitment_received (owned_identity BLOB NOT NULL, commitment BLOB NOT NULL, CONSTRAINT PK_trust_establishment_commitment_received PRIMARY KEY (owned_identity, commitment));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("TrustEstablishmentCommitmentReceived.insert", "INSERT INTO trust_establishment_commitment_received VALUES (?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.commitment);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("TrustEstablishmentCommitmentReceived.delete", "DELETE FROM trust_establishment_commitment_received WHERE owned_identity = ? AND commitment = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.commitment);
            statement.executeUpdate();
        }
    }

    public static boolean exists(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] commitment) throws SQLException {
        if (ownedIdentity == null || commitment == null) {
            return false;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("TrustEstablishmentCommitmentReceived.exists", "SELECT 1 FROM trust_establishment_commitment_received WHERE owned_identity = ? AND commitment = ?;");){
            boolean bl;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, commitment);
                ResultSet res = statement.executeQuery();
                try {
                    bl = res.next();
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return bl;
        }
    }

    public static void deleteAllForOwnedIdentity(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("TrustEstablishmentCommitmentReceived.deleteAllForOwnedIdentity", "DELETE FROM trust_establishment_commitment_received WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

