/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.datatypes.GenericReceivedProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.UUID;

public class ReceivedMessage
implements ObvDatabase {
    static final String TABLE_NAME = "received_message";
    static final String GET_ALL_INDEX_NAME = "received_message_get_all_index";
    private final ProtocolManagerSession protocolManagerSession;
    private final UID uid;
    static final String UID_ = "uid";
    private final Identity toIdentity;
    static final String TO_IDENTITY = "to_identity";
    private final Encoded[] inputs;
    static final String INPUTS = "inputs";
    private final UUID userDialogUuid;
    static final String USER_DIALOG_UUID = "user_dialog_uuid";
    private final Encoded encodedResponse;
    static final String ENCODED_RESPONSE = "encoded_response";
    private final UID protocolInstanceUid;
    static final String PROTOCOL_INSTANCE_UID = "protocol_instance_uid";
    private final int protocolMessageId;
    static final String PROTOCOL_MESSAGE_ID = "protocol_message_id";
    private final int protocolId;
    static final String PROTOCOL_ID = "protocol_id";
    private final ReceptionChannelInfo receptionChannelInfo;
    static final String RECEPTION_CHANNEL_INFO = "reception_channel_info";
    private final long expirationTimestamp;
    static final String EXPIRATION_TIMESTAMP = "expiration_timestamp";
    private final long serverTimestamp;
    static final String SERVER_TIMESTAMP = "server_timestamp";
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED = 1L;

    public ProtocolManagerSession getProtocolManagerSession() {
        return this.protocolManagerSession;
    }

    public UID getUid() {
        return this.uid;
    }

    public Identity getToIdentity() {
        return this.toIdentity;
    }

    public Encoded[] getInputs() {
        return this.inputs;
    }

    public Encoded getEncodedResponse() {
        return this.encodedResponse;
    }

    public UUID getUserDialogUuid() {
        return this.userDialogUuid;
    }

    public UID getProtocolInstanceUid() {
        return this.protocolInstanceUid;
    }

    public int getProtocolMessageId() {
        return this.protocolMessageId;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public ReceptionChannelInfo getReceptionChannelInfo() {
        return this.receptionChannelInfo;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public static ReceivedMessage create(ProtocolManagerSession protocolManagerSession, GenericReceivedProtocolMessage message, PRNGService prng) {
        if (message == null || prng == null) {
            return null;
        }
        try {
            ReceivedMessage receivedMessage = new ReceivedMessage(protocolManagerSession, message.getToIdentity(), message.getInputs(), message.getUserDialogUuid(), message.getEncodedResponse(), message.getProtocolInstanceUid(), message.getProtocolMessageId(), message.getProtocolId(), message.getReceptionChannelInfo(), message.getServerTimestamp(), prng);
            receivedMessage.insert();
            return receivedMessage;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private ReceivedMessage(ProtocolManagerSession protocolManagerSession, Identity toIdentity, Encoded[] inputs, UUID userDialogUuid, Encoded encodedResponse, UID protocolInstanceUid, int protocolMessageId, int protocolId, ReceptionChannelInfo receptionChannelInfo, long serverTimestamp, PRNGService prng) {
        this.protocolManagerSession = protocolManagerSession;
        this.uid = new UID(prng);
        this.toIdentity = toIdentity;
        this.inputs = inputs;
        this.userDialogUuid = userDialogUuid;
        this.encodedResponse = encodedResponse;
        this.protocolInstanceUid = protocolInstanceUid;
        this.protocolMessageId = protocolMessageId;
        this.protocolId = protocolId;
        this.receptionChannelInfo = receptionChannelInfo;
        this.expirationTimestamp = System.currentTimeMillis() + 1296000000L;
        this.serverTimestamp = serverTimestamp;
    }

    private ReceivedMessage(ProtocolManagerSession protocolManagerSession, ResultSet res) throws SQLException {
        this.protocolManagerSession = protocolManagerSession;
        this.uid = new UID(res.getBytes(UID_));
        try {
            this.toIdentity = Identity.of(res.getBytes(TO_IDENTITY));
            this.inputs = new Encoded(res.getBytes(INPUTS)).decodeList();
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        String uuid = res.getString(USER_DIALOG_UUID);
        this.userDialogUuid = uuid == null ? null : UUID.fromString(uuid);
        byte[] udr = res.getBytes(ENCODED_RESPONSE);
        this.encodedResponse = udr == null ? null : new Encoded(udr);
        this.protocolInstanceUid = new UID(res.getBytes(PROTOCOL_INSTANCE_UID));
        this.protocolMessageId = res.getInt(PROTOCOL_MESSAGE_ID);
        this.protocolId = res.getInt(PROTOCOL_ID);
        try {
            this.receptionChannelInfo = ReceptionChannelInfo.of(new Encoded(res.getBytes(RECEPTION_CHANNEL_INFO)));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.expirationTimestamp = res.getLong(EXPIRATION_TIMESTAMP);
        this.serverTimestamp = res.getLong(SERVER_TIMESTAMP);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS received_message (uid BLOB PRIMARY KEY, to_identity BLOB NOT NULL, inputs BLOB NOT NULL, user_dialog_uuid VARCHAR, encoded_response BLOB, protocol_instance_uid BLOB NOT NULL, protocol_message_id INT NOT NULL, protocol_id INT NOT NULL, reception_channel_info BLOB NOT NULL, expiration_timestamp BIGINT NOT NULL, server_timestamp BIGINT NOT NULL);");
            statement.execute("CREATE INDEX IF NOT EXISTS received_message_get_all_index ON received_message(to_identity, protocol_instance_uid)");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 10 && newVersion >= 10) {
            Logger.d("MIGRATING `received_message` DATABASE FROM VERSION " + oldVersion + " TO 10");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE `received_message` ADD COLUMN `server_timestamp` BIGINT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 10;
        }
        if (oldVersion < 11 && newVersion >= 11) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `received_message` DATABASE FROM VERSION " + oldVersion + " TO 11");
                statement.execute("DELETE FROM received_message WHERE protocol_id = 5;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 11;
        }
        if (oldVersion < 32 && newVersion >= 32) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `received_message` DATABASE FROM VERSION " + oldVersion + " TO 32");
                statement.execute("ALTER TABLE `received_message` DROP COLUMN `associated_owned_identity`");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 32;
        }
        if (oldVersion < 46 && newVersion >= 46) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `received_message` DATABASE FROM VERSION " + oldVersion + " TO 46");
                statement.execute("CREATE INDEX IF NOT EXISTS `received_message_get_all_index` ON `received_message` (`to_identity`, `protocol_instance_uid`)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 46;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ReceivedMessage.insert", "INSERT INTO received_message VALUES (?,?,?,?,?, ?,?,?,?,?, ?);");){
            statement.setBytes(1, this.uid.getBytes());
            statement.setBytes(2, this.toIdentity.getBytes());
            statement.setBytes(3, Encoded.of(this.inputs).getBytes());
            if (this.userDialogUuid != null) {
                statement.setString(4, Logger.getUuidString(this.userDialogUuid));
            } else {
                statement.setNull(4, 12);
            }
            if (this.encodedResponse != null) {
                statement.setBytes(5, this.encodedResponse.getBytes());
            } else {
                statement.setNull(5, 2004);
            }
            statement.setBytes(6, this.protocolInstanceUid.getBytes());
            statement.setInt(7, this.protocolMessageId);
            statement.setInt(8, this.protocolId);
            statement.setBytes(9, this.receptionChannelInfo.encode().getBytes());
            statement.setLong(10, this.expirationTimestamp);
            statement.setLong(11, this.serverTimestamp);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.protocolManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ReceivedMessage.delete", "DELETE FROM received_message WHERE uid = ?;");){
            statement.setBytes(1, this.uid.getBytes());
            statement.executeUpdate();
        }
    }

    public static void deleteExpiredMessagesWithNoProtocol(ProtocolManagerSession protocolManagerSession) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ReceivedMessage.deleteExpiredMessagesWithNoProtocol", "DELETE FROM received_message WHERE uid IN  (SELECT received_message.uid FROM received_message LEFT JOIN protocol_instance ON protocol_instance.uid = received_message.protocol_instance_uid WHERE received_message.expiration_timestamp < ? AND protocol_instance.uid IS NULL);");){
            statement.setLong(1, System.currentTimeMillis());
            statement.executeUpdate();
        }
    }

    public static void deleteAllTransfer(ProtocolManagerSession protocolManagerSession) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ReceivedMessage.deleteAllTransfer", "DELETE FROM received_message WHERE protocol_id = ?;");){
            statement.setInt(1, 26);
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ReceivedMessage get(ProtocolManagerSession protocolManagerSession, UID receivedMessageUid) {
        if (receivedMessageUid == null) {
            return null;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ReceivedMessage.get", "SELECT * FROM received_message WHERE uid = ?;");){
            ReceivedMessage receivedMessage;
            block19: {
                ResultSet res;
                block17: {
                    ReceivedMessage receivedMessage2;
                    block18: {
                        statement.setBytes(1, receivedMessageUid.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            receivedMessage2 = new ReceivedMessage(protocolManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return receivedMessage2;
                }
                receivedMessage = null;
                if (res == null) break block19;
                res.close();
            }
            return receivedMessage;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public static ReceivedMessage[] getAll(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ReceivedMessage.getAll", "SELECT * FROM received_message WHERE to_identity = ? AND protocol_instance_uid = ?;");){
            ReceivedMessage[] receivedMessageArray;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, protocolInstanceUid.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ReceivedMessage> list = new ArrayList<ReceivedMessage>();
                    while (res.next()) {
                        list.add(new ReceivedMessage(protocolManagerSession, res));
                    }
                    receivedMessageArray = list.toArray(new ReceivedMessage[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return receivedMessageArray;
        }
    }

    public static ReceivedMessage[] getAll(ProtocolManagerSession protocolManagerSession) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ReceivedMessage.getAll2", "SELECT * FROM received_message;");){
            ReceivedMessage[] receivedMessageArray;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ReceivedMessage> list = new ArrayList<ReceivedMessage>();
                    while (res.next()) {
                        list.add(new ReceivedMessage(protocolManagerSession, res));
                    }
                    receivedMessageArray = list.toArray(new ReceivedMessage[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return receivedMessageArray;
        }
    }

    public static void deleteAllForOwnedIdentity(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ReceivedMessage.deleteAllForOwnedIdentity", "DELETE FROM received_message WHERE to_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 1L) != 0L && this.protocolManagerSession.protocolReceivedMessageProcessorDelegate != null) {
            this.protocolManagerSession.protocolReceivedMessageProcessorDelegate.processReceivedMessage(this.uid, this.protocolId);
        }
        this.commitHookBits = 0L;
    }
}

