/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ProtocolInstance
implements ObvDatabase {
    static final String TABLE_NAME = "protocol_instance";
    private final ProtocolManagerSession protocolManagerSession;
    private final UID uid;
    static final String UID_ = "uid";
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final int protocolId;
    static final String PROTOCOL_ID = "protocol_id";
    private int currentStateId;
    static final String CURRENT_STATE_ID = "current_state_id";
    private Encoded encodedCurrentState;
    static final String ENCODED_CURRENT_STATE = "encoded_current_state";

    public UID getUid() {
        return this.uid;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public int getCurrentStateId() {
        return this.currentStateId;
    }

    public Encoded getEncodedCurrentState() {
        return this.encodedCurrentState;
    }

    public ProtocolManagerSession getProtocolManagerSession() {
        return this.protocolManagerSession;
    }

    public void updateCurrentState(ConcreteProtocolState newState, boolean protocolInstanceNeedsToBeInserted) throws SQLException {
        this.currentStateId = newState.id;
        this.encodedCurrentState = newState.encode();
        if (protocolInstanceNeedsToBeInserted) {
            this.insert();
        } else {
            try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ProtocolInstance.updateCurrentState", "UPDATE protocol_instance SET current_state_id = ?, encoded_current_state = ?  WHERE uid = ? AND owned_identity = ?;");){
                statement.setInt(1, this.currentStateId);
                if (this.encodedCurrentState != null) {
                    statement.setBytes(2, this.encodedCurrentState.getBytes());
                } else {
                    statement.setNull(2, 2004);
                }
                statement.setBytes(3, this.uid.getBytes());
                statement.setBytes(4, this.ownedIdentity.getBytes());
                statement.executeUpdate();
            }
        }
    }

    public static ProtocolInstance createNotInDb(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, Identity ownedIdentity, int protocolId, ConcreteProtocolState protocolState) {
        if (protocolInstanceUid == null || ownedIdentity == null || protocolState == null) {
            return null;
        }
        return new ProtocolInstance(protocolManagerSession, protocolInstanceUid, ownedIdentity, protocolId, protocolState.id, protocolState.encode());
    }

    private ProtocolInstance(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, Identity ownedIdentity, int protocolId, int currentStateId, Encoded encodedCurrentState) {
        this.protocolManagerSession = protocolManagerSession;
        this.uid = protocolInstanceUid;
        this.ownedIdentity = ownedIdentity;
        this.protocolId = protocolId;
        this.currentStateId = currentStateId;
        this.encodedCurrentState = encodedCurrentState;
    }

    private ProtocolInstance(ProtocolManagerSession protocolManagerSession, ResultSet res) throws SQLException {
        this.protocolManagerSession = protocolManagerSession;
        this.uid = new UID(res.getBytes(UID_));
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.protocolId = res.getInt(PROTOCOL_ID);
        this.currentStateId = res.getInt(CURRENT_STATE_ID);
        byte[] bytes = res.getBytes(ENCODED_CURRENT_STATE);
        this.encodedCurrentState = bytes == null ? null : new Encoded(bytes);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS protocol_instance (uid BLOB NOT NULL, owned_identity BLOB NOT NULL, protocol_id INT NOT NULL, current_state_id INT NOT NULL, encoded_current_state BLOB, CONSTRAINT PK_protocol_instance PRIMARY KEY(uid, owned_identity));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 11 && newVersion >= 11) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING protocol_instance DATABASE FROM VERSION " + oldVersion + " TO 11");
                statement.execute("DELETE FROM protocol_instance WHERE protocol_id = 5;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 11;
        }
        if (oldVersion < 33 && newVersion >= 33) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING protocol_instance DATABASE FROM VERSION " + oldVersion + " TO 33");
                statement.execute("DELETE FROM protocol_instance WHERE protocol_id = 1;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 33;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ProtocolInstance.insert", "INSERT INTO protocol_instance VALUES (?,?,?,?,?);");){
            statement.setBytes(1, this.uid.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.protocolId);
            statement.setInt(4, this.currentStateId);
            if (this.encodedCurrentState != null) {
                statement.setBytes(5, this.encodedCurrentState.getBytes());
            } else {
                statement.setNull(5, 2004);
            }
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ProtocolInstance.delete", "DELETE FROM protocol_instance WHERE uid = ? AND owned_identity = ?;");){
            statement.setBytes(1, this.uid.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ProtocolInstance get(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, Identity ownedIdentity) {
        if (protocolInstanceUid == null || ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ProtocolInstance.get", "SELECT * FROM protocol_instance WHERE uid = ? AND owned_identity = ?;");){
            ProtocolInstance protocolInstance;
            block19: {
                ResultSet res;
                block17: {
                    ProtocolInstance protocolInstance2;
                    block18: {
                        statement.setBytes(1, protocolInstanceUid.getBytes());
                        statement.setBytes(2, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            protocolInstance2 = new ProtocolInstance(protocolManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return protocolInstance2;
                }
                protocolInstance = null;
                if (res == null) break block19;
                res.close();
            }
            return protocolInstance;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static void deleteAllForOwnedIdentity(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, UID excludedProtocolInstanceUid) throws SQLException {
        if (excludedProtocolInstanceUid == null) {
            try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ProtocolInstance.deleteAllForOwnedIdentity", "DELETE FROM protocol_instance WHERE owned_identity = ?;");){
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.executeUpdate();
            }
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ProtocolInstance.deleteAllForOwnedIdentity", "DELETE FROM protocol_instance WHERE owned_identity = ? AND uid != ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setBytes(2, excludedProtocolInstanceUid.getBytes());
            statement.executeUpdate();
        }
    }

    public static void deleteAllTransfer(ProtocolManagerSession protocolManagerSession) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ProtocolInstance.deleteAllTransfer", "DELETE FROM protocol_instance WHERE protocol_id = ?;");){
            statement.setInt(1, 26);
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

