/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.ProtocolInstance;
import io.olvid.engine.protocol.datatypes.ChildToParentProtocolMessageInputs;
import io.olvid.engine.protocol.datatypes.GenericProtocolMessageToSend;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class LinkBetweenProtocolInstances
implements ObvDatabase {
    static final String TABLE_NAME = "link_between_protocol_instances";
    private final ProtocolManagerSession protocolManagerSession;
    private final UID childProtocolInstanceUid;
    static final String CHILD_PROTOCOL_INSTANCE_UID = "child_protocol_instance_uid";
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final int expectedChildStateId;
    static final String EXPECTED_CHILD_STATE_ID = "expected_child_state_id";
    private final UID parentProtocolInstanceUid;
    static final String PARENT_PROTOCOL_INSTANCE_UID = "parent_protocol_instance_uid";
    private final int parentProtocolId;
    static final String PARENT_PROTOCOL_ID = "parent_protocol_id";
    private final int messageToSendId;
    static final String MESSAGE_TO_SEND_ID = "message_to_send_id";

    public UID getChildProtocolInstanceUid() {
        return this.childProtocolInstanceUid;
    }

    public UID getParentProtocolInstanceUid() {
        return this.parentProtocolInstanceUid;
    }

    public static LinkBetweenProtocolInstances create(ProtocolManagerSession protocolManagerSession, UID childProtocolInstanceUid, Identity ownedIdentity, int expectedChildStateId, UID parentProtocolInstanceUid, int parentProtocolId, int messageToSendId) {
        if (childProtocolInstanceUid == null || parentProtocolInstanceUid == null || ownedIdentity == null) {
            return null;
        }
        try {
            LinkBetweenProtocolInstances linkBetweenProtocolInstances = new LinkBetweenProtocolInstances(protocolManagerSession, childProtocolInstanceUid, ownedIdentity, expectedChildStateId, parentProtocolInstanceUid, parentProtocolId, messageToSendId);
            linkBetweenProtocolInstances.insert();
            return linkBetweenProtocolInstances;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private LinkBetweenProtocolInstances(ProtocolManagerSession protocolManagerSession, UID childProtocolInstanceUid, Identity ownedIdentity, int expectedChildStateId, UID parentProtocolInstanceUid, int parentProtocolId, int messageToSendId) {
        this.protocolManagerSession = protocolManagerSession;
        this.childProtocolInstanceUid = childProtocolInstanceUid;
        this.ownedIdentity = ownedIdentity;
        this.expectedChildStateId = expectedChildStateId;
        this.parentProtocolInstanceUid = parentProtocolInstanceUid;
        this.parentProtocolId = parentProtocolId;
        this.messageToSendId = messageToSendId;
    }

    private LinkBetweenProtocolInstances(ProtocolManagerSession protocolManagerSession, ResultSet res) throws SQLException {
        this.protocolManagerSession = protocolManagerSession;
        this.childProtocolInstanceUid = new UID(res.getBytes(CHILD_PROTOCOL_INSTANCE_UID));
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.expectedChildStateId = res.getInt(EXPECTED_CHILD_STATE_ID);
        this.parentProtocolInstanceUid = new UID(res.getBytes(PARENT_PROTOCOL_INSTANCE_UID));
        this.parentProtocolId = res.getInt(PARENT_PROTOCOL_ID);
        this.messageToSendId = res.getInt(MESSAGE_TO_SEND_ID);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS link_between_protocol_instances (child_protocol_instance_uid BLOB NOT NULL, owned_identity BLOB NOT NULL, expected_child_state_id INT NOT NULL, parent_protocol_instance_uid BLOB NOT NULL, parent_protocol_id INT NOT NULL, message_to_send_id INT NOT NULL, CONSTRAINT PK_link_between_protocol_instances PRIMARY KEY (child_protocol_instance_uid, owned_identity, expected_child_state_id), FOREIGN KEY (parent_protocol_instance_uid, owned_identity) REFERENCES protocol_instance(uid, owned_identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 11 && newVersion >= 11) {
            statement = session.createStatement();
            try {
                statement.execute("DELETE FROM link_between_protocol_instances WHERE parent_protocol_id = 5;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 11;
        }
        if (oldVersion < 12 && newVersion >= 12) {
            statement = session.createStatement();
            try {
                statement.execute("DELETE FROM link_between_protocol_instances AS p  WHERE NOT EXISTS ( SELECT 1 FROM protocol_instance  WHERE uid = p.parent_protocol_instance_uid AND owned_identity = p.owned_identity )");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 12;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("LinkBetweenProtocolInstances.insert", "INSERT INTO link_between_protocol_instances VALUES (?,?,?,?,?,?);");){
            statement.setBytes(1, this.childProtocolInstanceUid.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.expectedChildStateId);
            statement.setBytes(4, this.parentProtocolInstanceUid.getBytes());
            statement.setInt(5, this.parentProtocolId);
            statement.setInt(6, this.messageToSendId);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("LinkBetweenProtocolInstances.delete", "DELETE FROM link_between_protocol_instances WHERE child_protocol_instance_uid = ? AND owned_identity = ? AND expected_child_state_id = ?;");){
            statement.setBytes(1, this.childProtocolInstanceUid.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.expectedChildStateId);
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static LinkBetweenProtocolInstances get(ProtocolManagerSession protocolManagerSession, UID childProtocolInstanceUid, Identity ownedIdentity, int expectedChildStateId) {
        if (childProtocolInstanceUid == null || ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("LinkBetweenProtocolInstances.get", "SELECT * FROM link_between_protocol_instances WHERE child_protocol_instance_uid = ? AND owned_identity = ? AND expected_child_state_id = ?;");){
            LinkBetweenProtocolInstances linkBetweenProtocolInstances;
            block19: {
                ResultSet res;
                block17: {
                    LinkBetweenProtocolInstances linkBetweenProtocolInstances2;
                    block18: {
                        statement.setBytes(1, childProtocolInstanceUid.getBytes());
                        statement.setBytes(2, ownedIdentity.getBytes());
                        statement.setInt(3, expectedChildStateId);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            linkBetweenProtocolInstances2 = new LinkBetweenProtocolInstances(protocolManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return linkBetweenProtocolInstances2;
                }
                linkBetweenProtocolInstances = null;
                if (res == null) break block19;
                res.close();
            }
            return linkBetweenProtocolInstances;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static LinkBetweenProtocolInstances[] getAllParentLinks(ProtocolManagerSession protocolManagerSession, UID childProtocolInstanceUid, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("LinkBetweenProtocolInstances.getAllParentLinks", "SELECT * FROM link_between_protocol_instances WHERE child_protocol_instance_uid = ? AND owned_identity = ?;");){
            LinkBetweenProtocolInstances[] linkBetweenProtocolInstancesArray;
            block13: {
                statement.setBytes(1, childProtocolInstanceUid.getBytes());
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<LinkBetweenProtocolInstances> list = new ArrayList<LinkBetweenProtocolInstances>();
                    while (res.next()) {
                        list.add(new LinkBetweenProtocolInstances(protocolManagerSession, res));
                    }
                    linkBetweenProtocolInstancesArray = list.toArray(new LinkBetweenProtocolInstances[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return linkBetweenProtocolInstancesArray;
        }
    }

    public static LinkBetweenProtocolInstances[] getAllChildLinks(ProtocolManagerSession protocolManagerSession, UID parentProtocolInstanceUid, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("LinkBetweenProtocolInstances.getAllChildLinks", "SELECT * FROM link_between_protocol_instances WHERE parent_protocol_instance_uid = ? AND owned_identity = ?;");){
            LinkBetweenProtocolInstances[] linkBetweenProtocolInstancesArray;
            block13: {
                statement.setBytes(1, parentProtocolInstanceUid.getBytes());
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<LinkBetweenProtocolInstances> list = new ArrayList<LinkBetweenProtocolInstances>();
                    while (res.next()) {
                        list.add(new LinkBetweenProtocolInstances(protocolManagerSession, res));
                    }
                    linkBetweenProtocolInstancesArray = list.toArray(new LinkBetweenProtocolInstances[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return linkBetweenProtocolInstancesArray;
        }
    }

    public static void deleteAllForOwnedIdentity(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("LinkBetweenProtocolInstances.deleteAllForOwnedIdentity", "DELETE FROM link_between_protocol_instances WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static GenericProtocolMessageToSend getGenericProtocolMessageToSendWhenChildProtocolInstanceReachesAState(ProtocolManagerSession protocolManagerSession, UID childProtocolInstanceUid, Identity ownedIdentity, ConcreteProtocolState childProtocolState) {
        LinkBetweenProtocolInstances linkBetweenProtocolInstances = LinkBetweenProtocolInstances.get(protocolManagerSession, childProtocolInstanceUid, ownedIdentity, childProtocolState.id);
        if (linkBetweenProtocolInstances == null) {
            return null;
        }
        Logger.d("Found a LinkBetweenProtocolInstances");
        Encoded[] inputs = new ChildToParentProtocolMessageInputs(childProtocolInstanceUid, childProtocolState).toEncodedInputs();
        ProtocolInstance parentProtocolInstance = ProtocolInstance.get(protocolManagerSession, linkBetweenProtocolInstances.parentProtocolInstanceUid, linkBetweenProtocolInstances.ownedIdentity);
        if (parentProtocolInstance == null) {
            return null;
        }
        try {
            linkBetweenProtocolInstances.delete();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new GenericProtocolMessageToSend(SendChannelInfo.createLocalChannelInfo(parentProtocolInstance.getOwnedIdentity()), parentProtocolInstance.getProtocolId(), parentProtocolInstance.getUid(), linkBetweenProtocolInstances.messageToSendId, inputs, false);
    }

    @Override
    public void wasCommitted() {
    }
}

