/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.protocol.databases.ProtocolInstance;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ChannelCreationProtocolInstance
implements ObvDatabase {
    static final String TABLE_NAME = "channel_creation_protocol_instance";
    private final ProtocolManagerSession protocolManagerSession;
    private final UID contactDeviceUid;
    static final String CONTACT_DEVICE_UID = "contact_device_uid";
    private final Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final UID protocolInstanceUid;
    static final String PROTOCOL_INSTANCE_UID = "protocol_instance_uid";

    public UID getProtocolInstanceUid() {
        return this.protocolInstanceUid;
    }

    public static ChannelCreationProtocolInstance create(ProtocolManagerSession protocolManagerSession, UID contactDeviceUid, Identity contactIdentity, Identity ownedIdentity, UID protocolInstanceUid) {
        if (contactDeviceUid == null || contactIdentity == null || ownedIdentity == null || protocolInstanceUid == null) {
            return null;
        }
        ProtocolInstance protocolInstance = ProtocolInstance.get(protocolManagerSession, protocolInstanceUid, ownedIdentity);
        if (protocolInstance == null || protocolInstance.getProtocolId() != 2 && protocolInstance.getProtocolId() != 22) {
            return null;
        }
        try {
            ChannelCreationProtocolInstance channelCreationProtocolInstance = new ChannelCreationProtocolInstance(protocolManagerSession, contactDeviceUid, contactIdentity, ownedIdentity, protocolInstanceUid);
            channelCreationProtocolInstance.insert();
            return channelCreationProtocolInstance;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private ChannelCreationProtocolInstance(ProtocolManagerSession protocolManagerSession, UID contactDeviceUid, Identity contactIdentity, Identity ownedIdentity, UID protocolInstanceUid) {
        this.protocolManagerSession = protocolManagerSession;
        this.contactDeviceUid = contactDeviceUid;
        this.contactIdentity = contactIdentity;
        this.ownedIdentity = ownedIdentity;
        this.protocolInstanceUid = protocolInstanceUid;
    }

    private ChannelCreationProtocolInstance(ProtocolManagerSession protocolManagerSession, ResultSet res) throws SQLException {
        this.protocolManagerSession = protocolManagerSession;
        this.contactDeviceUid = new UID(res.getBytes(CONTACT_DEVICE_UID));
        try {
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.protocolInstanceUid = new UID(res.getBytes(PROTOCOL_INSTANCE_UID));
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS channel_creation_protocol_instance (contact_device_uid BLOB NOT NULL, contact_identity BLOB NOT NULL, owned_identity BLOB NOT NULL, protocol_instance_uid BLOB NOT NULL, CONSTRAINT PK_channel_creation_protocol_instance PRIMARY KEY (contact_device_uid, contact_identity, owned_identity), FOREIGN KEY (protocol_instance_uid, owned_identity) REFERENCES protocol_instance(uid, owned_identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 12 && newVersion >= 12) {
            try (Statement statement = session.createStatement();){
                statement.execute("DELETE FROM channel_creation_protocol_instance AS p  WHERE NOT EXISTS ( SELECT 1 FROM protocol_instance  WHERE uid = p.protocol_instance_uid AND owned_identity = p.owned_identity )");
            }
            oldVersion = 12;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ChannelCreationProtocolInstance.insert", "INSERT INTO channel_creation_protocol_instance VALUES (?,?,?,?);");){
            statement.setBytes(1, this.contactDeviceUid.getBytes());
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setBytes(4, this.protocolInstanceUid.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ChannelCreationProtocolInstance.delete", "DELETE FROM channel_creation_protocol_instance WHERE contact_device_uid = ? AND contact_identity = ? AND owned_identity = ?;");){
            statement.setBytes(1, this.contactDeviceUid.getBytes());
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static ChannelCreationProtocolInstance get(ProtocolManagerSession protocolManagerSession, UID contactDeviceUid, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        if (contactDeviceUid == null || ownedIdentity == null || contactIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ChannelCreationProtocolInstance.get", "SELECT * FROM channel_creation_protocol_instance WHERE contact_device_uid = ? AND contact_identity = ? AND owned_identity = ?;");){
            ChannelCreationProtocolInstance channelCreationProtocolInstance;
            block17: {
                ResultSet res;
                block15: {
                    ChannelCreationProtocolInstance channelCreationProtocolInstance2;
                    block16: {
                        statement.setBytes(1, contactDeviceUid.getBytes());
                        statement.setBytes(2, contactIdentity.getBytes());
                        statement.setBytes(3, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            channelCreationProtocolInstance2 = new ChannelCreationProtocolInstance(protocolManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return channelCreationProtocolInstance2;
                }
                channelCreationProtocolInstance = null;
                if (res == null) break block17;
                res.close();
            }
            return channelCreationProtocolInstance;
        }
    }

    public static ChannelCreationProtocolInstance[] getAllForContact(ProtocolManagerSession protocolManagerSession, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        if (ownedIdentity == null || contactIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ChannelCreationProtocolInstance.getAllForContact", "SELECT * FROM channel_creation_protocol_instance WHERE contact_identity = ? AND owned_identity = ?;");){
            ChannelCreationProtocolInstance[] channelCreationProtocolInstanceArray;
            block14: {
                statement.setBytes(1, contactIdentity.getBytes());
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ChannelCreationProtocolInstance> list = new ArrayList<ChannelCreationProtocolInstance>();
                    while (res.next()) {
                        list.add(new ChannelCreationProtocolInstance(protocolManagerSession, res));
                    }
                    channelCreationProtocolInstanceArray = list.toArray(new ChannelCreationProtocolInstance[0]);
                    if (res == null) break block14;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return channelCreationProtocolInstanceArray;
        }
    }

    public static void deleteAllForOwnedIdentity(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ChannelCreationProtocolInstance.deleteAllForOwnedIdentity", "DELETE FROM channel_creation_protocol_instance WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

