/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.notification;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.metamanager.MetaManager;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.ObvManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class NotificationManager
implements NotificationListeningDelegate,
NotificationPostingDelegate,
ObvManager {
    private long instanceCounter = 0L;
    private final HashMap<String, HashMap<Long, WeakReference<NotificationListener>>> listeners = new HashMap();
    private final ReentrantLock listenersLock = new ReentrantLock();

    public NotificationManager(MetaManager metaManager) {
        metaManager.registerImplementedDelegates(this);
    }

    @Override
    public int initialQueueingPriority() {
        return 1000;
    }

    @Override
    public void initialisationComplete() {
    }

    private synchronized long getInstanceNumber() {
        long instanceNumber = this.instanceCounter++;
        return instanceNumber;
    }

    @Override
    public long addListener(String notificationName, NotificationListener notificationListener) {
        this.listenersLock.lock();
        long listenerNumber = this.getInstanceNumber();
        HashMap<Long, WeakReference<NotificationListener>> notificationObservers = this.listeners.get(notificationName);
        if (notificationObservers == null) {
            notificationObservers = new HashMap();
            this.listeners.put(notificationName, notificationObservers);
        }
        WeakReference<NotificationListener> weakReference = new WeakReference<NotificationListener>(notificationListener);
        notificationObservers.put(listenerNumber, weakReference);
        this.listenersLock.unlock();
        return listenerNumber;
    }

    @Override
    public void removeListener(String notificationName, long notificationListenerNumber) {
        this.listenersLock.lock();
        HashMap<Long, WeakReference<NotificationListener>> notificationObservers = this.listeners.get(notificationName);
        if (notificationObservers != null) {
            notificationObservers.remove(notificationListenerNumber);
        }
        this.listenersLock.unlock();
    }

    @Override
    public void postNotification(String notificationName, Map<String, Object> userInfo) {
        Logger.d("Posting notification with name " + notificationName);
        this.listenersLock.lock();
        HashMap<Long, WeakReference<NotificationListener>> notificationObservers = this.listeners.get(notificationName);
        if (notificationObservers != null) {
            notificationObservers = new HashMap<Long, WeakReference<NotificationListener>>(notificationObservers);
            this.listenersLock.unlock();
            for (Map.Entry<Long, WeakReference<NotificationListener>> entry : notificationObservers.entrySet()) {
                NotificationListener listener = (NotificationListener)entry.getValue().get();
                if (listener == null) {
                    this.removeListener(notificationName, entry.getKey());
                    continue;
                }
                listener.callback(notificationName, userInfo);
            }
        } else {
            this.listenersLock.unlock();
        }
    }
}

