/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndLong;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networksend.coordinators.SendReturnReceiptCoordinator;
import io.olvid.engine.networksend.databases.ReturnReceipt;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.ReturnReceiptAndEncryptedPayload;
import io.olvid.engine.networksend.operations.UploadReturnReceiptServerMethod;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class UploadReturnReceiptOperation
extends Operation {
    public static final int RFC_RETURN_RECEIPT_NOT_FOUND = 1;
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String server;
    private final PRNG prng;
    private final SendReturnReceiptCoordinator.ReturnReceiptBatchProvider returnReceiptBatchProvider;
    private final List<IdentityAndLong> identityInactiveReturnReceiptIds;
    private IdentityAndLong[] returnReceiptOwnedIdentitiesAndIds;

    public UploadReturnReceiptOperation(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String server, PRNG prng, SendReturnReceiptCoordinator.ReturnReceiptBatchProvider returnReceiptBatchProvider, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(UploadReturnReceiptOperation.computeUniqueUid(server), onFinishCallback, onCancelCallback);
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.server = server;
        this.prng = prng;
        this.returnReceiptBatchProvider = returnReceiptBatchProvider;
        this.identityInactiveReturnReceiptIds = new ArrayList<IdentityAndLong>();
    }

    private static UID computeUniqueUid(String server) {
        Hash sha256 = Suite.getHash("sha-256");
        return new UID(sha256.digest(server.getBytes(StandardCharsets.UTF_8)));
    }

    public String getServer() {
        return this.server;
    }

    public IdentityAndLong[] getReturnReceiptOwnedIdentitiesAndIds() {
        return this.returnReceiptOwnedIdentitiesAndIds;
    }

    public List<IdentityAndLong> getIdentityInactiveReturnReceiptIds() {
        return this.identityInactiveReturnReceiptIds;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        finished = false;
        try {
            sendManagerSession = this.sendManagerSessionFactory.getSession();
            try {
                try {
                    this.returnReceiptOwnedIdentitiesAndIds = this.returnReceiptBatchProvider.getBatchOFReturnReceiptIds();
                    returnReceiptAndEncryptedPayloads = new ArrayList<ReturnReceiptAndEncryptedPayload>();
                    Logger.d("UploadReturnReceiptOperation uploading a batch of " + this.returnReceiptOwnedIdentitiesAndIds.length);
                    returnReceiptIdsByIdentity = new HashMap<Identity, ArrayList<Long>>();
                    for (IdentityAndLong identityAndUid : this.returnReceiptOwnedIdentitiesAndIds) {
                        list = (ArrayList<Long>)returnReceiptIdsByIdentity.get(identityAndUid.identity);
                        if (list == null) {
                            list = new ArrayList<Long>();
                            returnReceiptIdsByIdentity.put(identityAndUid.identity, list);
                        }
                        list.add(identityAndUid.lng);
                    }
                    var5_9 = returnReceiptIdsByIdentity.entrySet().iterator();
                    block20: while (true) {
                        if (var5_9.hasNext()) {
                            var6_11 = (Map.Entry)var5_9.next();
                            ownedIdentity = (Identity)var6_11.getKey();
                            returnReceiptIds = (List)var6_11.getValue();
                            if (!sendManagerSession.identityDelegate.isActiveOwnedIdentity(sendManagerSession.session, ownedIdentity)) {
                                list = returnReceiptIds.iterator();
                                while (true) {
                                    if (!list.hasNext()) continue block20;
                                    returnReceiptId = (Long)list.next();
                                    this.identityInactiveReturnReceiptIds.add(new IdentityAndLong(ownedIdentity, returnReceiptId));
                                }
                            }
                        } else {
                            if (this.cancelWasRequested()) {
                                return;
                            }
                            serverMethod = new UploadReturnReceiptServerMethod(this.server, returnReceiptAndEncryptedPayloads);
                            serverMethod.setSslSocketFactory(this.sslSocketFactory);
                            var6_12 = serverMethod.execute(true);
                            sendManagerSession.session.startTransaction();
                            switch (var6_12) {
                                case 0: {
                                    var7_15 = returnReceiptAndEncryptedPayloads.iterator();
                                    while (true) {
                                        if (!var7_15.hasNext()) {
                                            finished = true;
                                            return;
                                        }
                                        returnReceiptAndEncryptedPayload = (ReturnReceiptAndEncryptedPayload)var7_15.next();
                                        returnReceiptAndEncryptedPayload.returnReceipt.delete();
                                    }
                                }
                            }
                            this.cancel(null);
                            return;
                        }
                        var10_18 = returnReceipts = ReturnReceipt.getMany(sendManagerSession, returnReceiptIds.toArray(new Long[0]));
                        var11_19 = var10_18.length;
                        var12_20 = 0;
                        while (true) {
                            if (var12_20 >= var11_19) ** break;
                            returnReceipt = var10_18[var12_20];
                            payload = returnReceipt.getAttachmentNumber() == null ? Encoded.of(new Encoded[]{Encoded.of(returnReceipt.getOwnedIdentity()), Encoded.of(returnReceipt.getStatus())}) : Encoded.of(new Encoded[]{Encoded.of(returnReceipt.getOwnedIdentity()), Encoded.of(returnReceipt.getStatus()), Encoded.of(returnReceipt.getAttachmentNumber().intValue())});
                            authEnc = Suite.getAuthEnc(returnReceipt.getKey());
                            encryptedPayload = authEnc.encrypt(returnReceipt.getKey(), payload.getBytes(), this.prng);
                            returnReceiptAndEncryptedPayloads.add(new ReturnReceiptAndEncryptedPayload(returnReceipt, encryptedPayload));
                            ++var12_20;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                    sendManagerSession.session.rollback();
                    return;
                }
                finally {
                    if (finished) {
                        sendManagerSession.session.commit();
                        this.setFinished();
                    } else {
                        if (this.hasNoReasonForCancel()) {
                            this.cancel(null);
                        }
                        this.processCancel();
                    }
                }
            }
            finally {
                if (sendManagerSession != null) {
                    sendManagerSession.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

