/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.TryToDeleteMessageAndAttachmentsOperation;
import io.olvid.engine.networksend.operations.UploadMessageAndGetUidsOperation;
import javax.net.ssl.SSLSocketFactory;

public class UploadMessageCompositeOperation
extends Operation {
    public static final int RFC_MESSAGE_NOT_FOUND_IN_DATABASE = 1;
    public static final int RFC_NETWORK_ERROR = 3;
    public static final int RFC_IDENTITY_IS_INACTIVE = 10;
    private final Identity ownedIdentity;
    private final UID messageUid;
    private final Operation[] suboperations;

    public UploadMessageCompositeOperation(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, Identity ownedIdentity, UID messageUid, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(IdentityAndUid.computeUniqueUid(ownedIdentity, messageUid), onFinishCallback, onCancelCallback);
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
        this.suboperations = new Operation[2];
        this.suboperations[0] = new UploadMessageAndGetUidsOperation(sendManagerSessionFactory, sslSocketFactory, ownedIdentity, messageUid);
        this.suboperations[1] = new TryToDeleteMessageAndAttachmentsOperation(sendManagerSessionFactory, ownedIdentity, messageUid);
        for (int i = 0; i < this.suboperations.length - 1; ++i) {
            this.suboperations[i + 1].addDependency(this.suboperations[i]);
        }
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    @Override
    public void doCancel() {
        for (Operation op : this.suboperations) {
            op.cancel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try {
            OperationQueue queue = new OperationQueue();
            for (Operation op : this.suboperations) {
                queue.queue(op);
            }
            queue.execute(1, "UploadMessageCompositeOperation");
            queue.join();
            if (this.cancelWasRequested()) {
                return;
            }
            for (Operation op : this.suboperations) {
                if (!op.isCancelled()) continue;
                this.cancel(op.getReasonForCancel());
                return;
            }
            finished = true;
        }
        catch (Exception e) {
            Logger.x(e);
        }
        finally {
            if (finished) {
                this.setFinished();
            } else {
                this.cancel(null);
                this.processCancel();
            }
        }
    }
}

