/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networksend.databases.MessageHeader;
import io.olvid.engine.networksend.databases.OutboxAttachment;

class UploadMessageAndGetUidsServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/uploadMessageAndGetUids";
    private final String server;
    private final EncryptedBytes encryptedMessage;
    private final EncryptedBytes encryptedExtendedMessage;
    private final boolean isApplicationMessage;
    private final boolean isVoipMessage;
    private final MessageHeader[] headers;
    private final OutboxAttachment[] attachments;
    private UID uidFromServer = null;
    private byte[] nonce = null;
    private long timestampFromServer = 0L;
    private String[][] attachmentChunkUploadPrivateUrls = null;

    public UID getUidFromServer() {
        return this.uidFromServer;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public long getTimestampFromServer() {
        return this.timestampFromServer;
    }

    public String[][] getAttachmentChunkUploadPrivateUrls() {
        return this.attachmentChunkUploadPrivateUrls;
    }

    UploadMessageAndGetUidsServerMethod(String server, EncryptedBytes encryptedMessage, EncryptedBytes encryptedExtendedMessage, boolean isApplicationMessage, boolean isVoipMessage, MessageHeader[] headers, OutboxAttachment[] attachments) {
        this.server = server;
        this.encryptedMessage = encryptedMessage;
        this.encryptedExtendedMessage = encryptedExtendedMessage;
        this.isApplicationMessage = isApplicationMessage;
        this.isVoipMessage = isVoipMessage;
        this.headers = headers;
        this.attachments = attachments;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        Encoded[] encodedHeaders = new Encoded[this.headers.length * 3];
        for (int i = 0; i < this.headers.length; ++i) {
            encodedHeaders[3 * i] = Encoded.of(this.headers[i].getDeviceUid());
            encodedHeaders[3 * i + 1] = Encoded.of(this.headers[i].getWrappedKey());
            encodedHeaders[3 * i + 2] = Encoded.of(this.headers[i].getToIdentity());
        }
        Encoded[] encodedAttachmentLengths = new Encoded[this.attachments.length];
        Encoded[] encodedChunkLengths = new Encoded[this.attachments.length];
        for (int i = 0; i < this.attachments.length; ++i) {
            encodedAttachmentLengths[i] = Encoded.of(this.attachments[i].getCiphertextLength());
            encodedChunkLengths[i] = Encoded.of(this.attachments[i].getCiphertextChunkLength());
        }
        if (this.encryptedExtendedMessage == null || this.encryptedExtendedMessage.length > 51200) {
            return Encoded.of(new Encoded[]{Encoded.of(encodedHeaders), Encoded.of(this.encryptedMessage), Encoded.of(this.isApplicationMessage), Encoded.of(this.isVoipMessage), Encoded.of(encodedAttachmentLengths), Encoded.of(encodedChunkLengths)}).getBytes();
        }
        return Encoded.of(new Encoded[]{Encoded.of(encodedHeaders), Encoded.of(this.encryptedMessage), Encoded.of(this.encryptedExtendedMessage), Encoded.of(this.isApplicationMessage), Encoded.of(this.isVoipMessage), Encoded.of(encodedAttachmentLengths), Encoded.of(encodedChunkLengths)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                this.uidFromServer = receivedData[0].decodeUid();
                this.nonce = receivedData[1].decodeBytes();
                this.timestampFromServer = receivedData[2].decodeLong();
                Encoded[] encodeds = receivedData[3].decodeList();
                if (encodeds.length != this.attachments.length) {
                    throw new Exception();
                }
                this.attachmentChunkUploadPrivateUrls = new String[this.attachments.length][];
                for (int i = 0; i < encodeds.length; ++i) {
                    this.attachmentChunkUploadPrivateUrls[i] = encodeds[i].decodeStringArray();
                }
            }
            catch (Exception e) {
                Logger.x(e);
                this.returnStatus = (byte)-125;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return true;
    }
}

