/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.networksend.databases.MessageHeader;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.databases.OutboxMessage;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.UploadMessageAndGetUidsServerMethod;
import java.sql.SQLException;
import java.util.HashMap;
import javax.net.ssl.SSLSocketFactory;

public class UploadMessageAndGetUidsOperation
extends Operation {
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final Identity ownedIdentity;
    private final UID messageUid;

    public UploadMessageAndGetUidsOperation(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, Identity ownedIdentity, UID messageUid) {
        super(IdentityAndUid.computeUniqueUid(ownedIdentity, messageUid), null, null);
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
            try {
                OutboxMessage outboxMessage = OutboxMessage.get(sendManagerSession, this.ownedIdentity, this.messageUid);
                if (outboxMessage == null) {
                    this.cancel(1);
                    return;
                }
                if (outboxMessage.getUidFromServer() != null) {
                    finished = true;
                    return;
                }
                MessageHeader[] headers = outboxMessage.getHeaders();
                OutboxAttachment[] attachments = outboxMessage.getAttachments();
                if (this.cancelWasRequested()) {
                    return;
                }
                UploadMessageAndGetUidsServerMethod serverMethod = new UploadMessageAndGetUidsServerMethod(outboxMessage.getServer(), outboxMessage.getEncryptedContent(), outboxMessage.getEncryptedExtendedContent(), outboxMessage.isApplicationMessage(), outboxMessage.isVoipMessage(), headers, attachments);
                serverMethod.setSslSocketFactory(this.sslSocketFactory);
                boolean sendMessage = sendManagerSession.identityDelegate.isActiveOwnedIdentity(sendManagerSession.session, this.ownedIdentity) || !sendManagerSession.identityDelegate.isOwnedIdentity(sendManagerSession.session, this.ownedIdentity);
                byte returnStatus = serverMethod.execute(sendMessage);
                sendManagerSession.session.startTransaction();
                switch (returnStatus) {
                    case 0: {
                        outboxMessage.setUidFromServer(serverMethod.getUidFromServer(), serverMethod.getNonce(), serverMethod.getTimestampFromServer());
                        String[][] attachmentChunkUploadPrivateUrls = serverMethod.getAttachmentChunkUploadPrivateUrls();
                        int i = 0;
                        while (true) {
                            if (i >= attachments.length) {
                                finished = true;
                                return;
                            }
                            attachments[i].setChunkUploadPrivateUrls(attachmentChunkUploadPrivateUrls[i]);
                            ++i;
                        }
                    }
                    case -114: {
                        this.cancel(10);
                        return;
                    }
                    case -125: {
                        outboxMessage.setUidFromServer(new UID(new byte[32]), new byte[0], 0L);
                        OutboxAttachment[] i = attachments;
                        int n = i.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                finished = true;
                                return;
                            }
                            OutboxAttachment attachment = i[n2];
                            attachment.setCancelExternallyRequested();
                            attachment.setCancelProcessed();
                            ++n2;
                        }
                    }
                }
                if (returnStatus == 24 || System.currentTimeMillis() > outboxMessage.getCreationTimestamp() + 2592000000L) {
                    outboxMessage.setUidFromServer(new UID(new byte[32]), new byte[0], 0L);
                    OutboxAttachment[] i = attachments;
                    int n = i.length;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n) {
                            HashMap<String, Object> userInfo = new HashMap<String, Object>();
                            userInfo.put("uid", outboxMessage.getUid());
                            userInfo.put("ownedIdentity", outboxMessage.getOwnedIdentity());
                            sendManagerSession.notificationPostingDelegate.postNotification("network_send_notification_message_upload_failed", userInfo);
                            finished = true;
                            return;
                        }
                        OutboxAttachment attachment = i[n3];
                        attachment.setCancelExternallyRequested();
                        attachment.setCancelProcessed();
                        ++n3;
                    }
                }
                this.cancel(3);
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                sendManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    sendManagerSession.session.commit();
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

