/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.databases.OutboxMessage;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.secure_io.SecureFile;
import java.sql.SQLException;

public class TryToDeleteMessageAndAttachmentsOperation
extends Operation {
    private final Identity ownedIdentity;
    private final UID messageUid;
    private final SendManagerSessionFactory sendManagerSessionFactory;

    public TryToDeleteMessageAndAttachmentsOperation(SendManagerSessionFactory sendManagerSessionFactory, Identity ownedIdentity, UID messageUid) {
        super(IdentityAndUid.computeUniqueUid(ownedIdentity, messageUid), null, null);
        this.ownedIdentity = ownedIdentity;
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.messageUid = messageUid;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
            try {
                OutboxAttachment[] outboxAttachments;
                OutboxMessage outboxMessage;
                try {
                    outboxMessage = OutboxMessage.get(sendManagerSession, this.ownedIdentity, this.messageUid);
                }
                catch (SQLException e) {
                    if (finished) {
                        sendManagerSession.session.commit();
                        this.setFinished();
                    } else {
                        this.cancel(null);
                        this.processCancel();
                    }
                    if (sendManagerSession == null) return;
                    sendManagerSession.close();
                    return;
                }
                if (outboxMessage == null) {
                    finished = true;
                    return;
                }
                if (outboxMessage.getUidFromServer() == null) {
                    finished = true;
                    return;
                }
                for (OutboxAttachment outboxAttachment : outboxAttachments = outboxMessage.getAttachments()) {
                    if (outboxAttachment.isAcknowledged()) continue;
                    finished = true;
                    return;
                }
                for (OutboxAttachment outboxAttachment : outboxAttachments) {
                    SecureFile attachmentFile;
                    if (!outboxAttachment.shouldBeDeletedAfterSend() || !(attachmentFile = new SecureFile(sendManagerSession.engineBaseDirectory, outboxAttachment.getUrl())).isFile() || attachmentFile.delete()) continue;
                    this.cancel(null);
                    return;
                }
                sendManagerSession.session.startTransaction();
                outboxMessage.delete();
                finished = true;
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                sendManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    sendManagerSession.session.commit();
                    this.setFinished();
                } else {
                    this.cancel(null);
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

