/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class MessageHeader
implements ObvDatabase {
    static final String TABLE_NAME = "message_header";
    private final SendManagerSession sendManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private UID messageUid;
    static final String MESSAGE_UID = "message_uid";
    private UID deviceUid;
    static final String DEVICE_UID = "device_uid";
    private Identity toIdentity;
    static final String TO_IDENTITY = "to_identity";
    private EncryptedBytes wrappedKey;
    static final String WRAPPED_KEY = "wrapped_key";

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public UID getDeviceUid() {
        return this.deviceUid;
    }

    public Identity getToIdentity() {
        return this.toIdentity;
    }

    public EncryptedBytes getWrappedKey() {
        return this.wrappedKey;
    }

    public static MessageHeader create(SendManagerSession sendManagerSession, Identity ownedIdentity, UID messageUid, UID deviceUid, Identity toIdentity, EncryptedBytes wrappedKey) {
        if (ownedIdentity == null || messageUid == null || deviceUid == null || toIdentity == null || wrappedKey == null) {
            return null;
        }
        try {
            MessageHeader messageHeader = new MessageHeader(sendManagerSession, ownedIdentity, messageUid, deviceUid, toIdentity, wrappedKey);
            messageHeader.insert();
            return messageHeader;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private MessageHeader(SendManagerSession sendManagerSession, Identity ownedIdentity, UID messageUid, UID deviceUid, Identity toIdentity, EncryptedBytes wrappedKey) {
        this.sendManagerSession = sendManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
        this.deviceUid = deviceUid;
        this.toIdentity = toIdentity;
        this.wrappedKey = wrappedKey;
    }

    private MessageHeader(SendManagerSession sendManagerSession, ResultSet res) throws SQLException {
        this.sendManagerSession = sendManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.messageUid = new UID(res.getBytes(MESSAGE_UID));
        this.deviceUid = new UID(res.getBytes(DEVICE_UID));
        try {
            this.toIdentity = Identity.of(res.getBytes(TO_IDENTITY));
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.wrappedKey = new EncryptedBytes(res.getBytes(WRAPPED_KEY));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static MessageHeader[] getAll(SendManagerSession sendManagerSession, Identity ownedIdentity, UID messageUid) {
        if (messageUid == null) {
            return null;
        }
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("MessageHeader.getAll", "SELECT * FROM message_header WHERE owned_identity = ?  AND message_uid = ?;");){
            MessageHeader[] messageHeaderArray;
            block16: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, messageUid.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<MessageHeader> list = new ArrayList<MessageHeader>();
                    while (res.next()) {
                        list.add(new MessageHeader(sendManagerSession, res));
                    }
                    messageHeaderArray = list.toArray(new MessageHeader[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return messageHeaderArray;
        }
        catch (SQLException e) {
            return new MessageHeader[0];
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS message_header (owned_identity BLOB NOT NULL, message_uid BLOB NOT NULL, device_uid BLOB NOT NULL, to_identity BLOB NOT NULL, wrapped_key BLOB NOT NULL, CONSTRAINT PK_message_header PRIMARY KEY(owned_identity, message_uid, device_uid, to_identity), FOREIGN KEY (owned_identity, message_uid) REFERENCES outbox_message(owned_identity, uid));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 3 && newVersion >= 3) {
            Logger.d("MIGRATING `message_header` DATABASE FROM VERSION " + oldVersion + " TO 3\n!!!! THIS MIGRATION IS DESTRUCTIVE !!!!");
            statement = session.createStatement();
            try {
                statement.execute("DROP TABLE IF EXISTS `message_header`;");
                statement.execute("CREATE TABLE IF NOT EXISTS message_header (message_uid BLOB NOT NULL, device_uid BLOB NOT NULL, to_identity BLOB NOT NULL, wrapped_key BLOB NOT NULL, CONSTRAINT PK_message_header PRIMARY KEY(message_uid, device_uid, to_identity), FOREIGN KEY (message_uid) REFERENCES outbox_message(uid));");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 3;
        }
        if (oldVersion < 15 && newVersion >= 15) {
            Logger.d("MIGRATING `message_header` DATABASE FROM VERSION " + oldVersion + " TO 15");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE message_header RENAME TO old_message_header");
                statement.execute("CREATE TABLE IF NOT EXISTS message_header (owned_identity BLOB NOT NULL, message_uid BLOB NOT NULL, device_uid BLOB NOT NULL, to_identity BLOB NOT NULL, wrapped_key BLOB NOT NULL, CONSTRAINT PK_message_header PRIMARY KEY(owned_identity, message_uid, device_uid, to_identity), FOREIGN KEY (owned_identity, message_uid) REFERENCES outbox_message(owned_identity, uid));");
                statement.execute("INSERT INTO message_header SELECT i.identity, h.message_uid, h.device_uid, h.to_identity, h.wrapped_key FROM old_message_header AS h CROSS JOIN owned_identity AS i");
                statement.execute("DROP TABLE old_message_header");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 15;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("MessageHeader.insert", "INSERT INTO message_header VALUES (?,?,?,?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setBytes(3, this.deviceUid.getBytes());
            statement.setBytes(4, this.toIdentity.getBytes());
            statement.setBytes(5, this.wrappedKey.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("MessageHeader.delete", "DELETE FROM message_header WHERE owned_identity = ?  AND message_uid = ?  AND device_uid = ?  AND to_identity = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setBytes(3, this.deviceUid.getBytes());
            statement.setBytes(4, this.toIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    static void deleteAll(SendManagerSession sendManagerSession, Identity ownedIdentity, UID messageUid) throws SQLException {
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("MessageHeader.deleteAll", "DELETE FROM message_header WHERE owned_identity = ?  AND message_uid = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setBytes(2, messageUid.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

