/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.datatypes.containers.StringAndBoolean;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.networksend.databases.OutboxMessage;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.BatchUploadMessagesCompositeOperation;
import io.olvid.engine.networksend.operations.UploadMessageCompositeOperation;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class SendMessageCoordinator
implements OutboxMessage.NewOutboxMessageListener {
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private NotificationListeningDelegate notificationListeningDelegate;
    private final OperationQueue sendMessageWithAttachmentOperationQueue;
    private final ExponentialBackoffRepeatingScheduler<IdentityAndUid> scheduler;
    private final HashMap<String, Queue<IdentityAndUid>> userContentMessageUidsByServer;
    private final NoDuplicateOperationQueue batchSendUserContentMessageOperationQueue;
    private final HashMap<String, Queue<IdentityAndUid>> protocolMessageUidsByServer;
    private final NoDuplicateOperationQueue batchSendProtocolMessageOperationQueue;
    private final ExponentialBackoffRepeatingScheduler<StringAndBoolean> batchScheduler;
    private final HashMap<Identity, List<UID>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;
    private final NotificationListener notificationListener;

    public SendMessageCoordinator(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, int threadCount) {
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.sendMessageWithAttachmentOperationQueue = new OperationQueue(true);
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.userContentMessageUidsByServer = new HashMap();
        this.batchSendUserContentMessageOperationQueue = new NoDuplicateOperationQueue();
        this.protocolMessageUidsByServer = new HashMap();
        this.batchSendProtocolMessageOperationQueue = new NoDuplicateOperationQueue();
        this.batchScheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
        this.notificationListener = new NotificationListener();
    }

    public void startProcessing() {
        this.sendMessageWithAttachmentOperationQueue.execute(1, "Engine-SendMessageCoordinator-WithAttachment");
        this.batchSendUserContentMessageOperationQueue.execute(1, "Engine-SendMessageCoordinator-WithUserContent");
        this.batchSendProtocolMessageOperationQueue.execute(1, "Engine-SendMessageCoordinator-Protocol");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.notificationListener);
    }

    public void initialQueueing() {
        try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
            OutboxMessage[] outboxMessages;
            for (OutboxMessage outboxMessage : outboxMessages = OutboxMessage.getAll(sendManagerSession)) {
                this.queueNewSendMessageCompositeOperation(outboxMessage.getServer(), outboxMessage.getOwnedIdentity(), outboxMessage.getUid(), outboxMessage.getAttachments().length != 0, outboxMessage.isApplicationMessage());
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNewSendMessageCompositeOperation(String server, Identity ownedIdentity, UID messageUid, boolean hasAttachment, boolean hasUserContent) {
        if (hasAttachment || server == null) {
            UploadMessageCompositeOperation op = new UploadMessageCompositeOperation(this.sendManagerSessionFactory, this.sslSocketFactory, ownedIdentity, messageUid, this::onFinishCallbackWithAttachment, this::onCancelCallbackWithAttachment);
            this.sendMessageWithAttachmentOperationQueue.queue(op);
        } else if (hasUserContent) {
            Object op;
            if (ownedIdentity != null && messageUid != null) {
                op = this.userContentMessageUidsByServer;
                synchronized (op) {
                    Queue<IdentityAndUid> queue = this.userContentMessageUidsByServer.get(server);
                    if (queue == null) {
                        queue = new ArrayDeque<IdentityAndUid>();
                        this.userContentMessageUidsByServer.put(server, queue);
                    }
                    queue.add(new IdentityAndUid(ownedIdentity, messageUid));
                }
            }
            op = new BatchUploadMessagesCompositeOperation(this.sendManagerSessionFactory, this.sslSocketFactory, server, true, () -> {
                ArrayList<IdentityAndUid> messageIdentitiesAndUids = new ArrayList<IdentityAndUid>();
                HashMap<String, Queue<IdentityAndUid>> hashMap = this.userContentMessageUidsByServer;
                synchronized (hashMap) {
                    Queue<IdentityAndUid> queue = this.userContentMessageUidsByServer.get(server);
                    if (queue != null && !queue.isEmpty()) {
                        do {
                            messageIdentitiesAndUids.add(queue.remove());
                        } while (messageIdentitiesAndUids.size() != 50 && !queue.isEmpty());
                    }
                }
                return messageIdentitiesAndUids.toArray(new IdentityAndUid[0]);
            }, this::onFinishCallbackUserContent, this::onCancelCallbackUserContent);
            this.batchSendUserContentMessageOperationQueue.queue((Operation)op);
        } else {
            Object op;
            if (ownedIdentity != null && messageUid != null) {
                op = this.protocolMessageUidsByServer;
                synchronized (op) {
                    Queue<IdentityAndUid> queue = this.protocolMessageUidsByServer.get(server);
                    if (queue == null) {
                        queue = new ArrayDeque<IdentityAndUid>();
                        this.protocolMessageUidsByServer.put(server, queue);
                    }
                    queue.add(new IdentityAndUid(ownedIdentity, messageUid));
                }
            }
            op = new BatchUploadMessagesCompositeOperation(this.sendManagerSessionFactory, this.sslSocketFactory, server, false, () -> {
                ArrayList<IdentityAndUid> messageIdentitiesAndUids = new ArrayList<IdentityAndUid>();
                HashMap<String, Queue<IdentityAndUid>> hashMap = this.protocolMessageUidsByServer;
                synchronized (hashMap) {
                    Queue<IdentityAndUid> queue = this.protocolMessageUidsByServer.get(server);
                    if (queue != null && !queue.isEmpty()) {
                        do {
                            messageIdentitiesAndUids.add(queue.remove());
                        } while (messageIdentitiesAndUids.size() != 50 && !queue.isEmpty());
                    }
                }
                return messageIdentitiesAndUids.toArray(new IdentityAndUid[0]);
            }, this::onFinishCallbackProtocol, this::onCancelCallbackProtocol);
            this.batchSendProtocolMessageOperationQueue.queue((Operation)op);
        }
    }

    private void scheduleNewSendMessageCompositeOperationQueueing(Identity ownedIdentity, UID messageUid) {
        this.scheduler.schedule(new IdentityAndUid(ownedIdentity, messageUid), () -> this.queueNewSendMessageCompositeOperation(null, ownedIdentity, messageUid, true, true), "UploadMessageCompositeOperation");
    }

    private void scheduleNewBatchSendMessageCompositeOperationQueueing(String server, boolean hasUserContent) {
        this.batchScheduler.schedule(new StringAndBoolean(server, hasUserContent), () -> this.queueNewSendMessageCompositeOperation(server, null, null, false, hasUserContent), "BatchUploadMessagesCompositeOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
        this.batchScheduler.retryScheduledRunnables();
    }

    private void waitForIdentityReactivation(Identity ownedIdentity, UID messageUid) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<UID> list = this.awaitingIdentityReactivationOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<UID>();
            this.awaitingIdentityReactivationOperations.put(ownedIdentity, list);
        }
        list.add(messageUid);
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinishCallbackProtocol(Operation operation) {
        Queue<IdentityAndUid> queue;
        Object object;
        String server = ((BatchUploadMessagesCompositeOperation)operation).getServer();
        List<IdentityAndUid> identityInactiveMessageUids = ((BatchUploadMessagesCompositeOperation)operation).getIdentityInactiveMessageUids();
        List<IdentityAndUid> tooManyHeadersUnsentMessageUids = ((BatchUploadMessagesCompositeOperation)operation).getTooManyHeadersUnsentMessageUids();
        this.batchScheduler.clearFailedCount(new StringAndBoolean(server, false));
        if (tooManyHeadersUnsentMessageUids != null && !tooManyHeadersUnsentMessageUids.isEmpty()) {
            Logger.i("A batch of messages contained too many headers, using a smaller batch.");
            object = this.protocolMessageUidsByServer;
            synchronized (object) {
                queue = this.protocolMessageUidsByServer.get(server);
                if (queue == null) {
                    queue = new ArrayDeque<IdentityAndUid>();
                    this.protocolMessageUidsByServer.put(server, queue);
                }
                queue.addAll(tooManyHeadersUnsentMessageUids);
            }
        }
        object = this.protocolMessageUidsByServer;
        synchronized (object) {
            queue = this.protocolMessageUidsByServer.get(server);
            if (queue != null && !queue.isEmpty()) {
                this.queueNewSendMessageCompositeOperation(server, null, null, false, false);
            }
        }
        for (IdentityAndUid identityAndUid : identityInactiveMessageUids) {
            this.waitForIdentityReactivation(identityAndUid.identity, identityAndUid.uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCancelCallbackProtocol(Operation operation) {
        String server = ((BatchUploadMessagesCompositeOperation)operation).getServer();
        IdentityAndUid[] identityAndMessageUids = ((BatchUploadMessagesCompositeOperation)operation).getMessageIdentitiesAndUids();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("BatchUploadMessagesCompositeOperation (protocol) cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 2: {
                if (identityAndMessageUids == null) break;
                for (IdentityAndUid identityAndMessageUid : identityAndMessageUids) {
                    this.queueNewSendMessageCompositeOperation(null, identityAndMessageUid.identity, identityAndMessageUid.uid, true, true);
                }
                break;
            }
            default: {
                if (identityAndMessageUids != null) {
                    HashMap<String, Queue<IdentityAndUid>> hashMap = this.protocolMessageUidsByServer;
                    synchronized (hashMap) {
                        Queue<IdentityAndUid> queue = this.protocolMessageUidsByServer.get(server);
                        if (queue == null) {
                            queue = new ArrayDeque<IdentityAndUid>();
                            this.protocolMessageUidsByServer.put(server, queue);
                        }
                        queue.addAll(Arrays.asList(identityAndMessageUids));
                    }
                }
                this.scheduleNewBatchSendMessageCompositeOperationQueueing(server, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinishCallbackUserContent(Operation operation) {
        Queue<IdentityAndUid> queue;
        Object object;
        String server = ((BatchUploadMessagesCompositeOperation)operation).getServer();
        List<IdentityAndUid> identityInactiveMessageUids = ((BatchUploadMessagesCompositeOperation)operation).getIdentityInactiveMessageUids();
        List<IdentityAndUid> tooManyHeadersUnsentMessageUids = ((BatchUploadMessagesCompositeOperation)operation).getTooManyHeadersUnsentMessageUids();
        this.batchScheduler.clearFailedCount(new StringAndBoolean(server, true));
        if (tooManyHeadersUnsentMessageUids != null && !tooManyHeadersUnsentMessageUids.isEmpty()) {
            Logger.i("A batch of messages contained too many headers, using a smaller batch.");
            object = this.userContentMessageUidsByServer;
            synchronized (object) {
                queue = this.userContentMessageUidsByServer.get(server);
                if (queue == null) {
                    queue = new ArrayDeque<IdentityAndUid>();
                    this.userContentMessageUidsByServer.put(server, queue);
                }
                queue.addAll(tooManyHeadersUnsentMessageUids);
            }
        }
        object = this.userContentMessageUidsByServer;
        synchronized (object) {
            queue = this.userContentMessageUidsByServer.get(server);
            if (queue != null && !queue.isEmpty()) {
                this.queueNewSendMessageCompositeOperation(server, null, null, false, true);
            }
        }
        for (IdentityAndUid identityAndUid : identityInactiveMessageUids) {
            this.waitForIdentityReactivation(identityAndUid.identity, identityAndUid.uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCancelCallbackUserContent(Operation operation) {
        String server = ((BatchUploadMessagesCompositeOperation)operation).getServer();
        IdentityAndUid[] identityAndMessageUids = ((BatchUploadMessagesCompositeOperation)operation).getMessageIdentitiesAndUids();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("BatchUploadMessagesCompositeOperation (user content) cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 2: {
                if (identityAndMessageUids == null) break;
                for (IdentityAndUid identityAndMessageUid : identityAndMessageUids) {
                    this.queueNewSendMessageCompositeOperation(null, identityAndMessageUid.identity, identityAndMessageUid.uid, true, true);
                }
                break;
            }
            default: {
                if (identityAndMessageUids != null) {
                    HashMap<String, Queue<IdentityAndUid>> hashMap = this.userContentMessageUidsByServer;
                    synchronized (hashMap) {
                        Queue<IdentityAndUid> queue = this.userContentMessageUidsByServer.get(server);
                        if (queue == null) {
                            queue = new ArrayDeque<IdentityAndUid>();
                            this.userContentMessageUidsByServer.put(server, queue);
                        }
                        queue.addAll(Arrays.asList(identityAndMessageUids));
                    }
                }
                this.scheduleNewBatchSendMessageCompositeOperationQueueing(server, true);
            }
        }
    }

    public void onFinishCallbackWithAttachment(Operation operation) {
        Identity ownedIdentity = ((UploadMessageCompositeOperation)operation).getOwnedIdentity();
        UID messageUid = ((UploadMessageCompositeOperation)operation).getMessageUid();
        this.scheduler.clearFailedCount(new IdentityAndUid(ownedIdentity, messageUid));
    }

    public void onCancelCallbackWithAttachment(Operation operation) {
        Identity ownedIdentity = ((UploadMessageCompositeOperation)operation).getOwnedIdentity();
        UID messageUid = ((UploadMessageCompositeOperation)operation).getMessageUid();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("UploadMessageCompositeOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 1: {
                break;
            }
            case 10: {
                this.waitForIdentityReactivation(ownedIdentity, messageUid);
                break;
            }
            default: {
                this.scheduleNewSendMessageCompositeOperationQueueing(ownedIdentity, messageUid);
            }
        }
    }

    @Override
    public void newMessageToSend(String server, Identity ownedIdentity, UID messageUid, boolean hasAttachment, boolean hasUserContent) {
        this.queueNewSendMessageCompositeOperation(server, ownedIdentity, messageUid, hasAttachment, hasUserContent);
    }

    class NotificationListener
    implements io.olvid.engine.datatypes.NotificationListener {
        NotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if ("identity_manager_notification_owned_identity_changed_active_status".equals(notificationName)) {
                boolean active = (Boolean)userInfo.get("active");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (!active) {
                    return;
                }
                SendMessageCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                List<UID> messageUids = SendMessageCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                if (messageUids != null) {
                    SendMessageCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                    for (UID messageUid : messageUids) {
                        SendMessageCoordinator.this.queueNewSendMessageCompositeOperation(null, ownedIdentity, messageUid, true, true);
                    }
                }
                SendMessageCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
            }
        }
    }

    public static interface MessageBatchProvider {
        public IdentityAndUid[] getBatchOFMessageUids();
    }
}

