/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.UUID;

class VerifyReceiptServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/verifyReceipt";
    private final String server;
    private final Identity identity;
    private final byte[] token;
    private final String storeToken;
    private UUID apiKey = null;

    public UUID getApiKey() {
        return this.apiKey;
    }

    public VerifyReceiptServerMethod(Identity identity, byte[] token, String storeToken) {
        this.server = identity.getServer();
        this.identity = identity;
        this.token = token;
        this.storeToken = storeToken;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.token), Encoded.of(Constants.ANDROID_STORE_ID), Encoded.of(this.storeToken)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                this.apiKey = receivedData[0].decodeUuid();
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return true;
    }
}

