/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.VerifyReceiptServerMethod;
import java.sql.SQLException;
import java.util.HashMap;
import javax.net.ssl.SSLSocketFactory;

public class VerifyReceiptOperation
extends Operation {
    public static final int RFC_INVALID_SERVER_SESSION = 0;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final Identity ownedIdentity;
    private final String storeToken;

    public VerifyReceiptOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, Identity ownedIdentity, String storeToken, Operation.OnCancelCallback onCancelCallback) {
        super(ownedIdentity.computeUniqueUid(), null, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.ownedIdentity = ownedIdentity;
        this.storeToken = storeToken;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public String getStoreToken() {
        return this.storeToken;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.ownedIdentity);
                if (serverSessionToken == null) {
                    this.cancel(0);
                    return;
                }
                VerifyReceiptServerMethod serverMethod = new VerifyReceiptServerMethod(this.ownedIdentity, serverSessionToken, this.storeToken);
                serverMethod.setSslSocketFactory(this.sslSocketFactory);
                byte returnStatus = serverMethod.execute(fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, this.ownedIdentity));
                fetchManagerSession.session.startTransaction();
                switch (returnStatus) {
                    case 0: {
                        HashMap<String, Object> userInfo = new HashMap<String, Object>();
                        userInfo.put("owned_identity", this.ownedIdentity);
                        userInfo.put("store_token", this.storeToken);
                        fetchManagerSession.notificationPostingDelegate.postNotification("network_fetch_notification_verify_receipt_success", userInfo);
                        ServerSession.deleteForIdentity(fetchManagerSession, this.ownedIdentity);
                        fetchManagerSession.createServerSessionDelegate.createServerSession(this.ownedIdentity);
                        finished = true;
                        return;
                    }
                    case 4: {
                        ServerSession.deleteCurrentTokenIfEqualTo(fetchManagerSession, serverSessionToken, this.ownedIdentity);
                        fetchManagerSession.session.commit();
                        this.cancel(0);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                fetchManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    fetchManagerSession.session.commit();
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

