/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class UpdateGroupBlobServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/groupBlobUpdate";
    private final String server;
    private final UID groupUid;
    private final byte[] lockNonce;
    private final EncryptedBytes encryptedBlob;
    private final Encoded encodedGroupAdminPublicKey;
    private final byte[] signature;
    private Encoded serverResponse;

    public UpdateGroupBlobServerMethod(String server, UID groupUid, byte[] lockNonce, EncryptedBytes encryptedBlob, Encoded encodedGroupAdminPublicKey, byte[] signature) {
        this.server = server;
        this.groupUid = groupUid;
        this.lockNonce = lockNonce;
        this.encryptedBlob = encryptedBlob;
        this.encodedGroupAdminPublicKey = encodedGroupAdminPublicKey;
        this.signature = signature;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.groupUid), Encoded.of(this.lockNonce), Encoded.of(this.encryptedBlob), this.encodedGroupAdminPublicKey, Encoded.of(this.signature)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            this.serverResponse = Encoded.of(0L);
        } else if (this.returnStatus == 21) {
            this.returnStatus = 0;
            this.serverResponse = Encoded.of(1L);
        } else if (this.returnStatus == 9 || this.returnStatus == 20) {
            this.returnStatus = 0;
            this.serverResponse = Encoded.of(2L);
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

