/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.BackupsV2CreateBackupServerMethod;
import io.olvid.engine.networkfetch.operations.BackupsV2DeleteBackupServerMethod;
import io.olvid.engine.networkfetch.operations.BackupsV2DownloadProfilePictureServerMethod;
import io.olvid.engine.networkfetch.operations.BackupsV2ListBackupsServerMethod;
import io.olvid.engine.networkfetch.operations.BackupsV2UploadBackupsServerMethod;
import io.olvid.engine.networkfetch.operations.OwnedDeviceDiscoveryServerMethod;
import io.olvid.engine.networkfetch.operations.RegisterApiKeyServerMethod;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;
import javax.net.ssl.SSLSocketFactory;

public class StandaloneServerQueryOperation
extends Operation {
    public static final int RFC_NETWORK_ERROR = 1;
    public static final int RFC_UNSUPPORTED_SERVER_QUERY_TYPE = 2;
    public static final int RFC_INVALID_SERVER_SESSION = 3;
    public static final int RFC_INVALID_API_KEY = 4;
    public static final int RFC_BACKUP_UID_ALREADY_USED = 5;
    public static final int RFC_BACKUP_VERSION_TOO_SMALL = 6;
    public static final int RFC_UNKNOWN_BACKUP_UID = 7;
    public static final int RFC_UNKNOWN_BACKUP_THREAD_ID = 8;
    public static final int RFC_UNKNOWN_BACKUP_VERSION = 9;
    public static final int RFC_SERVER_PARSING_ERROR = 100;
    private final ServerQuery serverQuery;
    private final SSLSocketFactory sslSocketFactory;
    private Encoded serverResponse;

    public Encoded getServerResponse() {
        return this.serverResponse;
    }

    public StandaloneServerQueryOperation(ServerQuery serverQuery, SSLSocketFactory sslSocketFactory) {
        this.serverQuery = serverQuery;
        this.sslSocketFactory = sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try {
            ServerQueryServerMethod serverMethod;
            switch (this.serverQuery.getType().getId()) {
                case OWNED_DEVICE_DISCOVERY_QUERY_ID: {
                    serverMethod = new OwnedDeviceDiscoveryServerMethod(this.serverQuery.getOwnedIdentity());
                    break;
                }
                case REGISTER_API_KEY_QUERY_ID: {
                    ServerQuery.RegisterApiKeyQuery registerApiKeyQuery = (ServerQuery.RegisterApiKeyQuery)this.serverQuery.getType();
                    serverMethod = new RegisterApiKeyServerMethod(this.serverQuery.getOwnedIdentity(), registerApiKeyQuery.serverSessionToken, registerApiKeyQuery.apiKeyString);
                    break;
                }
                case BACKUPS_V2_CREATE_BACKUP_QUERY_ID: {
                    ServerQuery.BackupsV2CreateBackupQuery backupsV2CreateBackupQuery = (ServerQuery.BackupsV2CreateBackupQuery)this.serverQuery.getType();
                    serverMethod = new BackupsV2CreateBackupServerMethod(backupsV2CreateBackupQuery.server, backupsV2CreateBackupQuery.backupUid, backupsV2CreateBackupQuery.serverAuthenticationPublicKey);
                    break;
                }
                case BACKUPS_V2_UPLOAD_BACKUP_QUERY_ID: {
                    ServerQuery.BackupsV2UploadBackupQuery backupsV2UploadBackupQuery = (ServerQuery.BackupsV2UploadBackupQuery)this.serverQuery.getType();
                    serverMethod = new BackupsV2UploadBackupsServerMethod(backupsV2UploadBackupQuery.server, backupsV2UploadBackupQuery.backupUid, backupsV2UploadBackupQuery.threadId, backupsV2UploadBackupQuery.version, backupsV2UploadBackupQuery.encryptedBackup, backupsV2UploadBackupQuery.signature);
                    break;
                }
                case BACKUPS_V2_DELETE_BACKUP_QUERY_ID: {
                    ServerQuery.BackupsV2DeleteBackupQuery backupsV2DeleteBackupQuery = (ServerQuery.BackupsV2DeleteBackupQuery)this.serverQuery.getType();
                    serverMethod = new BackupsV2DeleteBackupServerMethod(backupsV2DeleteBackupQuery.server, backupsV2DeleteBackupQuery.backupUid, backupsV2DeleteBackupQuery.threadId, backupsV2DeleteBackupQuery.version, backupsV2DeleteBackupQuery.signature);
                    break;
                }
                case BACKUPS_V2_LIST_BACKUPS_QUERY_ID: {
                    ServerQuery.BackupsV2ListBackupsQuery backupsV2ListBackupsQuery = (ServerQuery.BackupsV2ListBackupsQuery)this.serverQuery.getType();
                    serverMethod = new BackupsV2ListBackupsServerMethod(backupsV2ListBackupsQuery.server, backupsV2ListBackupsQuery.backupUid);
                    break;
                }
                case BACKUPS_V2_DOWNLOAD_PROFILE_PICTURE_QUERY_ID: {
                    ServerQuery.BackupsV2DownloadProfilePictureQuery backupsV2DownloadProfilePictureQuery = (ServerQuery.BackupsV2DownloadProfilePictureQuery)this.serverQuery.getType();
                    serverMethod = new BackupsV2DownloadProfilePictureServerMethod(backupsV2DownloadProfilePictureQuery.identity, backupsV2DownloadProfilePictureQuery.photoLabel, backupsV2DownloadProfilePictureQuery.photoKey);
                    break;
                }
                default: {
                    this.cancel(2);
                    return;
                }
            }
            serverMethod.setSslSocketFactory(this.sslSocketFactory);
            byte returnStatus = serverMethod.execute(true);
            Logger.d("?? Server query return status (after parse): " + returnStatus);
            switch (returnStatus) {
                case 0: {
                    this.serverResponse = serverMethod.getServerResponse();
                    finished = true;
                    return;
                }
                case 4: {
                    this.cancel(3);
                    return;
                }
                case 22: {
                    this.cancel(4);
                    return;
                }
                case 25: {
                    this.cancel(5);
                    return;
                }
                case 26: {
                    this.cancel(6);
                    return;
                }
                case 27: {
                    this.cancel(7);
                    return;
                }
                case 28: {
                    this.cancel(8);
                    return;
                }
                case 29: {
                    this.cancel(9);
                    return;
                }
                case -2: {
                    this.cancel(100);
                    return;
                }
            }
            this.cancel(1);
            return;
        }
        catch (Exception e) {
            Logger.x(e);
        }
        finally {
            if (finished) {
                this.setFinished();
            } else {
                if (this.hasNoReasonForCancel()) {
                    this.cancel(null);
                }
                this.processCancel();
            }
        }
    }

    @Override
    public void doCancel() {
    }
}

