/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.Arrays;

class RequestChallengeServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/requestChallenge";
    private final String server;
    private final Identity identity;
    private final byte[] nonce;
    private byte[] challenge = null;

    public RequestChallengeServerMethod(Identity identity, byte[] nonce) {
        this.server = identity.getServer();
        this.identity = identity;
        this.nonce = nonce;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.nonce)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                byte[] challenge = receivedData[0].decodeBytes();
                byte[] serverNonce = receivedData[1].decodeBytes();
                if (!Arrays.equals(this.nonce, serverNonce) || challenge.length != 32) {
                    this.returnStatus = (byte)-1;
                    return;
                }
                this.challenge = challenge;
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return false;
    }
}

