/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.UUID;

class QueryApiKeyStatusServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/queryApiKeyStatus";
    private final String server;
    private final Identity ownedIdentity;
    private final UUID apiKey;
    private int apiKeyStatus = -1;
    private long permissions = 0L;
    private long apiKeyExpiration = 0L;

    public QueryApiKeyStatusServerMethod(Identity ownedIdentity, UUID apiKey) {
        this.ownedIdentity = ownedIdentity;
        this.server = ownedIdentity.getServer();
        this.apiKey = apiKey;
    }

    public int getApiKeyStatus() {
        return this.apiKeyStatus;
    }

    public long getPermissions() {
        return this.permissions;
    }

    public long getApiKeyExpiration() {
        return this.apiKeyExpiration;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.ownedIdentity), Encoded.of(this.apiKey)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                this.apiKeyStatus = (int)receivedData[0].decodeLong();
                this.permissions = receivedData[1].decodeLong();
                this.apiKeyExpiration = receivedData[2].decodeLong();
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return false;
    }
}

