/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.operations.QueryApiKeyStatusServerMethod;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.SSLSocketFactory;

public class QueryApiKeyStatusOperation
extends Operation {
    private final Identity ownedIdentity;
    private final UUID apiKey;
    private final SSLSocketFactory sslSocketFactory;
    private ServerSession.ApiKeyStatus apiKeyStatus;
    private List<ServerSession.Permission> permissions;
    private long apiKeyExpirationTimestamp;

    public QueryApiKeyStatusOperation(SSLSocketFactory sslSocketFactory, Identity ownedIdentity, UUID apiKey, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(null, onFinishCallback, onCancelCallback);
        this.sslSocketFactory = sslSocketFactory;
        this.ownedIdentity = ownedIdentity;
        this.apiKey = apiKey;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UUID getApiKey() {
        return this.apiKey;
    }

    public ServerSession.ApiKeyStatus getApiKeyStatus() {
        return this.apiKeyStatus;
    }

    public List<ServerSession.Permission> getPermissions() {
        return this.permissions;
    }

    public long getApiKeyExpirationTimestamp() {
        return this.apiKeyExpirationTimestamp;
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void doExecute() {
        QueryApiKeyStatusServerMethod serverMethod = new QueryApiKeyStatusServerMethod(this.ownedIdentity, this.apiKey);
        serverMethod.setSslSocketFactory(this.sslSocketFactory);
        byte returnStatus = serverMethod.execute(true);
        if (returnStatus == 0) {
            this.apiKeyStatus = ServerSession.deserializeApiKeyStatus(serverMethod.getApiKeyStatus());
            this.permissions = ServerSession.deserializePermissions(serverMethod.getPermissions());
            this.apiKeyExpirationTimestamp = serverMethod.getApiKeyExpiration();
            this.setFinished();
        } else {
            this.cancel(null);
            this.processCancel();
        }
    }
}

