/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import java.sql.SQLException;
import java.util.List;

public class ProcessPreKeyMessagesForNewContactOperation
extends PriorityOperation {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final Identity ownedIdentity;
    private final Identity contactIdentity;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public ProcessPreKeyMessagesForNewContactOperation(FetchManagerSessionFactory fetchManagerSessionFactory, Identity ownedIdentity, Identity contactIdentity, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(ProcessPreKeyMessagesForNewContactOperation.computeUniqueUid(ownedIdentity, contactIdentity), onFinishCallback, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.ownedIdentity = ownedIdentity;
        this.contactIdentity = contactIdentity;
    }

    @Override
    public long getPriority() {
        return 1L;
    }

    private static UID computeUniqueUid(Identity ownedIdentity, Identity contactIdentity) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] input = new byte[ownedIdentity.getBytes().length + contactIdentity.getBytes().length];
        System.arraycopy(ownedIdentity.getBytes(), 0, input, 0, ownedIdentity.getBytes().length);
        System.arraycopy(contactIdentity.getBytes(), 0, input, ownedIdentity.getBytes().length, contactIdentity.getBytes().length);
        return new UID(sha256.digest(input));
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                List<InboxMessage> inboxMessages = InboxMessage.getPendingPreKeyMessages(fetchManagerSession, this.ownedIdentity, this.contactIdentity);
                Logger.i("Found " + inboxMessages.size() + " pending PreKey inbox messages to process following a contact addition.");
                for (InboxMessage inboxMessage : inboxMessages) {
                    fetchManagerSession.inboxMessageListener.messageWasDownloaded(inboxMessage.getNetworkReceivedMessage());
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
            finally {
                this.setFinished();
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

