/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;

class GetTurnCredentialsServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/getTurnCredentials";
    private final String server;
    private final Identity identity;
    private final byte[] token;
    private final String username1;
    private final String username2;
    private String expiringUsername1 = null;
    private String password1 = null;
    private String expiringUsername2 = null;
    private String password2 = null;

    public String getExpiringUsername1() {
        return this.expiringUsername1;
    }

    public String getPassword1() {
        return this.password1;
    }

    public String getExpiringUsername2() {
        return this.expiringUsername2;
    }

    public String getPassword2() {
        return this.password2;
    }

    public GetTurnCredentialsServerMethod(Identity identity, byte[] token, String username1, String username2) {
        this.server = identity.getServer();
        this.identity = identity;
        this.token = token;
        this.username1 = username1;
        this.username2 = username2;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.token), Encoded.of(this.username1), Encoded.of(this.username2)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                this.expiringUsername1 = receivedData[0].decodeString();
                this.password1 = receivedData[1].decodeString();
                this.expiringUsername2 = receivedData[2].decodeString();
                this.password2 = receivedData[3].decodeString();
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return true;
    }
}

