/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

class GetKeycloakDataServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "olvid-rest/getData";
    private final String server;
    private final String path;
    private final UID serverLabel;
    private final String engineBaseDirectory;
    private Encoded serverResponse;

    public GetKeycloakDataServerMethod(String keycloakServerUrl, UID serverLabel, String engineBaseDirectory) {
        this.serverLabel = serverLabel;
        String url = keycloakServerUrl + SERVER_METHOD_PATH;
        int pos = url.indexOf(47, 8);
        this.server = url.substring(0, pos);
        this.path = url.substring(pos);
        this.engineBaseDirectory = engineBaseDirectory;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return this.path;
    }

    @Override
    protected byte[] getDataToSend() {
        return this.serverLabel.getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            try {
                EncryptedBytes encryptedData = receivedData[0].decodeEncryptedData();
                String userDataPath = "downloaded_user_data" + File.separator + (System.currentTimeMillis() + 604800000L) + "." + Logger.toHexString(this.serverLabel.getBytes()) + "-" + Logger.getUuidString(UUID.randomUUID());
                try (SecureFileOutputStream fis = new SecureFileOutputStream(new SecureFile(this.engineBaseDirectory, userDataPath));){
                    fis.write(encryptedData.getBytes());
                }
                this.serverResponse = Encoded.of(userDataPath);
            }
            catch (DecodingException | IOException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        } else if (this.returnStatus == 9) {
            this.returnStatus = 0;
            this.serverResponse = Encoded.of("");
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

