/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class GetGroupBlobServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/groupBlobGet";
    private final String server;
    private final UID groupUid;
    private final byte[] nonce;
    private Encoded serverResponse;

    public GetGroupBlobServerMethod(String server, UID groupUid, byte[] nonce) {
        this.server = server;
        this.groupUid = groupUid;
        this.nonce = nonce;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.groupUid)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            try {
                Encoded[] encodedLogItems;
                if (receivedData.length != 3) {
                    throw new DecodingException();
                }
                EncryptedBytes encryptedBlob = receivedData[0].decodeEncryptedData();
                for (Encoded encodedLogItem : encodedLogItems = receivedData[1].decodeList()) {
                    encodedLogItem.decodeBytes();
                }
                ServerAuthenticationPublicKey groupAdminPublicKey = (ServerAuthenticationPublicKey)receivedData[2].decodePublicKey();
                this.serverResponse = Encoded.of(new Encoded[]{receivedData[0], receivedData[1], receivedData[2], Encoded.of(this.nonce)});
            }
            catch (Exception e) {
                Logger.x(e);
                this.returnStatus = (byte)-126;
            }
        } else if (this.returnStatus == 9) {
            this.returnStatus = 0;
            this.serverResponse = Encoded.of(new Encoded[]{Encoded.of(true)});
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

