/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.UUID;

class FreeTrialServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/freeTrial";
    private final String server;
    private final Identity identity;
    private final byte[] token;
    private final boolean retrieveApiKey;
    private UUID apiKey = null;

    public UUID getApiKey() {
        return this.apiKey;
    }

    public FreeTrialServerMethod(Identity identity, byte[] token, boolean retrieveApiKey) {
        this.server = identity.getServer();
        this.identity = identity;
        this.token = token;
        this.retrieveApiKey = retrieveApiKey;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.token), Encoded.of(this.retrieveApiKey)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                if (this.retrieveApiKey) {
                    this.apiKey = receivedData[0].decodeUuid();
                }
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return true;
    }
}

