/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.networkfetch.databases.InboxAttachment;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.DownloadMessagesAndListAttachmentsServerMethod;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;

public class DownloadMessagesAndListAttachmentsOperation
extends PriorityOperation {
    public static final int RFC_NETWORK_ERROR = 1;
    public static final int RFC_INVALID_SERVER_SESSION = 2;
    public static final int RFC_IDENTITY_IS_INACTIVE = 4;
    public static final int RFC_DEVICE_NOT_REGISTERED = 5;
    private static final Set<Identity> notifiedIdentities = new HashSet<Identity>();
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final Identity ownedIdentity;
    private final UID deviceUid;
    private final long listStartTimestamp;
    private Long timestampOfLastMessageBeforeTruncation = null;
    private long downloadTimestamp = 0L;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Long getTimestampOfLastMessageBeforeTruncation() {
        return this.timestampOfLastMessageBeforeTruncation;
    }

    public UID getDeviceUid() {
        return this.deviceUid;
    }

    public long getDownloadTimestamp() {
        return this.downloadTimestamp;
    }

    public DownloadMessagesAndListAttachmentsOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, Identity ownedIdentity, UID deviceUid, long listStartTimestamp, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(DownloadMessagesAndListAttachmentsOperation.computeUniqueUid(ownedIdentity, listStartTimestamp), onFinishCallback, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.ownedIdentity = ownedIdentity;
        this.deviceUid = deviceUid;
        this.listStartTimestamp = listStartTimestamp;
    }

    private static UID computeUniqueUid(Identity ownedIdentity, long listStartTimestamp) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] input = new byte[ownedIdentity.getBytes().length + 1];
        System.arraycopy(ownedIdentity.getBytes(), 0, input, 0, ownedIdentity.getBytes().length);
        input[input.length - 1] = (byte)(listStartTimestamp != 0L ? 1 : 0);
        return new UID(sha256.digest(input));
    }

    @Override
    public long getPriority() {
        return this.listStartTimestamp == 0L ? 10L : 5L;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.ownedIdentity);
                if (serverSessionToken == null) {
                    this.cancel(2);
                    return;
                }
                if (this.cancelWasRequested()) {
                    return;
                }
                Set<Identity> set = notifiedIdentities;
                synchronized (set) {
                    if (!notifiedIdentities.contains(this.ownedIdentity)) {
                        notifiedIdentities.add(this.ownedIdentity);
                        HashMap<String, Object> userInfo = new HashMap<String, Object>();
                        userInfo.put("owned_identity", this.ownedIdentity);
                        userInfo.put("user_initiated", false);
                        fetchManagerSession.notificationPostingDelegate.postNotification("network_fetch_notification_server_poll_requested", userInfo);
                    }
                }
                DownloadMessagesAndListAttachmentsServerMethod serverMethod = new DownloadMessagesAndListAttachmentsServerMethod(this.ownedIdentity, serverSessionToken, this.deviceUid, this.listStartTimestamp);
                serverMethod.setSslSocketFactory(this.sslSocketFactory);
                byte returnStatus = serverMethod.execute(fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, this.ownedIdentity));
                long localDownloadTimestamp = System.currentTimeMillis();
                switch (returnStatus) {
                    case 0: 
                    case 23: {
                        this.downloadTimestamp = serverMethod.getDownloadTimestamp();
                        DownloadMessagesAndListAttachmentsServerMethod.MessageAndAttachmentLengths[] messageAndAttachmentLengthsArray = serverMethod.getMessageAndAttachmentLengthsArray();
                        int count = 0;
                        fetchManagerSession.session.startTransaction();
                        for (DownloadMessagesAndListAttachmentsServerMethod.MessageAndAttachmentLengths messageAndAttachmentLengths : messageAndAttachmentLengthsArray) {
                            if (!InboxMessage.exists(fetchManagerSession, this.ownedIdentity, messageAndAttachmentLengths.messageUid)) {
                                InboxMessage message = InboxMessage.create(fetchManagerSession, this.ownedIdentity, messageAndAttachmentLengths.messageUid, messageAndAttachmentLengths.messageContent, messageAndAttachmentLengths.wrappedKey, messageAndAttachmentLengths.serverTimestamp, this.downloadTimestamp, localDownloadTimestamp, messageAndAttachmentLengths.hasExtendedContent);
                                if (message == null) continue;
                                ++count;
                                for (int i = 0; i < messageAndAttachmentLengths.attachmentLengths.length; ++i) {
                                    InboxAttachment attachment = InboxAttachment.get(fetchManagerSession, this.ownedIdentity, messageAndAttachmentLengths.messageUid, i);
                                    if (attachment != null) continue;
                                    if (messageAndAttachmentLengths.chunkDownloadPrivateUrls[i] == null) {
                                        Logger.i("Empty list of chunks. Attachment was deleted from server.");
                                    }
                                    InboxAttachment.create(fetchManagerSession, this.ownedIdentity, messageAndAttachmentLengths.messageUid, i, messageAndAttachmentLengths.attachmentLengths[i], messageAndAttachmentLengths.chunkLengths[i], messageAndAttachmentLengths.chunkDownloadPrivateUrls[i]);
                                }
                                continue;
                            }
                            fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeMarkedAsListedOnServer(this.ownedIdentity, messageAndAttachmentLengths.messageUid);
                        }
                        Logger.d("DownloadMessagesAndListAttachmentsOperation found " + messageAndAttachmentLengthsArray.length + " messages (" + count + " new) on the server.");
                        Long l = this.timestampOfLastMessageBeforeTruncation = returnStatus == 23 ? Long.valueOf(messageAndAttachmentLengthsArray[messageAndAttachmentLengthsArray.length - 1].serverTimestamp) : null;
                        if (this.timestampOfLastMessageBeforeTruncation == null) {
                            fetchManagerSession.identityDelegate.expireCurrentDeviceOwnedPreKeys(fetchManagerSession.session, this.ownedIdentity, this.downloadTimestamp);
                        }
                        finished = true;
                        return;
                    }
                    case 4: {
                        ServerSession.deleteCurrentTokenIfEqualTo(fetchManagerSession, serverSessionToken, this.ownedIdentity);
                        fetchManagerSession.session.commit();
                        this.cancel(2);
                        return;
                    }
                    case 11: {
                        this.cancel(5);
                        return;
                    }
                    case -114: {
                        this.cancel(4);
                        return;
                    }
                }
                this.cancel(1);
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                fetchManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    fetchManagerSession.session.commit();
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

