/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class PendingServerQuery
implements ObvDatabase {
    static final String TABLE_NAME = "server_query";
    private final FetchManagerSession fetchManagerSession;
    static final String UID_ = "uid";
    private UID uid;
    static final String ENCODED_QUERY = "encoded_query";
    private Encoded encodedQuery;
    static final String CREATION_TIMESTAMP = "creation_timestamp";
    private long creationTimestamp;
    static final String WEBSOCKET = "websocket";
    private boolean webSocket;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED = 1L;

    public UID getUid() {
        return this.uid;
    }

    public Encoded getEncodedQuery() {
        return this.encodedQuery;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    public static PendingServerQuery create(FetchManagerSession fetchManagerSession, ServerQuery serverQuery, PRNGService prng) {
        if (serverQuery == null) {
            return null;
        }
        try {
            Encoded encodedQuery = serverQuery.encode();
            UID uid = new UID(prng);
            PendingServerQuery pendingServerQuery = new PendingServerQuery(fetchManagerSession, uid, encodedQuery, serverQuery.isWebSocket());
            pendingServerQuery.insert();
            return pendingServerQuery;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private PendingServerQuery(FetchManagerSession fetchManagerSession, UID uid, Encoded encodedQuery, boolean webSocket) {
        this.fetchManagerSession = fetchManagerSession;
        this.uid = uid;
        this.encodedQuery = encodedQuery;
        this.creationTimestamp = System.currentTimeMillis();
        this.webSocket = webSocket;
    }

    private PendingServerQuery(FetchManagerSession fetchManagerSession, ResultSet res) throws SQLException {
        this.fetchManagerSession = fetchManagerSession;
        this.uid = new UID(res.getBytes(UID_));
        this.encodedQuery = new Encoded(res.getBytes(ENCODED_QUERY));
        this.creationTimestamp = res.getLong(CREATION_TIMESTAMP);
        this.webSocket = res.getBoolean(WEBSOCKET);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS server_query (uid BLOB PRIMARY KEY, encoded_query BLOB NOT NULL, creation_timestamp BIGINT NOT NULL, websocket BIT NOT NULL  );");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 31 && newVersion >= 31) {
            Logger.d("MIGRATING `server_query` DATABASE FROM VERSION " + oldVersion + " TO 31");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE `server_query` ADD COLUMN `creation_timestamp` BIGINT NOT NULL DEFAULT " + System.currentTimeMillis());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 31;
        }
        if (oldVersion < 37 && newVersion >= 37) {
            Logger.d("MIGRATING `server_query` DATABASE FROM VERSION " + oldVersion + " TO 36");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE `server_query` ADD COLUMN `websocket` BIT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 37;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("PendingServerQuery.insert", "INSERT INTO server_query VALUES (?,?,?,?);");){
            statement.setBytes(1, this.uid.getBytes());
            statement.setBytes(2, this.encodedQuery.getBytes());
            statement.setLong(3, this.creationTimestamp);
            statement.setBoolean(4, this.webSocket);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.fetchManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("PendingServerQuery.delete", "DELETE FROM server_query WHERE uid = ?;");){
            statement.setBytes(1, this.uid.getBytes());
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PendingServerQuery get(FetchManagerSession fetchManagerSession, UID uid) {
        if (uid == null) {
            return null;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("PendingServerQuery.get", "SELECT * FROM server_query WHERE uid = ?;");){
            PendingServerQuery pendingServerQuery;
            block19: {
                ResultSet res;
                block17: {
                    PendingServerQuery pendingServerQuery2;
                    block18: {
                        statement.setBytes(1, uid.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            pendingServerQuery2 = new PendingServerQuery(fetchManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return pendingServerQuery2;
                }
                pendingServerQuery = null;
                if (res == null) break block19;
                res.close();
            }
            return pendingServerQuery;
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PendingServerQuery[] getAll(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("PendingServerQuery.getAll", "SELECT * FROM server_query;");){
            PendingServerQuery[] pendingServerQueryArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<PendingServerQuery> list = new ArrayList<PendingServerQuery>();
                    while (res.next()) {
                        list.add(new PendingServerQuery(fetchManagerSession, res));
                    }
                    pendingServerQueryArray = list.toArray(new PendingServerQuery[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return pendingServerQueryArray;
        }
        catch (SQLException e) {
            return new PendingServerQuery[0];
        }
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 1L) != 0L && this.fetchManagerSession.pendingServerQueryListener != null) {
            this.fetchManagerSession.pendingServerQueryListener.newPendingServerQuery(this);
        }
        this.commitHookBits = 0L;
    }

    public static interface PendingServerQueryListener {
        public void newPendingServerQuery(PendingServerQuery var1);
    }
}

