/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Chunk;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class InboxAttachment
implements ObvDatabase {
    static final String TABLE_NAME = "inbox_attachment";
    private final FetchManagerSession fetchManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private UID messageUid;
    static final String MESSAGE_UID = "message_uid";
    private int attachmentNumber;
    static final String ATTACHMENT_NUMBER = "attachment_number";
    private long expectedLength;
    static final String EXPECTED_LENGTH = "expected_length";
    private int chunkLength;
    static final String CHUNK_LENGTH = "chunk_length";
    private byte[] metadata;
    static final String METADATA = "metadata";
    private AuthEncKey key;
    static final String KEY = "key";
    private long fileSize;
    static final String FILE_SIZE = "file_size";
    private long receivedLength;
    static final String RECEIVED_LENGTH = "received_length";
    private Integer priorityCategory;
    static final String PRIORITY_CATEGORY = "priority_category";
    private boolean downloadRequested;
    static final String DOWNLOAD_REQUESTED = "download_requested";
    private Long timestampOfFetchRequest;
    static final String TIMESTAMP_OF_FETCH_REQUEST = "timestamp_of_fetch_request";
    private boolean markedForDeletion;
    static final String MARKED_FOR_DELETION = "marked_for_deletion";
    private String chunkDownloadPrivateUrls;
    static final String CHUNK_DOWNLOAD_PRIVATE_URLS = "chunk_download_private_urls";
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_CHUNK_RECEIVED = 1L;
    private static final long HOOK_BIT_LAST_CHUNK_RECEIVED = 2L;
    private static final long HOOK_BIT_DOWNLOAD_REQUESTED = 4L;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public int getAttachmentNumber() {
        return this.attachmentNumber;
    }

    public long getExpectedLength() {
        return this.expectedLength;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public AuthEncKey getKey() {
        return this.key;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getReceivedLength() {
        return this.receivedLength;
    }

    public Integer getPriorityCategory() {
        return this.priorityCategory;
    }

    public boolean isDownloadRequested() {
        return this.downloadRequested;
    }

    public Long getTimestampOfFetchRequest() {
        return this.timestampOfFetchRequest;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public String[] getChunkDownloadPrivateUrls() {
        if (this.chunkDownloadPrivateUrls == null) {
            return new String[0];
        }
        return this.chunkDownloadPrivateUrls.split("\u00a6", -1);
    }

    public static UID computeUniqueUid(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] input = new byte[ownedIdentity.getBytes().length + 32 + 8 + 5];
        System.arraycopy(ownedIdentity.getBytes(), 0, input, 0, ownedIdentity.getBytes().length);
        System.arraycopy(messageUid.getBytes(), 0, input, ownedIdentity.getBytes().length, 32);
        System.arraycopy(Encoded.of(attachmentNumber).getBytes(), 0, input, ownedIdentity.getBytes().length + 32, 13);
        return new UID(sha256.digest(input));
    }

    public boolean cannotBeFetched() {
        return this.key == null;
    }

    public long getPlaintextExpectedLength() {
        AuthEnc authEnc = Suite.getDefaultAuthEnc(0);
        long fullChunkCount = (this.expectedLength - 1L) / (long)this.chunkLength;
        return (long)Chunk.lengthOfInnerDataFromLengthOfEncodedChunk(authEnc.plaintextLengthFromCiphertextLength(this.chunkLength)) * fullChunkCount + (long)Chunk.lengthOfInnerDataFromLengthOfEncodedChunk(authEnc.plaintextLengthFromCiphertextLength((int)(this.expectedLength - fullChunkCount * (long)this.chunkLength)));
    }

    public long getPlaintextReceivedLength() {
        AuthEnc authEnc = Suite.getDefaultAuthEnc(0);
        long fullChunkCount = (this.receivedLength - 1L) / (long)this.chunkLength;
        return (long)Chunk.lengthOfInnerDataFromLengthOfEncodedChunk(authEnc.plaintextLengthFromCiphertextLength(this.chunkLength)) * fullChunkCount + (long)Chunk.lengthOfInnerDataFromLengthOfEncodedChunk(authEnc.plaintextLengthFromCiphertextLength((int)(this.receivedLength - fullChunkCount * (long)this.chunkLength)));
    }

    public long getPriority() {
        switch (this.priorityCategory) {
            case 0: {
                return this.expectedLength - this.receivedLength;
            }
            case 1: {
                return -this.timestampOfFetchRequest.longValue();
            }
        }
        return 0L;
    }

    public int getReceivedChunkCount() {
        if (this.receivedLength == this.expectedLength) {
            return 1 + (int)((this.receivedLength - 1L) / (long)this.chunkLength);
        }
        return (int)(this.receivedLength / (long)this.chunkLength);
    }

    public float getProgress() {
        return (float)this.receivedLength / (float)this.expectedLength;
    }

    public InboxMessage getMessage() {
        return InboxMessage.get(this.fetchManagerSession, this.ownedIdentity, this.messageUid);
    }

    public void requestDownload(int priorityCategory) {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxAttachment.requestDownload", "UPDATE inbox_attachment SET download_requested = 1, priority_category = ?, timestamp_of_fetch_request = ?  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setInt(1, priorityCategory);
            long timestamp = System.currentTimeMillis();
            statement.setLong(2, timestamp);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setBytes(4, this.messageUid.getBytes());
            statement.setInt(5, this.attachmentNumber);
            statement.executeUpdate();
            this.downloadRequested = true;
            this.priorityCategory = priorityCategory;
            this.timestampOfFetchRequest = timestamp;
            this.commitHookBits |= 4L;
            this.fetchManagerSession.session.addSessionCommitListener(this);
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public void pauseDownload() {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxAttachment.pauseDownload", "UPDATE inbox_attachment SET download_requested = 0  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setInt(3, this.attachmentNumber);
            statement.executeUpdate();
            this.downloadRequested = false;
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public void markForDeletion() {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxAttachment.markForDeletion", "UPDATE inbox_attachment SET marked_for_deletion = 1  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setInt(3, this.attachmentNumber);
            statement.executeUpdate();
            this.markedForDeletion = true;
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public void setKeyAndMetadata(AuthEncKey key, byte[] metadata) throws Exception {
        if (key == null || metadata == null) {
            throw new IllegalArgumentException();
        }
        if (this.key != null || this.metadata != null) {
            throw new Exception("Attachment key and metadata were already set.");
        }
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxAttachment.setKeyAndMetadata", "UPDATE inbox_attachment SET key = ?, metadata = ?  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setBytes(1, Encoded.of(key).getBytes());
            statement.setBytes(2, metadata);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setBytes(4, this.messageUid.getBytes());
            statement.setInt(5, this.attachmentNumber);
            statement.executeUpdate();
            this.key = key;
            this.metadata = metadata;
        }
    }

    public void setChunkDownloadPrivateUrls(String[] chunkDownloadPrivateUrls) throws Exception {
        if (chunkDownloadPrivateUrls == null || chunkDownloadPrivateUrls.length == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String chunkDownloadPrivateUrl : chunkDownloadPrivateUrls) {
            if (!first) {
                sb.append("\u00a6");
            }
            first = false;
            sb.append(chunkDownloadPrivateUrl);
        }
        String serialized = sb.toString();
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxAttachment.setChunkDownloadPrivateUrls", "UPDATE inbox_attachment SET chunk_download_private_urls = ?  WHERE owned_identity = ? AND message_uid = ?  AND attachment_number = ?;");){
            statement.setString(1, serialized);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.messageUid.getBytes());
            statement.setInt(4, this.attachmentNumber);
            statement.executeUpdate();
            this.chunkDownloadPrivateUrls = serialized;
        }
    }

    public void deleteAttachmentFile() throws IOException {
        File attachmentDirectory = new File(this.fetchManagerSession.engineBaseDirectory, this.getAttachmentDirectory());
        if (!attachmentDirectory.isDirectory()) {
            return;
        }
        SecureFile attachmentFile = new SecureFile(this.fetchManagerSession.engineBaseDirectory, this.getUrl());
        if (attachmentFile.exists() && !attachmentFile.delete()) {
            throw new IOException();
        }
        String[] fileNames = attachmentDirectory.list();
        if (fileNames != null && fileNames.length == 0 && !attachmentDirectory.delete()) {
            throw new IOException();
        }
    }

    private String getAttachmentDirectory() {
        return "inbound_attachments" + File.separator + this.ownedIdentity.computeUniqueUid().toString() + "-" + this.messageUid.toString();
    }

    public String getUrl() {
        return this.getAttachmentDirectory() + File.separator + this.attachmentNumber;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean writeToAttachmentFile(byte[] attachmentBytes, int encryptedLength) {
        new File(this.fetchManagerSession.engineBaseDirectory, this.getAttachmentDirectory()).mkdirs();
        try (SecureFileOutputStream f = new SecureFileOutputStream(new SecureFile(this.fetchManagerSession.engineBaseDirectory + File.separator + this.getAttachmentDirectory(), String.valueOf(this.attachmentNumber)), SecureFileOutputStream.AccessMode.TRUNCATE, this.fileSize);){
            boolean bl;
            block14: {
                f.write(attachmentBytes);
                PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxAttachment.writeToAttachmentFile", "UPDATE inbox_attachment SET received_length = ?, file_size = ?  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");
                try {
                    statement.setLong(1, this.receivedLength + (long)encryptedLength);
                    statement.setLong(2, this.fileSize + (long)attachmentBytes.length);
                    statement.setBytes(3, this.ownedIdentity.getBytes());
                    statement.setBytes(4, this.messageUid.getBytes());
                    statement.setInt(5, this.attachmentNumber);
                    statement.executeUpdate();
                    this.receivedLength += (long)encryptedLength;
                    this.fileSize += (long)attachmentBytes.length;
                    if (this.expectedLength == this.receivedLength) {
                        this.commitHookBits |= 2L;
                    }
                    this.commitHookBits |= 1L;
                    this.fetchManagerSession.session.addSessionCommitListener(this);
                    bl = true;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            Logger.x(e);
            return false;
        }
    }

    public static InboxAttachment create(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID messageUid, int attachmentNumber, long expectedLength, int chunkLength, String[] chunkDownloadPrivateUrls) throws SQLException {
        if (ownedIdentity == null || messageUid == null) {
            return null;
        }
        InboxAttachment inboxAttachment = new InboxAttachment(fetchManagerSession, ownedIdentity, messageUid, attachmentNumber, expectedLength, chunkLength, chunkDownloadPrivateUrls);
        inboxAttachment.insert();
        return inboxAttachment;
    }

    private InboxAttachment(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID messageUid, int attachmentNumber, long expectedLength, int chunkLength, String[] chunkDownloadPrivateUrls) {
        String serialized;
        this.fetchManagerSession = fetchManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
        this.attachmentNumber = attachmentNumber;
        this.expectedLength = expectedLength;
        this.chunkLength = chunkLength;
        this.metadata = null;
        this.key = null;
        this.fileSize = 0L;
        this.receivedLength = 0L;
        this.priorityCategory = null;
        this.downloadRequested = false;
        this.timestampOfFetchRequest = null;
        this.markedForDeletion = false;
        if (chunkDownloadPrivateUrls == null || chunkDownloadPrivateUrls.length == 0) {
            serialized = null;
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String chunkDownloadPrivateUrl : chunkDownloadPrivateUrls) {
                if (!first) {
                    sb.append("\u00a6");
                }
                first = false;
                sb.append(chunkDownloadPrivateUrl);
            }
            serialized = sb.toString();
        }
        this.chunkDownloadPrivateUrls = serialized;
    }

    private InboxAttachment(FetchManagerSession fetchManagerSession, ResultSet res) throws SQLException {
        this.fetchManagerSession = fetchManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.messageUid = new UID(res.getBytes(MESSAGE_UID));
        this.attachmentNumber = res.getInt(ATTACHMENT_NUMBER);
        this.expectedLength = res.getLong(EXPECTED_LENGTH);
        this.chunkLength = res.getInt(CHUNK_LENGTH);
        this.metadata = res.getBytes(METADATA);
        try {
            this.key = (AuthEncKey)new Encoded(res.getBytes(KEY)).decodeSymmetricKey();
        }
        catch (Exception e) {
            this.key = null;
        }
        this.fileSize = res.getLong(FILE_SIZE);
        this.receivedLength = res.getLong(RECEIVED_LENGTH);
        this.priorityCategory = res.getInt(PRIORITY_CATEGORY);
        if (res.wasNull()) {
            this.priorityCategory = null;
        }
        this.downloadRequested = res.getBoolean(DOWNLOAD_REQUESTED);
        this.timestampOfFetchRequest = res.getLong(TIMESTAMP_OF_FETCH_REQUEST);
        if (res.wasNull()) {
            this.timestampOfFetchRequest = null;
        }
        this.markedForDeletion = res.getBoolean(MARKED_FOR_DELETION);
        this.chunkDownloadPrivateUrls = res.getString(CHUNK_DOWNLOAD_PRIVATE_URLS);
    }

    public static InboxAttachment get(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID messageUid, int attachmentNumber) throws SQLException {
        if (ownedIdentity == null || messageUid == null) {
            return null;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxAttachment.get", "SELECT * FROM inbox_attachment WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            InboxAttachment inboxAttachment;
            block17: {
                ResultSet res;
                block15: {
                    InboxAttachment inboxAttachment2;
                    block16: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        statement.setBytes(2, messageUid.getBytes());
                        statement.setInt(3, attachmentNumber);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            inboxAttachment2 = new InboxAttachment(fetchManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return inboxAttachment2;
                }
                inboxAttachment = null;
                if (res == null) break block17;
                res.close();
            }
            return inboxAttachment;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxAttachment[] getAll(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID messageUid) {
        if (ownedIdentity == null || messageUid == null) {
            return null;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxAttachment.getAll", "SELECT * FROM inbox_attachment WHERE owned_identity = ?  AND message_uid = ?  ORDER BY attachment_number ASC;");){
            InboxAttachment[] inboxAttachmentArray;
            block16: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, messageUid.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxAttachment> list = new ArrayList<InboxAttachment>();
                    while (res.next()) {
                        list.add(new InboxAttachment(fetchManagerSession, res));
                    }
                    inboxAttachmentArray = list.toArray(new InboxAttachment[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxAttachmentArray;
        }
        catch (SQLException e) {
            return new InboxAttachment[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxAttachment[] getAllDownloaded(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxAttachment.getAllDownloaded", "SELECT * FROM inbox_attachment WHERE received_length = expected_length AND marked_for_deletion = 0;");){
            InboxAttachment[] inboxAttachmentArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxAttachment> list = new ArrayList<InboxAttachment>();
                    while (res.next()) {
                        list.add(new InboxAttachment(fetchManagerSession, res));
                    }
                    inboxAttachmentArray = list.toArray(new InboxAttachment[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxAttachmentArray;
        }
        catch (SQLException e) {
            return new InboxAttachment[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxAttachment[] getAllAttachmentsToResume(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxAttachment.getAllAttachmentsToResume", "SELECT * FROM inbox_attachment WHERE download_requested = 1  AND key NOT NULL  AND received_length < expected_length AND marked_for_deletion = 0;");){
            InboxAttachment[] inboxAttachmentArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxAttachment> list = new ArrayList<InboxAttachment>();
                    while (res.next()) {
                        list.add(new InboxAttachment(fetchManagerSession, res));
                    }
                    inboxAttachmentArray = list.toArray(new InboxAttachment[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxAttachmentArray;
        }
        catch (SQLException e) {
            return new InboxAttachment[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxAttachment[] getAllPartialAttachmentsNotToResume(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxAttachment.getAllPartialAttachmentsNotToResume", "SELECT * FROM inbox_attachment WHERE download_requested = 0  AND key NOT NULL  AND received_length < expected_length AND received_length > 0  AND marked_for_deletion = 0;");){
            InboxAttachment[] inboxAttachmentArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxAttachment> list = new ArrayList<InboxAttachment>();
                    while (res.next()) {
                        list.add(new InboxAttachment(fetchManagerSession, res));
                    }
                    inboxAttachmentArray = list.toArray(new InboxAttachment[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxAttachmentArray;
        }
        catch (SQLException e) {
            return new InboxAttachment[0];
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS inbox_attachment (owned_identity BLOB NOT NULL, message_uid BLOB NOT NULL, attachment_number INT, expected_length BIGINT NOT NULL, chunk_length INT NOT NULL, metadata BLOB, key BLOB, file_size BIGINT NOT NULL, received_length BIGINT NOT NULL, priority_category INT, download_requested BIT NOT NULL, timestamp_of_fetch_request BIGINT, marked_for_deletion BIT NOT NULL, chunk_download_private_urls TEXT, CONSTRAINT PK_inbox_attachment PRIMARY KEY (owned_identity, message_uid, attachment_number), FOREIGN KEY (owned_identity, message_uid) REFERENCES inbox_message(owned_identity, uid));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 4 && newVersion >= 4) {
            Logger.d("MIGRATING `inbox_attachment` DATABASE FROM VERSION " + oldVersion + " TO 4\n!!!! THIS MIGRATION IS DESTRUCTIVE !!!!");
            statement = session.createStatement();
            try {
                statement.execute("DROP TABLE IF EXISTS `inbox_attachment`;");
                statement.execute("CREATE TABLE IF NOT EXISTS inbox_attachment (message_uid BLOB, attachment_number INT, expected_length BIGINT NOT NULL, chunk_length INT NOT NULL, metadata BLOB, key BLOB, file_size BIGINT NOT NULL, received_length BIGINT NOT NULL, priority_category INT, pending_cancel_fetch_request BIT NOT NULL, download_requested BIT NOT NULL, timestamp_of_fetch_request BIGINT, marked_for_deletion BIT NOT NULL, CONSTRAINT PK_inbox_attachment PRIMARY KEY(message_uid, attachment_number), FOREIGN KEY (message_uid) REFERENCES inbox_message(uid));");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 4;
        }
        if (oldVersion < 8 && newVersion >= 8) {
            Logger.d("MIGRATING `inbox_attachment` DATABASE FROM VERSION " + oldVersion + " TO 8");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_attachment RENAME TO old_inbox_attachment");
                statement.execute("CREATE TABLE IF NOT EXISTS inbox_attachment (message_uid BLOB, attachment_number INT, expected_length BIGINT NOT NULL, chunk_length INT NOT NULL, metadata BLOB, key BLOB, file_size BIGINT NOT NULL, received_length BIGINT NOT NULL, priority_category INT, download_requested BIT NOT NULL, timestamp_of_fetch_request BIGINT, marked_for_deletion BIT NOT NULL, CONSTRAINT PK_inbox_attachment PRIMARY KEY(message_uid, attachment_number), FOREIGN KEY (message_uid) REFERENCES inbox_message(uid))");
                statement.execute("INSERT INTO inbox_attachment  SELECT message_uid, attachment_number, expected_length, chunk_length, metadata,  key, file_size, received_length, priority_category, download_requested,  timestamp_of_fetch_request, marked_for_deletion FROM old_inbox_attachment");
                statement.execute("DROP TABLE old_inbox_attachment");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 8;
        }
        if (oldVersion < 13 && newVersion >= 13) {
            Logger.d("MIGRATING `inbox_attachment` DATABASE FROM VERSION " + oldVersion + " TO 13");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_attachment ADD COLUMN chunk_download_private_urls TEXT DEFAULT NULL;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 13;
        }
        if (oldVersion < 15 && newVersion >= 15) {
            Logger.d("MIGRATING `inbox_attachment` DATABASE FROM VERSION " + oldVersion + " TO 15");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_attachment RENAME TO old_inbox_attachment");
                statement.execute("CREATE TABLE IF NOT EXISTS inbox_attachment (owned_identity BLOB NOT NULL, message_uid BLOB NOT NULL, attachment_number INT, expected_length BIGINT NOT NULL, chunk_length INT NOT NULL, metadata BLOB, key BLOB, file_size BIGINT NOT NULL, received_length BIGINT NOT NULL, priority_category INT, download_requested BIT NOT NULL, timestamp_of_fetch_request BIGINT, marked_for_deletion BIT NOT NULL, chunk_download_private_urls TEXT, CONSTRAINT PK_inbox_attachment PRIMARY KEY (owned_identity, message_uid, attachment_number), FOREIGN KEY (owned_identity, message_uid) REFERENCES inbox_message(owned_identity, uid))");
                statement.execute("INSERT INTO inbox_attachment  SELECT m.owned_identity, a.message_uid, a.attachment_number, a.expected_length, a.chunk_length, a.metadata,  a.key, a.file_size, a.received_length, a.priority_category, a.download_requested,  a.timestamp_of_fetch_request, a.marked_for_deletion, a.chunk_download_private_urls  FROM old_inbox_attachment AS a  INNER JOIN inbox_message AS m ON a.message_uid = m.uid");
                statement.execute("DROP TABLE old_inbox_attachment");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 15;
        }
        if (oldVersion < 16 && newVersion >= 16) {
            Logger.d("MIGRATING `inbox_attachment` DATABASE FROM VERSION " + oldVersion + " TO 16");
            statement = session.createStatement();
            try {
                statement.execute("UPDATE inbox_attachment SET received_length = 0, file_size = 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 16;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxAttachment.insert", "INSERT INTO inbox_attachment VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setInt(3, this.attachmentNumber);
            statement.setLong(4, this.expectedLength);
            statement.setInt(5, this.chunkLength);
            statement.setBytes(6, this.metadata);
            statement.setBytes(7, this.key == null ? null : Encoded.of(this.key).getBytes());
            statement.setLong(8, this.fileSize);
            statement.setLong(9, this.receivedLength);
            if (this.priorityCategory == null) {
                statement.setNull(10, 4);
            } else {
                statement.setInt(10, this.priorityCategory);
            }
            statement.setBoolean(11, this.downloadRequested);
            if (this.timestampOfFetchRequest == null) {
                statement.setNull(12, -5);
            } else {
                statement.setLong(12, this.timestampOfFetchRequest);
            }
            statement.setBoolean(13, this.markedForDeletion);
            statement.setString(14, this.chunkDownloadPrivateUrls);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxAttachment.delete", "DELETE FROM inbox_attachment WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setInt(3, this.attachmentNumber);
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 1L) != 0L && this.fetchManagerSession.inboxAttachmentListener != null) {
            this.fetchManagerSession.inboxAttachmentListener.attachmentDownloadProgressed(this.ownedIdentity, this.messageUid, this.attachmentNumber, this.getProgress());
        }
        if ((this.commitHookBits & 2L) != 0L && this.fetchManagerSession.inboxAttachmentListener != null) {
            this.fetchManagerSession.inboxAttachmentListener.attachmentDownloadFinished(this.ownedIdentity, this.messageUid, this.attachmentNumber);
        }
        if ((this.commitHookBits & 4L) != 0L && this.fetchManagerSession.inboxAttachmentListener != null) {
            this.fetchManagerSession.inboxAttachmentListener.attachmentDownloadWasRequested(this.ownedIdentity, this.messageUid, this.attachmentNumber, this.priorityCategory, this.getPriority());
        }
        this.commitHookBits = 0L;
    }

    public static interface InboxAttachmentListener {
        public void attachmentDownloadProgressed(Identity var1, UID var2, int var3, float var4);

        public void attachmentDownloadFinished(Identity var1, UID var2, int var3);

        public void attachmentDownloadWasRequested(Identity var1, UID var2, int var3, int var4, long var5);
    }
}

