/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class CachedWellKnown
implements ObvDatabase {
    static final String TABLE_NAME = "cached_well_known";
    private final FetchManagerSession fetchManagerSession;
    private String server;
    static final String SERVER = "server";
    private String serializedWellKnown;
    static final String SERIALIZED_WELL_KNOWN = "serialized_well_known";
    private long downloadTimestamp;
    static final String DOWNLOAD_TIMESTAMP = "download_timestamp";

    public String getServer() {
        return this.server;
    }

    public String getSerializedWellKnown() {
        return this.serializedWellKnown;
    }

    public long getDownloadTimestamp() {
        return this.downloadTimestamp;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<CachedWellKnown> getAll(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("CachedWellKnown.getAll", "SELECT * FROM cached_well_known;");){
            ArrayList<CachedWellKnown> arrayList;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<CachedWellKnown> list = new ArrayList<CachedWellKnown>();
                    while (res.next()) {
                        list.add(new CachedWellKnown(fetchManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            return new ArrayList<CachedWellKnown>();
        }
    }

    public static CachedWellKnown get(FetchManagerSession fetchManagerSession, String server) throws SQLException {
        if (server == null) {
            return null;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("CachedWellKnown.get", "SELECT * FROM cached_well_known WHERE server = ?;");){
            CachedWellKnown cachedWellKnown;
            block17: {
                ResultSet res;
                block15: {
                    CachedWellKnown cachedWellKnown2;
                    block16: {
                        statement.setString(1, server);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            cachedWellKnown2 = new CachedWellKnown(fetchManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return cachedWellKnown2;
                }
                cachedWellKnown = null;
                if (res == null) break block17;
                res.close();
            }
            return cachedWellKnown;
        }
    }

    public static CachedWellKnown create(FetchManagerSession fetchManagerSession, String server, String serializedWellKnown) {
        if (server == null || serializedWellKnown == null) {
            return null;
        }
        try {
            CachedWellKnown cachedWellKnown = new CachedWellKnown(fetchManagerSession, server, serializedWellKnown, System.currentTimeMillis());
            cachedWellKnown.insert();
            return cachedWellKnown;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public CachedWellKnown(FetchManagerSession fetchManagerSession, String server, String serializedWellKnown, long downloadTimestamp) {
        this.fetchManagerSession = fetchManagerSession;
        this.server = server;
        this.serializedWellKnown = serializedWellKnown;
        this.downloadTimestamp = downloadTimestamp;
    }

    public CachedWellKnown(FetchManagerSession fetchManagerSession, ResultSet res) throws SQLException {
        this.fetchManagerSession = fetchManagerSession;
        this.server = res.getString(SERVER);
        this.serializedWellKnown = res.getString(SERIALIZED_WELL_KNOWN);
        this.downloadTimestamp = res.getLong(DOWNLOAD_TIMESTAMP);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS cached_well_known (server TEXT PRIMARY KEY, serialized_well_known TEXT NOT NULL, download_timestamp BIGINT NOT NULL);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 19 && newVersion >= 19) {
            Logger.d("MIGRATING `cached_well_known` DATABASE FROM VERSION " + oldVersion + " TO 19");
            try (Statement statement = session.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS cached_well_known (server TEXT PRIMARY KEY, serialized_well_known TEXT NOT NULL, download_timestamp BIGINT NOT NULL);");
            }
            oldVersion = 19;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("CachedWellKnown.insert", "INSERT INTO cached_well_known VALUES (?,?,?);");){
            statement.setString(1, this.server);
            statement.setString(2, this.serializedWellKnown);
            statement.setLong(3, this.downloadTimestamp);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("CachedWellKnown.delete", "DELETE FROM cached_well_known WHERE server = ?;");){
            statement.setString(1, this.server);
            statement.executeUpdate();
        }
    }

    public void update(String serializedWellKnown) throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("CachedWellKnown.update", "UPDATE cached_well_known SET serialized_well_known = ?, download_timestamp = ?  WHERE server = ?;");){
            long timestamp = System.currentTimeMillis();
            statement.setString(1, serializedWellKnown);
            statement.setLong(2, timestamp);
            statement.setString(3, this.server);
            statement.executeUpdate();
            this.serializedWellKnown = serializedWellKnown;
            this.downloadTimestamp = timestamp;
        }
    }

    @Override
    public void wasCommitted() {
    }
}

