/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.VerifyReceiptOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class VerifyReceiptCoordinator
implements Operation.OnCancelCallback {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private final OperationQueue verifyReceiptOperationQueue;
    private NotificationListeningDelegate notificationListeningDelegate;
    private final HashMap<Identity, String> awaitingServerSessionOperations;
    private final Lock awaitingServerSessionOperationsLock;
    private final ServerSessionCreatedNotificationListener serverSessionCreatedNotificationListener;

    public VerifyReceiptCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, CreateServerSessionDelegate createServerSessionDelegate) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.verifyReceiptOperationQueue = new OperationQueue(true);
        this.awaitingServerSessionOperations = new HashMap();
        this.awaitingServerSessionOperationsLock = new ReentrantLock();
        this.serverSessionCreatedNotificationListener = new ServerSessionCreatedNotificationListener();
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("network_fetch_notification_server_session_created", this.serverSessionCreatedNotificationListener);
    }

    private void queueNewVerifyReceiptOperation(Identity ownedIdentity, String storeToken) {
        VerifyReceiptOperation op = new VerifyReceiptOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, ownedIdentity, storeToken, this);
        this.verifyReceiptOperationQueue.queue(op);
    }

    public void startProcessing() {
        this.verifyReceiptOperationQueue.execute(1, "Engine-VerifyReceiptCoordinator");
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((VerifyReceiptOperation)operation).getOwnedIdentity();
        String storeToken = ((VerifyReceiptOperation)operation).getStoreToken();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("VerifyReceiptOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 0: {
                if (ownedIdentity == null) break;
                this.waitForServerSession(ownedIdentity, storeToken);
                this.createServerSessionDelegate.createServerSession(ownedIdentity);
            }
        }
    }

    private void waitForServerSession(Identity identity, String storeToken) {
        this.awaitingServerSessionOperationsLock.lock();
        this.awaitingServerSessionOperations.put(identity, storeToken);
        this.awaitingServerSessionOperationsLock.unlock();
    }

    public void verifyReceipt(Identity ownedIdentity, String storeToken) {
        this.queueNewVerifyReceiptOperation(ownedIdentity, storeToken);
    }

    class ServerSessionCreatedNotificationListener
    implements NotificationListener {
        ServerSessionCreatedNotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if (!notificationName.equals("network_fetch_notification_server_session_created")) {
                return;
            }
            Object identityObject = userInfo.get("identity");
            if (!(identityObject instanceof Identity)) {
                return;
            }
            Identity ownedIdentity = (Identity)identityObject;
            VerifyReceiptCoordinator.this.awaitingServerSessionOperationsLock.lock();
            String storeToken = VerifyReceiptCoordinator.this.awaitingServerSessionOperations.get(ownedIdentity);
            if (storeToken != null) {
                VerifyReceiptCoordinator.this.awaitingServerSessionOperations.remove(ownedIdentity);
                VerifyReceiptCoordinator.this.queueNewVerifyReceiptOperation(ownedIdentity, storeToken);
            }
            VerifyReceiptCoordinator.this.awaitingServerSessionOperationsLock.unlock();
        }
    }
}

