/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.GroupInformation;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.containers.UserData;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.networkfetch.databases.PendingServerQuery;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.DeleteUserDataOperation;
import io.olvid.engine.networkfetch.operations.RefreshUserDataOperation;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.datatypes.DirectoryListingResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class ServerUserDataCoordinator
implements Operation.OnCancelCallback,
Operation.OnFinishCallback {
    private final ObjectMapper jsonObjectMapper;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private final PRNGService prng;
    private final ExponentialBackoffRepeatingScheduler<IdentityAndUid> scheduler;
    private final NoDuplicateOperationQueue deleteUserDataOperationQueue;
    private final NoDuplicateOperationQueue refreshUserDataOperationQueue;
    private final HashMap<Identity, List<UID>> awaitingServerSessionDeleteOperations;
    private final Lock awaitingServerSessionDeleteOperationsLock;
    private final HashMap<Identity, List<UID>> awaitingServerSessionRefreshOperations;
    private final Lock awaitingServerSessionRefreshOperationsLock;
    private final NotificationListener notificationListener;
    private NotificationListeningDelegate notificationListeningDelegate;

    public ServerUserDataCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, CreateServerSessionDelegate createServerSessionDelegate, ObjectMapper jsonObjectMapper, PRNGService prng) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.jsonObjectMapper = jsonObjectMapper;
        this.prng = prng;
        this.deleteUserDataOperationQueue = new NoDuplicateOperationQueue();
        this.refreshUserDataOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingServerSessionDeleteOperations = new HashMap();
        this.awaitingServerSessionDeleteOperationsLock = new ReentrantLock();
        this.awaitingServerSessionRefreshOperations = new HashMap();
        this.awaitingServerSessionRefreshOperationsLock = new ReentrantLock();
        this.notificationListener = new NotificationListener();
    }

    public void startProcessing() {
        this.deleteUserDataOperationQueue.execute(1, "Engine-ServerUserDataCoordinator-delete");
        this.refreshUserDataOperationQueue.execute(1, "Engine-ServerUserDataCoordinator-refresh");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("network_fetch_notification_server_session_created", this.notificationListener);
        this.notificationListeningDelegate.addListener("identity_manager_notification_server_user_data_can_be_deleted", this.notificationListener);
    }

    public void initialQueueing() {
        FetchManagerSession fetchManagerSession;
        try {
            fetchManagerSession = this.fetchManagerSessionFactory.getSession();
            try {
                UserData[] userDataList;
                block23: for (UserData userData : userDataList = fetchManagerSession.identityDelegate.getAllUserData(fetchManagerSession.session)) {
                    switch (userData.type) {
                        case OWNED_IDENTITY: {
                            JsonIdentityDetailsWithVersionAndPhoto details = fetchManagerSession.identityDelegate.getOwnedIdentityPublishedDetails(fetchManagerSession.session, userData.ownedIdentity);
                            if (details == null || !Arrays.equals(details.getPhotoServerLabel(), userData.label.getBytes())) {
                                this.queueNewDeleteUserDataOperation(userData.ownedIdentity, userData.label);
                                continue block23;
                            }
                            if (userData.nextRefreshTimestamp < System.currentTimeMillis()) {
                                this.queueNewRefreshUserDataOperation(userData.ownedIdentity, userData.label);
                                continue block23;
                            }
                            this.scheduler.schedule(new IdentityAndUid(userData.ownedIdentity, userData.label), () -> this.queueNewRefreshUserDataOperation(userData.ownedIdentity, userData.label), "ServerQueryOperation", userData.nextRefreshTimestamp - System.currentTimeMillis());
                            continue block23;
                        }
                        case GROUP: {
                            GroupInformation groupInformation = fetchManagerSession.identityDelegate.getGroupInformation(fetchManagerSession.session, userData.ownedIdentity, userData.bytesGroupOwnerAndUidOrIdentifier);
                            if (groupInformation == null || !groupInformation.groupOwnerIdentity.equals(userData.ownedIdentity)) {
                                this.queueNewDeleteUserDataOperation(userData.ownedIdentity, userData.label);
                                continue block23;
                            }
                            try {
                                JsonGroupDetailsWithVersionAndPhoto detailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)this.jsonObjectMapper.readValue(groupInformation.serializedGroupDetailsWithVersionAndPhoto, JsonGroupDetailsWithVersionAndPhoto.class);
                                if (detailsWithVersionAndPhoto == null || !Arrays.equals(detailsWithVersionAndPhoto.getPhotoServerLabel(), userData.label.getBytes())) {
                                    this.queueNewDeleteUserDataOperation(userData.ownedIdentity, userData.label);
                                    continue block23;
                                }
                                if (userData.nextRefreshTimestamp < System.currentTimeMillis()) {
                                    this.queueNewRefreshUserDataOperation(userData.ownedIdentity, userData.label);
                                    continue block23;
                                }
                                this.scheduler.schedule(new IdentityAndUid(userData.ownedIdentity, userData.label), () -> this.queueNewRefreshUserDataOperation(userData.ownedIdentity, userData.label), "ServerQueryOperation", userData.nextRefreshTimestamp - System.currentTimeMillis());
                            }
                            catch (Exception e) {
                                this.queueNewDeleteUserDataOperation(userData.ownedIdentity, userData.label);
                            }
                            continue block23;
                        }
                        case GROUP_V2: {
                            GroupV2.ServerPhotoInfo serverPhotoInfo = fetchManagerSession.identityDelegate.getGroupV2PublishedServerPhotoInfo(fetchManagerSession.session, userData.ownedIdentity, userData.bytesGroupOwnerAndUidOrIdentifier);
                            if (serverPhotoInfo == null || !Objects.equals(userData.ownedIdentity, serverPhotoInfo.serverPhotoIdentity) || !Objects.equals(userData.label, serverPhotoInfo.serverPhotoLabel)) {
                                this.queueNewDeleteUserDataOperation(userData.ownedIdentity, userData.label);
                                continue block23;
                            }
                            if (userData.nextRefreshTimestamp < System.currentTimeMillis()) {
                                this.queueNewRefreshUserDataOperation(userData.ownedIdentity, userData.label);
                                continue block23;
                            }
                            this.scheduler.schedule(new IdentityAndUid(userData.ownedIdentity, userData.label), () -> this.queueNewRefreshUserDataOperation(userData.ownedIdentity, userData.label), "ServerQueryOperation", userData.nextRefreshTimestamp - System.currentTimeMillis());
                            continue block23;
                        }
                    }
                }
            }
            finally {
                if (fetchManagerSession != null) {
                    fetchManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            fetchManagerSession = this.fetchManagerSessionFactory.getSession();
            try {
                SecureFile userDataDir = new SecureFile(fetchManagerSession.engineBaseDirectory, "downloaded_user_data");
                DirectoryListingResult userDataFiles = userDataDir.listDirectory();
                if (userDataFiles != null) {
                    for (SecureFile userDataFile : userDataFiles.getSecureFileList()) {
                        long expireTimestamp;
                        int pos = userDataFile.getPlainNameFile().getName().indexOf(".");
                        if (pos != -1 && (expireTimestamp = Long.parseLong(userDataFile.getPlainNameFile().getName().substring(0, pos))) > System.currentTimeMillis()) continue;
                        try {
                            userDataFile.delete();
                        }
                        catch (Exception e) {
                            Logger.x(e);
                        }
                    }
                }
            }
            finally {
                if (fetchManagerSession != null) {
                    fetchManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    private void queueNewRefreshUserDataOperation(Identity ownedIdentity, UID label) {
        RefreshUserDataOperation op = new RefreshUserDataOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, ownedIdentity, label, this, this);
        this.refreshUserDataOperationQueue.queue(op);
    }

    private void scheduleNewRefreshUserDataOperation(Identity ownedIdentity, UID label) {
        this.scheduler.schedule(new IdentityAndUid(ownedIdentity, label), () -> this.queueNewRefreshUserDataOperation(ownedIdentity, label), "RefreshUserDataOperation");
    }

    private void queueNewDeleteUserDataOperation(Identity ownedIdentity, UID label) {
        DeleteUserDataOperation op = new DeleteUserDataOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, ownedIdentity, label, this, this);
        this.deleteUserDataOperationQueue.queue(op);
    }

    private void scheduleNewDeleteUserDataOperation(Identity ownedIdentity, UID label) {
        this.scheduler.schedule(new IdentityAndUid(ownedIdentity, label), () -> this.queueNewDeleteUserDataOperation(ownedIdentity, label), "DeleteUserDataOperation");
    }

    private void deleteWaitForServerSession(Identity identity, UID label) {
        this.awaitingServerSessionDeleteOperationsLock.lock();
        List<UID> list = this.awaitingServerSessionDeleteOperations.get(identity);
        if (list == null) {
            list = new ArrayList<UID>();
            this.awaitingServerSessionDeleteOperations.put(identity, list);
        }
        list.add(label);
        this.awaitingServerSessionDeleteOperationsLock.unlock();
    }

    private void refreshWaitForServerSession(Identity identity, UID label) {
        this.awaitingServerSessionRefreshOperationsLock.lock();
        List<UID> list = this.awaitingServerSessionRefreshOperations.get(identity);
        if (list == null) {
            list = new ArrayList<UID>();
            this.awaitingServerSessionRefreshOperations.put(identity, list);
        }
        list.add(label);
        this.awaitingServerSessionRefreshOperationsLock.unlock();
    }

    @Override
    public void onCancelCallback(Operation operation) {
        if (operation instanceof RefreshUserDataOperation) {
            Identity ownedIdentity = ((RefreshUserDataOperation)operation).getOwnedIdentity();
            UID label = ((RefreshUserDataOperation)operation).getLabel();
            Integer rfc = operation.getReasonForCancel();
            Logger.d("RefreshUserDataOperation cancelled for reason " + rfc);
            if (rfc == null) {
                rfc = -1;
            }
            switch (rfc) {
                case 3: {
                    this.refreshWaitForServerSession(ownedIdentity, label);
                    this.createServerSessionDelegate.createServerSession(ownedIdentity);
                    break;
                }
                case 5: {
                    try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
                        String photoUrl;
                        UserData userData = fetchManagerSession.identityDelegate.getUserData(fetchManagerSession.session, ownedIdentity, label);
                        if (userData == null) break;
                        AuthEncKey key = switch (userData.type) {
                            case UserData.Type.OWNED_IDENTITY -> {
                                Object json = fetchManagerSession.identityDelegate.getOwnedIdentityPublishedDetails(fetchManagerSession.session, userData.ownedIdentity);
                                photoUrl = ((JsonIdentityDetailsWithVersionAndPhoto)json).getPhotoUrl();
                                yield (AuthEncKey)new Encoded(((JsonIdentityDetailsWithVersionAndPhoto)json).getPhotoServerKey()).decodeSymmetricKey();
                            }
                            case UserData.Type.GROUP -> {
                                Object json = fetchManagerSession.identityDelegate.getGroupPublishedAndLatestOrTrustedDetails(fetchManagerSession.session, userData.ownedIdentity, userData.bytesGroupOwnerAndUidOrIdentifier)[0];
                                photoUrl = ((JsonGroupDetailsWithVersionAndPhoto)json).getPhotoUrl();
                                yield (AuthEncKey)new Encoded(((JsonGroupDetailsWithVersionAndPhoto)json).getPhotoServerKey()).decodeSymmetricKey();
                            }
                            case UserData.Type.GROUP_V2 -> {
                                GroupV2.ServerPhotoInfo serverPhotoInfo = fetchManagerSession.identityDelegate.getGroupV2PublishedServerPhotoInfo(fetchManagerSession.session, userData.ownedIdentity, userData.bytesGroupOwnerAndUidOrIdentifier);
                                photoUrl = fetchManagerSession.identityDelegate.getGroupV2PhotoUrl(fetchManagerSession.session, userData.ownedIdentity, GroupV2.Identifier.of(userData.bytesGroupOwnerAndUidOrIdentifier));
                                yield serverPhotoInfo.serverPhotoKey;
                            }
                            default -> {
                                photoUrl = null;
                                yield null;
                            }
                        };
                        if (photoUrl != null && key != null) {
                            ServerQuery serverQuery = new ServerQuery(Encoded.of(new Encoded[0]), ownedIdentity, new ServerQuery.PutUserDataQuery(ownedIdentity, label, photoUrl, key));
                            PendingServerQuery.create(fetchManagerSession, serverQuery, this.prng);
                            fetchManagerSession.session.commit();
                        }
                        break;
                    }
                    catch (Exception e) {
                        Logger.x(e);
                        break;
                    }
                }
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    this.scheduleNewRefreshUserDataOperation(ownedIdentity, label);
                }
            }
        } else if (operation instanceof DeleteUserDataOperation) {
            Identity ownedIdentity = ((DeleteUserDataOperation)operation).getOwnedIdentity();
            UID label = ((DeleteUserDataOperation)operation).getLabel();
            Integer rfc = operation.getReasonForCancel();
            Logger.i("DeleteUserDataOperation cancelled for reason " + rfc);
            if (rfc == null) {
                rfc = -1;
            }
            switch (rfc) {
                case 3: {
                    this.deleteWaitForServerSession(ownedIdentity, label);
                    this.createServerSessionDelegate.createServerSession(ownedIdentity);
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    this.scheduleNewDeleteUserDataOperation(ownedIdentity, label);
                }
            }
        }
    }

    @Override
    public void onFinishCallback(Operation operation) {
        if (operation instanceof RefreshUserDataOperation) {
            Logger.d("RefreshUserDataOperation finished");
            Identity ownedIdentity = ((RefreshUserDataOperation)operation).getOwnedIdentity();
            UID label = ((RefreshUserDataOperation)operation).getLabel();
            this.scheduler.clearFailedCount(new IdentityAndUid(ownedIdentity, label));
            this.newUserDataUploaded(ownedIdentity, label);
        } else if (operation instanceof DeleteUserDataOperation) {
            Logger.d("DeleteUserDataOperation finished");
            Identity ownedIdentity = ((DeleteUserDataOperation)operation).getOwnedIdentity();
            UID label = ((DeleteUserDataOperation)operation).getLabel();
            this.scheduler.clearFailedCount(new IdentityAndUid(ownedIdentity, label));
        }
    }

    void newUserDataUploaded(Identity ownedIdentity, UID label) {
        this.scheduler.schedule(new IdentityAndUid(ownedIdentity, label), () -> this.queueNewRefreshUserDataOperation(ownedIdentity, label), "ServerQueryOperation", 604800000L);
    }

    class NotificationListener
    implements io.olvid.engine.datatypes.NotificationListener {
        NotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            try {
                switch (notificationName) {
                    case "network_fetch_notification_server_session_created": {
                        Identity ownedIdentity = (Identity)userInfo.get("identity");
                        ServerUserDataCoordinator.this.awaitingServerSessionDeleteOperationsLock.lock();
                        List<UID> labels = ServerUserDataCoordinator.this.awaitingServerSessionDeleteOperations.get(ownedIdentity);
                        if (labels != null) {
                            ServerUserDataCoordinator.this.awaitingServerSessionDeleteOperations.remove(ownedIdentity);
                            for (UID label : labels) {
                                ServerUserDataCoordinator.this.queueNewDeleteUserDataOperation(ownedIdentity, label);
                            }
                        }
                        ServerUserDataCoordinator.this.awaitingServerSessionDeleteOperationsLock.unlock();
                        ServerUserDataCoordinator.this.awaitingServerSessionRefreshOperationsLock.lock();
                        labels = ServerUserDataCoordinator.this.awaitingServerSessionRefreshOperations.get(ownedIdentity);
                        if (labels != null) {
                            ServerUserDataCoordinator.this.awaitingServerSessionRefreshOperations.remove(ownedIdentity);
                            for (UID label : labels) {
                                ServerUserDataCoordinator.this.queueNewRefreshUserDataOperation(ownedIdentity, label);
                            }
                        }
                        ServerUserDataCoordinator.this.awaitingServerSessionRefreshOperationsLock.unlock();
                        break;
                    }
                    case "identity_manager_notification_server_user_data_can_be_deleted": {
                        Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                        UID label = (UID)userInfo.get("label");
                        if (ownedIdentity == null || label == null) break;
                        ServerUserDataCoordinator.this.queueNewDeleteUserDataOperation(ownedIdentity, label);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
    }
}

