/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelServerResponseMessageToSend;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.metamanager.ChannelDelegate;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.networkfetch.coordinators.ServerQueryCoordinatorWebSocketModule;
import io.olvid.engine.networkfetch.coordinators.ServerUserDataCoordinator;
import io.olvid.engine.networkfetch.databases.PendingServerQuery;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.ServerQueryOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class ServerQueryCoordinator
implements PendingServerQuery.PendingServerQueryListener,
Operation.OnCancelCallback,
Operation.OnFinishCallback {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final PRNGService prng;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private final ServerQueryCoordinatorWebSocketModule webSocketModule;
    private final ExponentialBackoffRepeatingScheduler<UID> scheduler;
    private final NoDuplicateOperationQueue serverQueriesOperationQueue;
    private final HashMap<Identity, List<UID>> awaitingServerSessionOperations;
    private final Lock awaitingServerSessionOperationsLock;
    private final NotificationListener notificationListener;
    private final ServerUserDataCoordinator serverUserDataCoordinator;
    private final HashMap<Identity, List<UID>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;
    private NotificationListeningDelegate notificationListeningDelegate;
    private ChannelDelegate channelDelegate;

    public ServerQueryCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, PRNGService prng, CreateServerSessionDelegate createServerSessionDelegate, ServerUserDataCoordinator serverUserDataCoordinator, ObjectMapper jsonObjectMapper) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.prng = prng;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.serverUserDataCoordinator = serverUserDataCoordinator;
        this.webSocketModule = new ServerQueryCoordinatorWebSocketModule(fetchManagerSessionFactory, sslSocketFactory, jsonObjectMapper, prng);
        this.serverQueriesOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingServerSessionOperations = new HashMap();
        this.awaitingServerSessionOperationsLock = new ReentrantLock();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
        this.notificationListener = new NotificationListener();
    }

    public void startProcessing() {
        this.serverQueriesOperationQueue.execute(1, "Engine-ServerQueryCoordinator");
    }

    public void initialQueueing() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            PendingServerQuery[] pendingServerQueries;
            for (PendingServerQuery pendingServerQuery : pendingServerQueries = PendingServerQuery.getAll(fetchManagerSession)) {
                if (pendingServerQuery.isWebSocket()) {
                    pendingServerQuery.delete();
                    continue;
                }
                this.queueNewServerQueryOperation(pendingServerQuery.getUid());
            }
            fetchManagerSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("network_fetch_notification_server_session_created", this.notificationListener);
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.notificationListener);
    }

    public void setChannelDelegate(ChannelDelegate channelDelegate) {
        this.channelDelegate = channelDelegate;
        this.webSocketModule.setChannelDelegate(channelDelegate);
    }

    private void waitForServerSession(Identity identity, UID serverQueryUid) {
        this.awaitingServerSessionOperationsLock.lock();
        List<UID> list = this.awaitingServerSessionOperations.get(identity);
        if (list == null) {
            list = new ArrayList<UID>();
            this.awaitingServerSessionOperations.put(identity, list);
        }
        list.add(serverQueryUid);
        this.awaitingServerSessionOperationsLock.unlock();
    }

    private void waitForIdentityReactivation(Identity identity, UID serverQueryUid) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<UID> list = this.awaitingIdentityReactivationOperations.get(identity);
        if (list == null) {
            list = new ArrayList<UID>();
            this.awaitingIdentityReactivationOperations.put(identity, list);
        }
        list.add(serverQueryUid);
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    private void queueNewServerQueryOperation(UID serverQueryUid) {
        ServerQueryOperation op = new ServerQueryOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, serverQueryUid, this.prng, this, this);
        this.serverQueriesOperationQueue.queue(op);
    }

    private void scheduleNewServerQueryOperation(UID serverQueryUid) {
        this.scheduler.schedule(serverQueryUid, () -> this.queueNewServerQueryOperation(serverQueryUid), "ServerQueryOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    @Override
    public void onCancelCallback(Operation operation) {
        UID serverQueryUid = ((ServerQueryOperation)operation).getServerQueryUid();
        ServerQuery serverQuery = ((ServerQueryOperation)operation).getServerQuery();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("ServerQueryOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
                    PendingServerQuery pendingServerQuery = PendingServerQuery.get(fetchManagerSession, serverQueryUid);
                    if (pendingServerQuery != null) {
                        pendingServerQuery.delete();
                        fetchManagerSession.session.commit();
                    }
                }
                catch (SQLException e) {
                    Logger.x(e);
                }
                break;
            }
            case 3: {
                this.waitForServerSession(serverQuery.getOwnedIdentity(), serverQueryUid);
                this.createServerSessionDelegate.createServerSession(serverQuery.getOwnedIdentity());
                break;
            }
            case 4: {
                this.waitForIdentityReactivation(serverQuery.getOwnedIdentity(), serverQueryUid);
                break;
            }
            default: {
                this.scheduleNewServerQueryOperation(serverQueryUid);
            }
        }
    }

    @Override
    public void onFinishCallback(Operation operation) {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            UID serverQueryUid = ((ServerQueryOperation)operation).getServerQueryUid();
            ServerQuery serverQuery = ((ServerQueryOperation)operation).getServerQuery();
            Encoded serverResponse = ((ServerQueryOperation)operation).getServerResponse();
            this.scheduler.clearFailedCount(serverQueryUid);
            PendingServerQuery pendingServerQuery = PendingServerQuery.get(fetchManagerSession, serverQueryUid);
            if (pendingServerQuery == null) {
                return;
            }
            boolean partOfProtocol = true;
            try {
                partOfProtocol = serverQuery.getEncodedElements().decodeList().length != 0;
            }
            catch (DecodingException decodingException) {
                // empty catch block
            }
            if (partOfProtocol) {
                ChannelServerResponseMessageToSend channelServerResponseMessageToSend = new ChannelServerResponseMessageToSend(serverQuery.getOwnedIdentity(), serverResponse, serverQuery.getEncodedElements());
                if (this.channelDelegate == null) {
                    Logger.e("ServerQueryOperation finished but no ChannelDelegate is set to post the response to.");
                    return;
                }
                try {
                    fetchManagerSession.session.startTransaction();
                    try {
                        this.channelDelegate.post(fetchManagerSession.session, channelServerResponseMessageToSend, this.prng);
                    }
                    catch (NoAcceptableChannelException noAcceptableChannelException) {
                        // empty catch block
                    }
                    pendingServerQuery.delete();
                    fetchManagerSession.session.commit();
                }
                catch (Exception e) {
                    fetchManagerSession.session.rollback();
                }
            } else {
                pendingServerQuery.delete();
                fetchManagerSession.session.commit();
            }
            if (serverQuery.getType() instanceof ServerQuery.PutUserDataQuery) {
                this.serverUserDataCoordinator.newUserDataUploaded(serverQuery.getOwnedIdentity(), ((ServerQuery.PutUserDataQuery)serverQuery.getType()).serverLabel);
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void newPendingServerQuery(PendingServerQuery pendingServerQuery) {
        if (pendingServerQuery.isWebSocket()) {
            this.webSocketModule.handleServerQuery(pendingServerQuery, false);
        } else {
            this.queueNewServerQueryOperation(pendingServerQuery.getUid());
        }
    }

    class NotificationListener
    implements io.olvid.engine.datatypes.NotificationListener {
        NotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            try {
                switch (notificationName) {
                    case "identity_manager_notification_owned_identity_changed_active_status": {
                        boolean active = (Boolean)userInfo.get("active");
                        Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                        if (!active) break;
                        ServerQueryCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                        List<UID> serverQueryUids = ServerQueryCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                        if (serverQueryUids != null) {
                            ServerQueryCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                            for (UID serverQueryUid : serverQueryUids) {
                                ServerQueryCoordinator.this.queueNewServerQueryOperation(serverQueryUid);
                            }
                        }
                        ServerQueryCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
                        break;
                    }
                    case "network_fetch_notification_server_session_created": {
                        Identity ownedIdentity = (Identity)userInfo.get("identity");
                        ServerQueryCoordinator.this.awaitingServerSessionOperationsLock.lock();
                        List<UID> serverQueryUids = ServerQueryCoordinator.this.awaitingServerSessionOperations.get(ownedIdentity);
                        if (serverQueryUids != null) {
                            ServerQueryCoordinator.this.awaitingServerSessionOperations.remove(ownedIdentity);
                            for (UID serverQueryUid : serverQueryUids) {
                                ServerQueryCoordinator.this.queueNewServerQueryOperation(serverQueryUid);
                            }
                        }
                        ServerQueryCoordinator.this.awaitingServerSessionOperationsLock.unlock();
                        break;
                    }
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
    }
}

