/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUidAndNumber;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.networkfetch.databases.InboxAttachment;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.RefreshInboxAttachmentSignedUrlDelegate;
import io.olvid.engine.networkfetch.operations.RefreshInboxAttachmentSignedUrlOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class RefreshInboxAttachmentSignedUrlCoordinator
implements Operation.OnFinishCallback,
Operation.OnCancelCallback,
RefreshInboxAttachmentSignedUrlDelegate {
    private final ExponentialBackoffRepeatingScheduler<IdentityAndUidAndNumber> scheduler;
    private final NoDuplicateOperationQueue refreshInboxAttachmentSignedUrlOperationQueue;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private NotificationPostingDelegate notificationPostingDelegate;
    private final HashMap<Identity, List<IdentityAndUidAndNumber>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;
    private final AwaitingIdentityReactivationNotificationListener awaitingIdentityReactivationNotificationListener;
    private final HashMap<IdentityAndUidAndNumber, Long> lastUrlRefreshTimestamps;

    public RefreshInboxAttachmentSignedUrlCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.lastUrlRefreshTimestamps = new HashMap();
        this.refreshInboxAttachmentSignedUrlOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
        this.awaitingIdentityReactivationNotificationListener = new AwaitingIdentityReactivationNotificationListener();
    }

    public void startProcessing() {
        this.refreshInboxAttachmentSignedUrlOperationQueue.execute(1, "Engine-RefreshInboxAttachmentSignedUrlCoordinator");
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.awaitingIdentityReactivationNotificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNewRefreshInboxAttachmentSignedUrlOperation(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        HashMap<IdentityAndUidAndNumber, Long> hashMap = this.lastUrlRefreshTimestamps;
        synchronized (hashMap) {
            this.lastUrlRefreshTimestamps.put(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), System.currentTimeMillis());
        }
        RefreshInboxAttachmentSignedUrlOperation op = new RefreshInboxAttachmentSignedUrlOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, ownedIdentity, messageUid, attachmentNumber, this, this);
        this.refreshInboxAttachmentSignedUrlOperationQueue.queue(op);
    }

    private void scheduleNewRefreshInboxAttachmentSignedUrlOperationQueueing(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.scheduler.schedule(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), () -> this.queueNewRefreshInboxAttachmentSignedUrlOperation(ownedIdentity, messageUid, attachmentNumber), "RefreshInboxAttachmentSignedUrlOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForIdentityReactivation(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<IdentityAndUidAndNumber> list = this.awaitingIdentityReactivationOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<IdentityAndUidAndNumber>();
            this.awaitingIdentityReactivationOperations.put(ownedIdentity, list);
        }
        list.add(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    @Override
    public void onFinishCallback(Operation operation) {
        Identity ownedIdentity = ((RefreshInboxAttachmentSignedUrlOperation)operation).getOwnedIdentity();
        UID messageUid = ((RefreshInboxAttachmentSignedUrlOperation)operation).getMessageUid();
        int attachmentNumber = ((RefreshInboxAttachmentSignedUrlOperation)operation).getAttachmentNumber();
        this.scheduler.clearFailedCount(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("owned_identity", ownedIdentity);
        userInfo.put("message_uid", messageUid);
        userInfo.put("attachment_number", attachmentNumber);
        this.notificationPostingDelegate.postNotification("network_fetch_notification_signed_url_refreshed", userInfo);
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((RefreshInboxAttachmentSignedUrlOperation)operation).getOwnedIdentity();
        UID messageUid = ((RefreshInboxAttachmentSignedUrlOperation)operation).getMessageUid();
        int attachmentNumber = ((RefreshInboxAttachmentSignedUrlOperation)operation).getAttachmentNumber();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("RefreshInboxAttachmentSignedUrlOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 2: {
                break;
            }
            case 4: {
                this.waitForIdentityReactivation(ownedIdentity, messageUid, attachmentNumber);
                break;
            }
            case 3: {
                try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
                    InboxAttachment attachment = InboxAttachment.get(fetchManagerSession, ownedIdentity, messageUid, attachmentNumber);
                    if (attachment != null) {
                        fetchManagerSession.session.startTransaction();
                        attachment.markForDeletion();
                        if (attachment.getMessage().canBeDeleted()) {
                            fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeDeletedFromServer(ownedIdentity, messageUid);
                        }
                        fetchManagerSession.session.commit();
                    }
                }
                catch (SQLException e) {
                    Logger.x(e);
                }
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", ownedIdentity);
                userInfo.put("messageUid", messageUid);
                userInfo.put("attachmentNumber", attachmentNumber);
                this.notificationPostingDelegate.postNotification("network_fetch_notification_attachment_download_failed", userInfo);
                break;
            }
            default: {
                this.scheduleNewRefreshInboxAttachmentSignedUrlOperationQueueing(ownedIdentity, messageUid, attachmentNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshInboxAttachmentSignedUrl(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        HashMap<IdentityAndUidAndNumber, Long> hashMap = this.lastUrlRefreshTimestamps;
        synchronized (hashMap) {
            Long timestamp = this.lastUrlRefreshTimestamps.get(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
            if (timestamp != null && System.currentTimeMillis() - timestamp < 3600000L) {
                long delay = 3600000L - (System.currentTimeMillis() - timestamp);
                this.scheduler.schedule(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), () -> this.queueNewRefreshInboxAttachmentSignedUrlOperation(ownedIdentity, messageUid, attachmentNumber), "too frequent RefreshInboxAttachmentSignedUrlOperation", delay);
            } else {
                this.queueNewRefreshInboxAttachmentSignedUrlOperation(ownedIdentity, messageUid, attachmentNumber);
            }
        }
    }

    class AwaitingIdentityReactivationNotificationListener
    implements NotificationListener {
        AwaitingIdentityReactivationNotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if (notificationName.equals("identity_manager_notification_owned_identity_changed_active_status")) {
                try {
                    boolean active = (Boolean)userInfo.get("active");
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    if (!active) {
                        return;
                    }
                    RefreshInboxAttachmentSignedUrlCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                    List<IdentityAndUidAndNumber> list = RefreshInboxAttachmentSignedUrlCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                    if (list != null) {
                        RefreshInboxAttachmentSignedUrlCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                        for (IdentityAndUidAndNumber params : list) {
                            RefreshInboxAttachmentSignedUrlCoordinator.this.queueNewRefreshInboxAttachmentSignedUrlOperation(params.ownedIdentity, params.uid, params.attachmentNumber);
                        }
                    }
                    RefreshInboxAttachmentSignedUrlCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
        }
    }
}

