/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicatePriorityOperationQueue;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.NetworkReceivedMessage;
import io.olvid.engine.datatypes.containers.ReceivedAttachment;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.ProcessDownloadedMessageDelegate;
import io.olvid.engine.networkfetch.databases.InboxAttachment;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.DownloadMessagesAndListAttachmentsDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.RegisterServerPushNotificationDelegate;
import io.olvid.engine.networkfetch.operations.DownloadMessagesAndListAttachmentsOperation;
import io.olvid.engine.networkfetch.operations.ProcessPreKeyMessagesForNewContactOperation;
import io.olvid.engine.networkfetch.operations.ProcessWebsocketReceivedMessageOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class DownloadMessagesAndListAttachmentsCoordinator
implements Operation.OnCancelCallback,
DownloadMessagesAndListAttachmentsDelegate,
InboxMessage.InboxMessageListener,
Operation.OnFinishCallback,
NotificationListener {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private RegisterServerPushNotificationDelegate registerServerPushNotificationDelegate;
    private final ExponentialBackoffRepeatingScheduler<Identity> scheduler;
    private final NoDuplicatePriorityOperationQueue downloadMessagesAndListAttachmentsOperationQueue;
    private ProcessDownloadedMessageDelegate processDownloadedMessageDelegate;
    private final HashMap<Identity, UID> awaitingServerSessionOperations;
    private final Lock awaitingServerSessionOperationsLock;
    private final AwaitingNotificationListener awaitingNotificationListener;
    private NotificationListeningDelegate notificationListeningDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;

    public DownloadMessagesAndListAttachmentsCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, CreateServerSessionDelegate createServerSessionDelegate) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.downloadMessagesAndListAttachmentsOperationQueue = new NoDuplicatePriorityOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingServerSessionOperations = new HashMap();
        this.awaitingServerSessionOperationsLock = new ReentrantLock();
        this.awaitingNotificationListener = new AwaitingNotificationListener();
    }

    public void startProcessing() {
        this.downloadMessagesAndListAttachmentsOperationQueue.execute(1, "Engine-DownloadMessagesAndListAttachmentsCoordinator");
    }

    public void setRegisterServerPushNotificationDelegate(RegisterServerPushNotificationDelegate registerServerPushNotificationDelegate) {
        this.registerServerPushNotificationDelegate = registerServerPushNotificationDelegate;
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("network_fetch_notification_server_session_created", this.awaitingNotificationListener);
        this.notificationListeningDelegate.addListener("identity_manager_notification_new_contact_identity", this);
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setProcessDownloadedMessageDelegate(ProcessDownloadedMessageDelegate processDownloadedMessageDelegate) {
        this.processDownloadedMessageDelegate = processDownloadedMessageDelegate;
    }

    public void initialQueueing() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            InboxMessage[] markedForDeletionMessages;
            InboxMessage[] decryptedInboxMessages;
            InboxMessage[] unprocessedMessages;
            for (InboxMessage inboxMessage : unprocessedMessages = InboxMessage.getUnprocessedMessages(fetchManagerSession)) {
                this.messageWasDownloaded(inboxMessage.getNetworkReceivedMessage());
            }
            for (InboxMessage inboxMessage : decryptedInboxMessages = InboxMessage.getDecryptedMessages(fetchManagerSession)) {
                this.messageDecrypted(inboxMessage, inboxMessage.getAttachments());
            }
            for (InboxMessage inboxMessage : markedForDeletionMessages = InboxMessage.getMarkedForDeletionMessages(fetchManagerSession)) {
                if (!inboxMessage.canBeDeleted()) continue;
                fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeDeletedFromServer(inboxMessage.getOwnedIdentity(), inboxMessage.getUid());
            }
            List<InboxMessage> expiredMessages = InboxMessage.getExpiredPendingPreKeyMessages(fetchManagerSession, System.currentTimeMillis() - 1296000000L);
            if (!expiredMessages.isEmpty()) {
                for (InboxMessage inboxMessage : expiredMessages) {
                    inboxMessage.markForDeletion();
                    for (InboxAttachment inboxAttachment : inboxMessage.getAttachments()) {
                        inboxAttachment.markForDeletion();
                    }
                    fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeDeletedFromServer(inboxMessage.getOwnedIdentity(), inboxMessage.getUid());
                }
                fetchManagerSession.session.commit();
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    private void queueNewDownloadMessagesAndListAttachmentsOperation(Identity identity, UID deviceUid) {
        DownloadMessagesAndListAttachmentsOperation op = new DownloadMessagesAndListAttachmentsOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, identity, deviceUid, 0L, this, this);
        this.downloadMessagesAndListAttachmentsOperationQueue.queue(op);
    }

    private void scheduleNewDownloadMessagesAndListAttachmentsOperationQueueing(Identity identity, UID deviceUid) {
        this.scheduler.schedule(identity, () -> this.queueNewDownloadMessagesAndListAttachmentsOperation(identity, deviceUid), "DownloadMessagesAndListAttachmentsOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForServerSession(Identity identity, UID deviceUid) {
        this.awaitingServerSessionOperationsLock.lock();
        this.awaitingServerSessionOperations.put(identity, deviceUid);
        this.awaitingServerSessionOperationsLock.unlock();
    }

    @Override
    public void messageWasDownloaded(NetworkReceivedMessage networkReceivedMessage) {
        if (this.processDownloadedMessageDelegate == null) {
            Logger.w("A message was downloaded but no ProcessDownloadedMessageDelegate is set yet.");
            return;
        }
        this.processDownloadedMessageDelegate.processDownloadedMessage(networkReceivedMessage);
    }

    @Override
    public void messageDecrypted(InboxMessage inboxMessage, InboxAttachment[] attachments) {
        if (this.notificationPostingDelegate != null) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("message", inboxMessage.getDecryptedApplicationMessage());
            ReceivedAttachment[] receivedAttachments = new ReceivedAttachment[attachments.length];
            for (int i = 0; i < attachments.length; ++i) {
                receivedAttachments[i] = new ReceivedAttachment(attachments[i].getOwnedIdentity(), attachments[i].getMessageUid(), attachments[i].getAttachmentNumber(), attachments[i].getMetadata(), attachments[i].getUrl(), attachments[i].getPlaintextExpectedLength(), attachments[i].getPlaintextReceivedLength(), attachments[i].isDownloadRequested());
            }
            userInfo.put("attachments", receivedAttachments);
            this.notificationPostingDelegate.postNotification("network_fetch_notification_message_payload_set", userInfo);
        }
    }

    @Override
    public void onFinishCallback(Operation operation) {
        Identity ownedIdentity = ((DownloadMessagesAndListAttachmentsOperation)operation).getOwnedIdentity();
        UID deviceUid = ((DownloadMessagesAndListAttachmentsOperation)operation).getDeviceUid();
        Long timestampOfLastMessageBeforeTruncation = ((DownloadMessagesAndListAttachmentsOperation)operation).getTimestampOfLastMessageBeforeTruncation();
        this.scheduler.clearFailedCount(ownedIdentity);
        if (timestampOfLastMessageBeforeTruncation != null) {
            this.downloadMessagesAndListAttachmentsOperationQueue.queue(new DownloadMessagesAndListAttachmentsOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, ownedIdentity, deviceUid, timestampOfLastMessageBeforeTruncation, this, this));
        } else {
            this.fetchManagerSessionFactory.markOwnedIdentityAsUpToDate(ownedIdentity);
        }
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("owned_identity", ownedIdentity);
        userInfo.put("success", true);
        userInfo.put("truncated", timestampOfLastMessageBeforeTruncation != null);
        this.notificationPostingDelegate.postNotification("network_fetch_notification_server_polled", userInfo);
    }

    @Override
    public void onCancelCallback(Operation operation) {
        if (operation instanceof DownloadMessagesAndListAttachmentsOperation) {
            Identity identity = ((DownloadMessagesAndListAttachmentsOperation)operation).getOwnedIdentity();
            UID deviceUid = ((DownloadMessagesAndListAttachmentsOperation)operation).getDeviceUid();
            Integer rfc = operation.getReasonForCancel();
            Logger.i("DownloadMessagesAndListAttachmentsOperation cancelled for reason " + rfc);
            if (rfc == null) {
                rfc = -1;
            }
            switch (rfc) {
                case 2: {
                    this.waitForServerSession(identity, deviceUid);
                    this.createServerSessionDelegate.createServerSession(identity);
                    break;
                }
                case 5: {
                    if (this.registerServerPushNotificationDelegate != null) {
                        this.registerServerPushNotificationDelegate.registerServerPushNotification(identity, false);
                        break;
                    }
                    Logger.e("Recieved a DEVICE_NOT_REGISTERED error from the server and registerServerPushNotificationDelegate was not initialized");
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    this.scheduleNewDownloadMessagesAndListAttachmentsOperationQueueing(identity, deviceUid);
                    HashMap<String, Object> userInfo = new HashMap<String, Object>();
                    userInfo.put("owned_identity", identity);
                    userInfo.put("success", false);
                    userInfo.put("truncated", false);
                    this.notificationPostingDelegate.postNotification("network_fetch_notification_server_polled", userInfo);
                    break;
                }
            }
        } else if (operation instanceof ProcessWebsocketReceivedMessageOperation) {
            Identity identity = ((ProcessWebsocketReceivedMessageOperation)operation).getOwnedIdentity();
            UID deviceUid = ((ProcessWebsocketReceivedMessageOperation)operation).getDeviceUid();
            Logger.i("ProcessWebsocketReceivedMessageOperation cancelled");
            this.scheduleNewDownloadMessagesAndListAttachmentsOperationQueueing(identity, deviceUid);
        }
    }

    @Override
    public void downloadMessagesAndListAttachments(Identity identity, UID deviceUid) {
        this.queueNewDownloadMessagesAndListAttachmentsOperation(identity, deviceUid);
    }

    @Override
    public void processWebsocketDownloadedMessage(Identity identity, UID deviceUid, byte[] messagePayload) {
        ProcessWebsocketReceivedMessageOperation op = new ProcessWebsocketReceivedMessageOperation(this.fetchManagerSessionFactory, identity, deviceUid, messagePayload, null, this);
        this.downloadMessagesAndListAttachmentsOperationQueue.queue(op);
    }

    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        if ("identity_manager_notification_new_contact_identity".equals(notificationName)) {
            try {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                boolean active = (Boolean)userInfo.get("active");
                if (active) {
                    ProcessPreKeyMessagesForNewContactOperation op = new ProcessPreKeyMessagesForNewContactOperation(this.fetchManagerSessionFactory, ownedIdentity, contactIdentity, null, null);
                    this.downloadMessagesAndListAttachmentsOperationQueue.queue(op);
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
    }

    class AwaitingNotificationListener
    implements NotificationListener {
        AwaitingNotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            switch (notificationName) {
                case "network_fetch_notification_server_session_created": {
                    Object identityObject = userInfo.get("identity");
                    if (!(identityObject instanceof Identity)) break;
                    Identity identity = (Identity)identityObject;
                    DownloadMessagesAndListAttachmentsCoordinator.this.awaitingServerSessionOperationsLock.lock();
                    UID deviceUid = DownloadMessagesAndListAttachmentsCoordinator.this.awaitingServerSessionOperations.get(identity);
                    if (deviceUid != null) {
                        DownloadMessagesAndListAttachmentsCoordinator.this.awaitingServerSessionOperations.remove(identity);
                        DownloadMessagesAndListAttachmentsCoordinator.this.queueNewDownloadMessagesAndListAttachmentsOperation(identity, deviceUid);
                    }
                    DownloadMessagesAndListAttachmentsCoordinator.this.awaitingServerSessionOperationsLock.unlock();
                }
            }
        }
    }
}

