/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.DownloadMessagesExtendedPayloadOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class DownloadMessageExtendedPayloadCoordinator
implements Operation.OnCancelCallback,
Operation.OnFinishCallback,
InboxMessage.ExtendedPayloadListener {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private final ExponentialBackoffRepeatingScheduler<Identity> scheduler;
    private final NoDuplicateOperationQueue downloadMessagesExtendedPayloadOperationQueue;
    private final AwaitingNotificationListener awaitingNotificationListener;
    private final HashMap<Identity, UID> awaitingServerSessionOperations;
    private final Lock awaitingServerSessionOperationsLock;
    private final HashMap<Identity, List<UID>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;
    private NotificationListeningDelegate notificationListeningDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;

    public DownloadMessageExtendedPayloadCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, CreateServerSessionDelegate createServerSessionDelegate) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.downloadMessagesExtendedPayloadOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingNotificationListener = new AwaitingNotificationListener();
        this.awaitingServerSessionOperations = new HashMap();
        this.awaitingServerSessionOperationsLock = new ReentrantLock();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
    }

    public void startProcessing() {
        this.downloadMessagesExtendedPayloadOperationQueue.execute(1, "Engine-DownloadMessagesExtendedPayloadCoordinator");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("network_fetch_notification_server_session_created", this.awaitingNotificationListener);
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.awaitingNotificationListener);
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void initialQueueing() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            InboxMessage[] missingExtendedPayloadInboxMessages;
            InboxMessage[] extendedPayloadInboxMessages;
            for (InboxMessage inboxMessage : extendedPayloadInboxMessages = InboxMessage.getExtendedPayloadMessages(fetchManagerSession)) {
                this.messageExtendedPayloadDownloaded(inboxMessage.getOwnedIdentity(), inboxMessage.getUid(), inboxMessage.getExtendedPayload());
            }
            for (InboxMessage inboxMessage : missingExtendedPayloadInboxMessages = InboxMessage.getMissingExtendedPayloadMessages(fetchManagerSession)) {
                this.messageHasExtendedPayloadToDownload(inboxMessage.getOwnedIdentity(), inboxMessage.getUid());
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void messageHasExtendedPayloadToDownload(Identity ownedIdentity, UID uid) {
        this.queueNewDownloadMessagesExtendedPayloadOperation(ownedIdentity, uid);
    }

    @Override
    public void messageExtendedPayloadDownloaded(Identity ownedIdentity, UID uid, byte[] extendedPayload) {
        if (this.notificationPostingDelegate != null) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("owned_identity", ownedIdentity);
            userInfo.put("message_uid", uid);
            userInfo.put("extended_payload", extendedPayload);
            this.notificationPostingDelegate.postNotification("network_fetch_notification_message_extended_payload_downloaded", userInfo);
        }
    }

    private void queueNewDownloadMessagesExtendedPayloadOperation(Identity identity, UID messageUid) {
        DownloadMessagesExtendedPayloadOperation op = new DownloadMessagesExtendedPayloadOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, identity, messageUid, this, this);
        this.downloadMessagesExtendedPayloadOperationQueue.queue(op);
    }

    private void scheduleNewDownloadMessagesExtendedPayloadOperationQueueing(Identity identity, UID messageUid) {
        this.scheduler.schedule(identity, () -> this.queueNewDownloadMessagesExtendedPayloadOperation(identity, messageUid), "DownloadMessagesExtendedPayloadOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForServerSession(Identity identity, UID deviceUid) {
        this.awaitingServerSessionOperationsLock.lock();
        this.awaitingServerSessionOperations.put(identity, deviceUid);
        this.awaitingServerSessionOperationsLock.unlock();
    }

    private void waitForIdentityReactivation(Identity ownedIdentity, UID messageUid) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<UID> list = this.awaitingIdentityReactivationOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<UID>();
            this.awaitingIdentityReactivationOperations.put(ownedIdentity, list);
        }
        list.add(messageUid);
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    @Override
    public void onFinishCallback(Operation operation) {
        Identity ownedIdentity = ((DownloadMessagesExtendedPayloadOperation)operation).getOwnedIdentity();
        this.scheduler.clearFailedCount(ownedIdentity);
    }

    @Override
    public void onCancelCallback(Operation operation) {
        if (operation instanceof DownloadMessagesExtendedPayloadOperation) {
            Identity ownedIdentity = ((DownloadMessagesExtendedPayloadOperation)operation).getOwnedIdentity();
            UID messageUid = ((DownloadMessagesExtendedPayloadOperation)operation).getMessageUid();
            Integer rfc = operation.getReasonForCancel();
            Logger.i("DownloadMessagesExtendedPayloadOperation cancelled for reason " + rfc);
            if (rfc == null) {
                rfc = -1;
            }
            switch (rfc) {
                case 4: {
                    try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
                        InboxMessage.clearExtendedPayload(fetchManagerSession, ownedIdentity, messageUid);
                    }
                    catch (SQLException sQLException) {}
                    break;
                }
                case 3: {
                    this.waitForIdentityReactivation(ownedIdentity, messageUid);
                    break;
                }
                case 2: {
                    this.waitForServerSession(ownedIdentity, messageUid);
                    this.createServerSessionDelegate.createServerSession(ownedIdentity);
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    this.scheduleNewDownloadMessagesExtendedPayloadOperationQueueing(ownedIdentity, messageUid);
                }
            }
        }
    }

    class AwaitingNotificationListener
    implements NotificationListener {
        AwaitingNotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            switch (notificationName) {
                case "network_fetch_notification_server_session_created": {
                    Object identityObject = userInfo.get("identity");
                    if (!(identityObject instanceof Identity)) break;
                    Identity identity = (Identity)identityObject;
                    DownloadMessageExtendedPayloadCoordinator.this.awaitingServerSessionOperationsLock.lock();
                    UID messageUid = DownloadMessageExtendedPayloadCoordinator.this.awaitingServerSessionOperations.get(identity);
                    if (messageUid != null) {
                        DownloadMessageExtendedPayloadCoordinator.this.awaitingServerSessionOperations.remove(identity);
                        DownloadMessageExtendedPayloadCoordinator.this.queueNewDownloadMessagesExtendedPayloadOperation(identity, messageUid);
                    }
                    DownloadMessageExtendedPayloadCoordinator.this.awaitingServerSessionOperationsLock.unlock();
                    break;
                }
                case "identity_manager_notification_owned_identity_changed_active_status": {
                    boolean active = (Boolean)userInfo.get("active");
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    if (!active) break;
                    DownloadMessageExtendedPayloadCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                    List<UID> list = DownloadMessageExtendedPayloadCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                    if (list != null) {
                        DownloadMessageExtendedPayloadCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                        for (UID messageUid : list) {
                            DownloadMessageExtendedPayloadCoordinator.this.queueNewDownloadMessagesExtendedPayloadOperation(ownedIdentity, messageUid);
                        }
                    }
                    DownloadMessageExtendedPayloadCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
                    break;
                }
            }
        }
    }
}

