/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.PriorityOperationQueue;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUidAndNumber;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.networkfetch.databases.InboxAttachment;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.RefreshInboxAttachmentSignedUrlDelegate;
import io.olvid.engine.networkfetch.operations.DownloadAttachmentOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class DownloadAttachmentCoordinator
implements InboxAttachment.InboxAttachmentListener,
Operation.OnCancelCallback {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final RefreshInboxAttachmentSignedUrlDelegate refreshInboxAttachmentSignedUrlDelegate;
    private NotificationListeningDelegate notificationListeningDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;
    private final ExponentialBackoffRepeatingScheduler<IdentityAndUidAndNumber> scheduler;
    private final PriorityOperationQueue downloadAttachmentOperationWeightQueue;
    private final PriorityOperationQueue downloadAttachmentOperationTimestampQueue;
    private final NotificationListener notificationListener;
    private final HashMap<IdentityAndUidAndNumber, AttachmentPriorityInfo> awaitingRefreshedUrlsOperations;
    private final Lock awaitingRefreshedUrlsLock;
    private final HashMap<Identity, List<AttachmentPriorityInfo>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;

    public DownloadAttachmentCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, RefreshInboxAttachmentSignedUrlDelegate refreshInboxAttachmentSignedUrlDelegate) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.refreshInboxAttachmentSignedUrlDelegate = refreshInboxAttachmentSignedUrlDelegate;
        this.downloadAttachmentOperationWeightQueue = new PriorityOperationQueue();
        this.downloadAttachmentOperationTimestampQueue = new PriorityOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.notificationListener = new NotificationListener();
        this.awaitingRefreshedUrlsOperations = new HashMap();
        this.awaitingRefreshedUrlsLock = new ReentrantLock();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
    }

    public void startProcessing() {
        this.downloadAttachmentOperationWeightQueue.execute(4, "Engine-DownloadAttachmentCoordinator-weight");
        this.downloadAttachmentOperationTimestampQueue.execute(4, "Engine-DownloadAttachmentCoordinator-timestamp");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("network_fetch_notification_signed_url_refreshed", this.notificationListener);
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.notificationListener);
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void initialQueueing() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            InboxAttachment[] attachmentsNotToResume;
            InboxAttachment[] attachmentsToResume;
            for (InboxAttachment inboxAttachment : attachmentsToResume = InboxAttachment.getAllAttachmentsToResume(fetchManagerSession)) {
                this.queueNewDownloadAttachmentOperation(inboxAttachment.getOwnedIdentity(), inboxAttachment.getMessageUid(), inboxAttachment.getAttachmentNumber(), inboxAttachment.getPriorityCategory(), inboxAttachment.getPriority());
                fetchManagerSession.inboxAttachmentListener.attachmentDownloadProgressed(inboxAttachment.getOwnedIdentity(), inboxAttachment.getMessageUid(), inboxAttachment.getAttachmentNumber(), inboxAttachment.getProgress());
            }
            for (InboxAttachment inboxAttachment : attachmentsNotToResume = InboxAttachment.getAllPartialAttachmentsNotToResume(fetchManagerSession)) {
                fetchManagerSession.inboxAttachmentListener.attachmentDownloadProgressed(inboxAttachment.getOwnedIdentity(), inboxAttachment.getMessageUid(), inboxAttachment.getAttachmentNumber(), inboxAttachment.getProgress());
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    private void queueNewDownloadAttachmentOperation(Identity ownedIdentity, UID messageUid, int attachmentNumber, int priorityCategory, long initialPriority) {
        Logger.d("Download attachment coordinator queueing new DownloadAttachmentOperation.");
        DownloadAttachmentOperation op = new DownloadAttachmentOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority, this, null, this);
        switch (priorityCategory) {
            case 0: {
                this.downloadAttachmentOperationWeightQueue.queue(op);
                PriorityOperation lowestPriorityExecutingOperation = this.downloadAttachmentOperationWeightQueue.getExecutingOperationThatShouldBeCancelledWhenQueueingWithHigherPriority();
                if (lowestPriorityExecutingOperation == null || lowestPriorityExecutingOperation.getPriority() <= initialPriority) break;
                Logger.d("Canceling a DownloadAttachmentOperation with lower priority " + lowestPriorityExecutingOperation.getPriority());
                lowestPriorityExecutingOperation.cancel(8);
                break;
            }
            case 1: {
                this.downloadAttachmentOperationTimestampQueue.queue(op);
                PriorityOperation lowestPriorityExecutingOperation = this.downloadAttachmentOperationTimestampQueue.getExecutingOperationThatShouldBeCancelledWhenQueueingWithHigherPriority();
                if (lowestPriorityExecutingOperation == null || lowestPriorityExecutingOperation.getPriority() <= initialPriority) break;
                Logger.d("Canceling a DownloadAttachmentOperation with lower priority " + lowestPriorityExecutingOperation.getPriority());
                lowestPriorityExecutingOperation.cancel(8);
                break;
            }
            default: {
                Logger.w("Trying to queue a DownloadAttachmentOperation with unknown priorityCategory " + priorityCategory);
            }
        }
    }

    private void scheduleNewDownloadAttachmentOperationQueueing(Identity ownedIdentity, UID messageUid, int attachmentNumber, int priorityCategory, long initialPriority) {
        this.scheduler.schedule(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), () -> this.queueNewDownloadAttachmentOperation(ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority), "DownloadAttachmentOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForRefreshedUrls(Identity ownedIdentity, UID messageUid, int attachmentNumber, int priorityCategory, long initialPriority) {
        this.awaitingRefreshedUrlsLock.lock();
        this.awaitingRefreshedUrlsOperations.put(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), new AttachmentPriorityInfo(ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority));
        this.awaitingRefreshedUrlsLock.unlock();
    }

    private void waitForIdentityReactivation(Identity ownedIdentity, UID messageUid, int attachmentNumber, int priorityCategory, long initialPriority) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<AttachmentPriorityInfo> list = this.awaitingIdentityReactivationOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<AttachmentPriorityInfo>();
            this.awaitingIdentityReactivationOperations.put(ownedIdentity, list);
        }
        list.add(new AttachmentPriorityInfo(ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority));
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    public void resetFailedAttemptCount(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.scheduler.clearFailedCount(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((DownloadAttachmentOperation)operation).getOwnedIdentity();
        UID messageUid = ((DownloadAttachmentOperation)operation).getMessageUid();
        int attachmentNumber = ((DownloadAttachmentOperation)operation).getAttachmentNumber();
        int priorityCategory = ((DownloadAttachmentOperation)operation).getPriorityCategory();
        long initialPriority = ((DownloadAttachmentOperation)operation).getPriority();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("DownloadAttachmentOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: {
                try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
                    InboxAttachment attachment = InboxAttachment.get(fetchManagerSession, ownedIdentity, messageUid, attachmentNumber);
                    if (attachment != null) {
                        fetchManagerSession.session.startTransaction();
                        attachment.markForDeletion();
                        if (attachment.getMessage().canBeDeleted()) {
                            fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeDeletedFromServer(ownedIdentity, messageUid);
                        }
                        fetchManagerSession.session.commit();
                    }
                }
                catch (SQLException e) {
                    Logger.x(e);
                }
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", ownedIdentity);
                userInfo.put("messageUid", messageUid);
                userInfo.put("attachmentNumber", attachmentNumber);
                this.notificationPostingDelegate.postNotification("network_fetch_notification_attachment_download_failed", userInfo);
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                break;
            }
            case 15: {
                this.waitForIdentityReactivation(ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority);
                break;
            }
            case 8: {
                this.queueNewDownloadAttachmentOperation(ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority);
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", ownedIdentity);
                userInfo.put("messageUid", messageUid);
                userInfo.put("attachmentNumber", attachmentNumber);
                this.notificationPostingDelegate.postNotification("network_fetch_notification_attachment_download_was_paused", userInfo);
                break;
            }
            case 2: {
                this.waitForRefreshedUrls(ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority);
                this.refreshInboxAttachmentSignedUrlDelegate.refreshInboxAttachmentSignedUrl(ownedIdentity, messageUid, attachmentNumber);
                break;
            }
            case 13: {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", ownedIdentity);
                userInfo.put("messageUid", messageUid);
                userInfo.put("attachmentNumber", attachmentNumber);
                this.notificationPostingDelegate.postNotification("network_fetch_notification_attachment_download_was_paused", userInfo);
                break;
            }
            default: {
                this.scheduleNewDownloadAttachmentOperationQueueing(ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority);
            }
        }
    }

    @Override
    public void attachmentDownloadProgressed(Identity ownedIdentity, UID messageUid, int attachmentNumber, float progress) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("owned_identity", ownedIdentity);
        userInfo.put("messageUid", messageUid);
        userInfo.put("attachmentNumber", attachmentNumber);
        userInfo.put("progress", Float.valueOf(progress));
        this.notificationPostingDelegate.postNotification("network_fetch_notification_attachment_download_progress", userInfo);
    }

    @Override
    public void attachmentDownloadFinished(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("owned_identity", ownedIdentity);
        userInfo.put("messageUid", messageUid);
        userInfo.put("attachmentNumber", attachmentNumber);
        this.notificationPostingDelegate.postNotification("network_fetch_notification_attachment_download_finished", userInfo);
    }

    @Override
    public void attachmentDownloadWasRequested(Identity ownedIdentity, UID messageUid, int attachmentNumber, int priorityCategory, long initialPriority) {
        this.queueNewDownloadAttachmentOperation(ownedIdentity, messageUid, attachmentNumber, priorityCategory, initialPriority);
    }

    class NotificationListener
    implements io.olvid.engine.datatypes.NotificationListener {
        NotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            switch (notificationName) {
                case "network_fetch_notification_signed_url_refreshed": {
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    UID messageUid = (UID)userInfo.get("message_uid");
                    int attachmentNumber = (Integer)userInfo.get("attachment_number");
                    DownloadAttachmentCoordinator.this.awaitingRefreshedUrlsLock.lock();
                    AttachmentPriorityInfo attachmentPriorityInfo = DownloadAttachmentCoordinator.this.awaitingRefreshedUrlsOperations.get(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
                    if (attachmentPriorityInfo != null) {
                        DownloadAttachmentCoordinator.this.awaitingRefreshedUrlsOperations.remove(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
                        DownloadAttachmentCoordinator.this.queueNewDownloadAttachmentOperation(ownedIdentity, messageUid, attachmentNumber, attachmentPriorityInfo.getPriorityCategory(), attachmentPriorityInfo.getInitialPriority());
                    }
                    DownloadAttachmentCoordinator.this.awaitingRefreshedUrlsLock.unlock();
                    break;
                }
                case "identity_manager_notification_owned_identity_changed_active_status": {
                    boolean active = (Boolean)userInfo.get("active");
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    if (!active) break;
                    DownloadAttachmentCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                    List<AttachmentPriorityInfo> list = DownloadAttachmentCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                    if (list != null) {
                        DownloadAttachmentCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                        for (AttachmentPriorityInfo params : list) {
                            DownloadAttachmentCoordinator.this.queueNewDownloadAttachmentOperation(params.ownedIdentity, params.messageUid, params.attachmentNumber, params.priorityCategory, params.initialPriority);
                        }
                    }
                    DownloadAttachmentCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
                    break;
                }
            }
        }
    }

    private static class AttachmentPriorityInfo {
        private final Identity ownedIdentity;
        private final UID messageUid;
        private final int attachmentNumber;
        private final int priorityCategory;
        private final long initialPriority;

        public AttachmentPriorityInfo(Identity ownedIdentity, UID messageUid, int attachmentNumber, int priorityCategory, long initialPriority) {
            this.ownedIdentity = ownedIdentity;
            this.messageUid = messageUid;
            this.attachmentNumber = attachmentNumber;
            this.priorityCategory = priorityCategory;
            this.initialPriority = initialPriority;
        }

        public Identity getOwnedIdentity() {
            return this.ownedIdentity;
        }

        public UID getMessageUid() {
            return this.messageUid;
        }

        public int getAttachmentNumber() {
            return this.attachmentNumber;
        }

        public int getPriorityCategory() {
            return this.priorityCategory;
        }

        public long getInitialPriority() {
            return this.initialPriority;
        }
    }
}

