/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUidAndBoolean;
import io.olvid.engine.datatypes.containers.UidAndBoolean;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.MessageBatchProvider;
import io.olvid.engine.networkfetch.operations.DeleteMessageAndAttachmentFromServerAndLocalInboxesOperation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class DeleteMessageAndAttachmentsCoordinator
implements Operation.OnCancelCallback,
InboxMessage.MarkAsListedAndDeleteOnServerListener,
MessageBatchProvider,
Operation.OnFinishCallback {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private final ExponentialBackoffRepeatingScheduler<Identity> scheduler;
    private final HashMap<Identity, Queue<UidAndBoolean>> messageUidsToDeleteByOwnedIdentity;
    private final NoDuplicateOperationQueue deleteMessageAndAttachmentsFromServerOperationQueue;
    private final HashMap<Identity, List<IdentityAndUidAndBoolean>> awaitingServerSessionOperations;
    private final Lock awaitingServerSessionOperationsLock;
    private final ServerSessionCreatedNotificationListener serverSessionCreatedNotificationListener;

    public DeleteMessageAndAttachmentsCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, CreateServerSessionDelegate createServerSessionDelegate) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.deleteMessageAndAttachmentsFromServerOperationQueue = new NoDuplicateOperationQueue();
        this.messageUidsToDeleteByOwnedIdentity = new HashMap();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingServerSessionOperations = new HashMap();
        this.awaitingServerSessionOperationsLock = new ReentrantLock();
        this.serverSessionCreatedNotificationListener = new ServerSessionCreatedNotificationListener();
    }

    public void startProcessing() {
        this.deleteMessageAndAttachmentsFromServerOperationQueue.execute(1, "Engine-DeleteMessageAndAttachmentsCoordinator");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        notificationListeningDelegate.addListener("network_fetch_notification_server_session_created", this.serverSessionCreatedNotificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNewDeleteMessageAndAttachmentsFromServerOperation(Identity ownedIdentity, UID messageUid, boolean markAsListed) {
        if (messageUid != null) {
            HashMap<Identity, Queue<UidAndBoolean>> hashMap = this.messageUidsToDeleteByOwnedIdentity;
            synchronized (hashMap) {
                Queue<UidAndBoolean> queue = this.messageUidsToDeleteByOwnedIdentity.get(ownedIdentity);
                if (queue == null) {
                    queue = new ArrayDeque<UidAndBoolean>();
                    this.messageUidsToDeleteByOwnedIdentity.put(ownedIdentity, queue);
                }
                queue.add(new UidAndBoolean(messageUid, markAsListed));
            }
        }
        DeleteMessageAndAttachmentFromServerAndLocalInboxesOperation op = new DeleteMessageAndAttachmentFromServerAndLocalInboxesOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, ownedIdentity, this, this, this);
        this.deleteMessageAndAttachmentsFromServerOperationQueue.queue(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UidAndBoolean[] getBatchOFMessageUids(Identity ownedIdentity) {
        ArrayList<UidAndBoolean> messageUidsAndMarkAsListed = new ArrayList<UidAndBoolean>();
        HashMap<Identity, Queue<UidAndBoolean>> hashMap = this.messageUidsToDeleteByOwnedIdentity;
        synchronized (hashMap) {
            Queue<UidAndBoolean> queue = this.messageUidsToDeleteByOwnedIdentity.get(ownedIdentity);
            if (queue != null && !queue.isEmpty()) {
                do {
                    messageUidsAndMarkAsListed.add(queue.remove());
                } while (messageUidsAndMarkAsListed.size() != 50 && !queue.isEmpty());
            }
        }
        return messageUidsAndMarkAsListed.toArray(new UidAndBoolean[0]);
    }

    private void scheduleNewDeleteMessageAndAttachmentsFromServerOperationQueueing(Identity ownedIdentity) {
        this.scheduler.schedule(ownedIdentity, () -> this.queueNewDeleteMessageAndAttachmentsFromServerOperation(ownedIdentity, null, false), "DeleteMessageAndAttachmentFromServerAndLocalInboxesOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForServerSession(Identity ownedIdentity, UID messageUid, boolean markAsListed) {
        this.awaitingServerSessionOperationsLock.lock();
        List<IdentityAndUidAndBoolean> list = this.awaitingServerSessionOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<IdentityAndUidAndBoolean>();
            this.awaitingServerSessionOperations.put(ownedIdentity, list);
        }
        list.add(new IdentityAndUidAndBoolean(ownedIdentity, messageUid, markAsListed));
        this.awaitingServerSessionOperationsLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinishCallback(Operation operation) {
        Identity ownedIdentity = ((DeleteMessageAndAttachmentFromServerAndLocalInboxesOperation)operation).getOwnedIdentity();
        this.scheduler.clearFailedCount(ownedIdentity);
        HashMap<Identity, Queue<UidAndBoolean>> hashMap = this.messageUidsToDeleteByOwnedIdentity;
        synchronized (hashMap) {
            Queue<UidAndBoolean> queue = this.messageUidsToDeleteByOwnedIdentity.get(ownedIdentity);
            if (queue != null && !queue.isEmpty()) {
                this.queueNewDeleteMessageAndAttachmentsFromServerOperation(ownedIdentity, null, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((DeleteMessageAndAttachmentFromServerAndLocalInboxesOperation)operation).getOwnedIdentity();
        UidAndBoolean[] messageUidsAndMarkAsListed = ((DeleteMessageAndAttachmentFromServerAndLocalInboxesOperation)operation).getMessageUidsAndMarkAsListed();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("DeleteMessageAndAttachmentFromServerAndLocalInboxesOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 2: {
                if (messageUidsAndMarkAsListed != null) {
                    for (UidAndBoolean uidAndBoolean : messageUidsAndMarkAsListed) {
                        this.waitForServerSession(ownedIdentity, uidAndBoolean.uid, uidAndBoolean.bool);
                    }
                }
                this.createServerSessionDelegate.createServerSession(ownedIdentity);
                break;
            }
            default: {
                if (messageUidsAndMarkAsListed != null) {
                    HashMap<Identity, Queue<UidAndBoolean>> hashMap = this.messageUidsToDeleteByOwnedIdentity;
                    synchronized (hashMap) {
                        Queue<UidAndBoolean> queue = this.messageUidsToDeleteByOwnedIdentity.get(ownedIdentity);
                        if (queue == null) {
                            queue = new ArrayDeque<UidAndBoolean>();
                            this.messageUidsToDeleteByOwnedIdentity.put(ownedIdentity, queue);
                        }
                        queue.addAll(Arrays.asList(messageUidsAndMarkAsListed));
                    }
                }
                this.scheduleNewDeleteMessageAndAttachmentsFromServerOperationQueueing(ownedIdentity);
            }
        }
    }

    @Override
    public void messageCanBeDeletedFromServer(Identity ownedIdentity, UID messageUid) {
        this.queueNewDeleteMessageAndAttachmentsFromServerOperation(ownedIdentity, messageUid, false);
    }

    @Override
    public void messageCanBeMarkedAsListedOnServer(Identity ownedIdentity, UID messageUid) {
        this.queueNewDeleteMessageAndAttachmentsFromServerOperation(ownedIdentity, messageUid, true);
    }

    class ServerSessionCreatedNotificationListener
    implements NotificationListener {
        ServerSessionCreatedNotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if (!notificationName.equals("network_fetch_notification_server_session_created")) {
                return;
            }
            Object identityObject = userInfo.get("identity");
            if (!(identityObject instanceof Identity)) {
                return;
            }
            Identity ownedIdentity = (Identity)identityObject;
            DeleteMessageAndAttachmentsCoordinator.this.awaitingServerSessionOperationsLock.lock();
            List<IdentityAndUidAndBoolean> messageUids = DeleteMessageAndAttachmentsCoordinator.this.awaitingServerSessionOperations.get(ownedIdentity);
            if (messageUids != null) {
                DeleteMessageAndAttachmentsCoordinator.this.awaitingServerSessionOperations.remove(ownedIdentity);
                for (IdentityAndUidAndBoolean triple : messageUids) {
                    DeleteMessageAndAttachmentsCoordinator.this.queueNewDeleteMessageAndAttachmentsFromServerOperation(ownedIdentity, triple.uid, triple.bool);
                }
            }
            DeleteMessageAndAttachmentsCoordinator.this.awaitingServerSessionOperationsLock.unlock();
        }
    }
}

