/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.metamanager;

import io.olvid.engine.Logger;
import io.olvid.engine.metamanager.ObvManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class MetaManager {
    private final HashMap<String, Object> registeredInterfaceImplementations = new HashMap();
    private final HashMap<String, ArrayList<ObvManager>> managersAwaitingInterfaceImplementations = new HashMap();
    private final Set<ObvManager> registeredManagers = Collections.newSetFromMap(Collections.synchronizedMap(new HashMap()));
    private final Set<Object> registeredDelegates = Collections.newSetFromMap(Collections.synchronizedMap(new HashMap()));
    private final ReentrantLock lockOnInterfaceImplementations = new ReentrantLock();

    public void initializationComplete() throws Exception {
        if (!this.managersAwaitingInterfaceImplementations.isEmpty()) {
            Logger.e("Called initializationComplete but some managers are still awaiting some delegates.");
            for (Map.Entry<String, ArrayList<ObvManager>> entry : this.managersAwaitingInterfaceImplementations.entrySet()) {
                Logger.e("Missing delegate for " + entry.getKey());
            }
            throw new Exception();
        }
        Logger.i("\u2714\ufe0f\u2714\ufe0f\u2714\ufe0f\u2714\ufe0f Engine initialisation complete. All managers have their requested delegates set.");
        new Thread(() -> {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PriorityQueue<ObvManager> sortedManagers = new PriorityQueue<ObvManager>(this.registeredManagers.size(), Comparator.comparingInt(ObvManager::initialQueueingPriority));
            sortedManagers.addAll(this.registeredManagers);
            for (ObvManager manager : sortedManagers) {
                try {
                    manager.initialisationComplete();
                }
                catch (Exception e) {
                    Logger.e("Exception in initialisationComplete() for " + String.valueOf(manager.getClass()));
                    Logger.x(e);
                }
            }
        }).start();
    }

    public void registerImplementedDelegates(Object delegatesImplementation) {
        this.registeredDelegates.add(delegatesImplementation);
        this.checkInterfaceImplementations(delegatesImplementation);
    }

    public void requestDelegate(ObvManager manager, Class<?> interfaceClass) {
        String interfaceName = interfaceClass.getName();
        this.registeredManagers.add(manager);
        this.lockOnInterfaceImplementations.lock();
        Object delegate = this.registeredInterfaceImplementations.get(interfaceName);
        if (delegate != null) {
            this.setManagerDelegate(manager, delegate, interfaceName);
        } else {
            for (Object registeredDelegate : this.registeredDelegates) {
                if (!interfaceClass.isInstance(registeredDelegate)) continue;
                this.registeredInterfaceImplementations.put(interfaceName, registeredDelegate);
                this.setManagerDelegate(manager, registeredDelegate, interfaceName);
                this.lockOnInterfaceImplementations.unlock();
                return;
            }
            ArrayList<ObvManager> waitingManagers = this.managersAwaitingInterfaceImplementations.get(interfaceName);
            if (waitingManagers == null) {
                waitingManagers = new ArrayList();
                this.managersAwaitingInterfaceImplementations.put(interfaceName, waitingManagers);
            }
            waitingManagers.add(manager);
        }
        this.lockOnInterfaceImplementations.unlock();
    }

    private void setManagerDelegate(ObvManager manager, Object delegate, String interfaceName) {
        try {
            Method method = manager.getClass().getMethod("setDelegate", Class.forName(interfaceName));
            method.invoke((Object)manager, delegate);
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            Logger.x(e);
        }
        catch (NoSuchMethodException e) {
            Logger.e("ObvManager " + String.valueOf(manager.getClass()) + " requests a delegate of type " + interfaceName + " but does not implement the matching setDelegate method.");
            throw new RuntimeException();
        }
    }

    private void checkInterfaceImplementations(Object delegatesImplementation) {
        this.lockOnInterfaceImplementations.lock();
        for (String interfaceName : this.registeredInterfaceImplementations.keySet()) {
            try {
                if (!Class.forName(interfaceName).isInstance(delegatesImplementation)) continue;
                Logger.e("The MetaManager received two managers implementing " + interfaceName + ":\n  " + String.valueOf(this.registeredInterfaceImplementations.get(interfaceName)) + "\n  " + String.valueOf(delegatesImplementation.getClass()));
                throw new RuntimeException();
            }
            catch (ClassNotFoundException e) {
                Logger.x(e);
            }
        }
        for (String interfaceName : this.managersAwaitingInterfaceImplementations.keySet().toArray(new String[0])) {
            try {
                if (!Class.forName(interfaceName).isInstance(delegatesImplementation)) continue;
                this.registeredInterfaceImplementations.put(interfaceName, delegatesImplementation);
                for (ObvManager waitingManager : this.managersAwaitingInterfaceImplementations.get(interfaceName)) {
                    this.setManagerDelegate(waitingManager, delegatesImplementation, interfaceName);
                }
                this.managersAwaitingInterfaceImplementations.remove(interfaceName);
            }
            catch (ClassNotFoundException e) {
                Logger.x(e);
            }
        }
        this.lockOnInterfaceImplementations.unlock();
    }
}

