/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.KeycloakServer;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeycloakSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String SERVER_URL = "server_url";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String KEYCLOAK_USER_ID = "keycloak_user_id";
    public static final String JWKS = "jwks";
    public static final String SIGNATURE_KEY = "signature_key";
    public static final String SELF_REVOCATION_TEST_NONCE = "self_revocation_test_nonce";
    public static final String TRANSFER_RESTRICTED = "transfer_restricted";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("server_url", "client_id", "client_secret", "keycloak_user_id", "jwks", "signature_key", "self_revocation_test_nonce", "transfer_restricted"));
    public String server_url;
    public String client_id;
    public String client_secret;
    public String keycloak_user_id;
    public String jwks;
    public String signature_key;
    public String self_revocation_test_nonce;
    public boolean transfer_restricted;
    public HashSet<String> domain;

    public static KeycloakSyncSnapshot of(IdentityManagerSession identityManagerSession, KeycloakServer keycloakServer) throws SQLException {
        KeycloakSyncSnapshot keycloakSyncSnapshot = new KeycloakSyncSnapshot();
        keycloakSyncSnapshot.server_url = keycloakServer.getServerUrl();
        keycloakSyncSnapshot.client_id = keycloakServer.getClientId();
        keycloakSyncSnapshot.client_secret = keycloakServer.getClientSecret();
        keycloakSyncSnapshot.keycloak_user_id = keycloakServer.getKeycloakUserId();
        keycloakSyncSnapshot.jwks = keycloakServer.getSerializedJwks();
        keycloakSyncSnapshot.signature_key = keycloakServer.getSerializedSignatureKey();
        keycloakSyncSnapshot.self_revocation_test_nonce = keycloakServer.getSelfRevocationTestNonce();
        keycloakSyncSnapshot.transfer_restricted = keycloakServer.isTransferRestricted();
        keycloakSyncSnapshot.domain = DEFAULT_DOMAIN;
        return keycloakSyncSnapshot;
    }

    @JsonIgnore
    public KeycloakServer restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, KeycloakSyncSnapshot keycloak) throws Exception {
        if (!(this.domain.contains(SERVER_URL) && this.domain.contains(CLIENT_ID) && this.domain.contains(KEYCLOAK_USER_ID) && this.domain.contains(JWKS))) {
            Logger.e("Trying to restore an incomplete KeycloakSyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        if (keycloak.server_url == null || keycloak.client_id == null || keycloak.keycloak_user_id == null || keycloak.jwks == null) {
            return null;
        }
        try {
            KeycloakServer keycloakServer = new KeycloakServer(identityManagerSession, this.server_url, ownedIdentity, this.jwks, this.domain.contains(SIGNATURE_KEY) ? this.signature_key : null, this.client_id, this.client_secret, this.domain.contains(TRANSFER_RESTRICTED) && this.transfer_restricted);
            keycloakServer.insert();
            keycloakServer.setKeycloakUserId(this.keycloak_user_id);
            keycloakServer.setSelfRevocationTestNonce(this.self_revocation_test_nonce);
            return keycloakServer;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof KeycloakSyncSnapshot)) {
            return false;
        }
        KeycloakSyncSnapshot other = (KeycloakSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "server_url": {
                    if (Objects.equals(this.server_url, other.server_url)) break;
                    return false;
                }
                case "client_id": {
                    if (Objects.equals(this.client_id, other.client_id)) break;
                    return false;
                }
                case "client_secret": {
                    if (Objects.equals(this.client_secret, other.client_secret)) break;
                    return false;
                }
                case "keycloak_user_id": {
                    if (Objects.equals(this.keycloak_user_id, other.keycloak_user_id)) break;
                    return false;
                }
                case "jwks": {
                    if (Objects.equals(this.jwks, other.jwks)) break;
                    return false;
                }
                case "signature_key": {
                    if (Objects.equals(this.signature_key, other.signature_key)) break;
                    return false;
                }
                case "self_revocation_test_nonce": {
                    if (Objects.equals(this.self_revocation_test_nonce, other.self_revocation_test_nonce)) break;
                    return false;
                }
                case "transfer_restricted": {
                    if (!(this.transfer_restricted ^ other.transfer_restricted)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

