/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.OwnedIdentity;
import io.olvid.engine.identity.databases.sync.OwnedIdentitySyncSnapshot;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IdentityManagerSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String OWNED_IDENTITY = "owned_identity";
    public static final String OWNED_IDENTITY_NODE = "owned_identity_node";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("owned_identity", "owned_identity_node"));
    public byte[] owned_identity;
    public OwnedIdentitySyncSnapshot owned_identity_node;
    public HashSet<String> domain;

    public static IdentityManagerSyncSnapshot of(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        IdentityManagerSyncSnapshot identityManagerSyncSnapshot = new IdentityManagerSyncSnapshot();
        identityManagerSyncSnapshot.owned_identity = ownedIdentity.getBytes();
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(identityManagerSession, ownedIdentity);
        if (ownedIdentityObject != null) {
            identityManagerSyncSnapshot.owned_identity_node = OwnedIdentitySyncSnapshot.of(identityManagerSession, ownedIdentityObject);
        }
        identityManagerSyncSnapshot.domain = DEFAULT_DOMAIN;
        return identityManagerSyncSnapshot;
    }

    @JsonIgnore
    public void restore(IdentityManagerSession identityManagerSession, ProtocolStarterDelegate protocolStarterDelegate) throws Exception {
        if (!this.domain.contains(OWNED_IDENTITY) || !this.domain.contains(OWNED_IDENTITY_NODE)) {
            Logger.e("Trying to restore an incomplete IdentityManagerSyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        Identity ownedIdentity = Identity.of(this.owned_identity);
        if (!identityManagerSession.identityDelegate.isOwnedIdentity(identityManagerSession.session, ownedIdentity)) {
            Logger.e("Trying to restore a snapshot of an unknown owned identity");
            throw new Exception();
        }
        this.owned_identity_node.restore(identityManagerSession, protocolStarterDelegate, ownedIdentity);
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof IdentityManagerSyncSnapshot)) {
            return false;
        }
        IdentityManagerSyncSnapshot other = (IdentityManagerSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "owned_identity": {
                    if (Arrays.equals(this.owned_identity, other.owned_identity)) break;
                    return false;
                }
                case "owned_identity_node": {
                    if (this.owned_identity_node.areContentsTheSame(other.owned_identity_node)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        if (!(otherSnapshotNode instanceof IdentityManagerSyncSnapshot)) {
            throw new Exception();
        }
        IdentityManagerSyncSnapshot other = (IdentityManagerSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        ArrayList<ObvSyncDiff> diffs = new ArrayList<ObvSyncDiff>();
        Iterator<String> iterator = domainIntersection.iterator();
        while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "owned_identity": {
                    if (Arrays.equals(this.owned_identity, other.owned_identity)) break;
                    throw new Exception();
                }
                case "owned_identity_node": {
                    diffs.addAll(this.owned_identity_node.computeDiff(other.owned_identity_node));
                }
            }
        }
        return diffs;
    }
}

