/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.ContactIdentityDetails;
import io.olvid.engine.identity.databases.OwnedIdentityDetails;
import io.olvid.engine.identity.databases.ServerUserData;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IdentityDetailsSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String VERSION = "version";
    public static final String SERIALIZED_DETAILS = "serialized_details";
    public static final String PHOTO_SERVER_LABEL = "photo_server_label";
    public static final String PHOTO_SERVER_KEY = "photo_server_key";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("version", "serialized_details", "photo_server_label", "photo_server_key"));
    public Integer version;
    public String serialized_details;
    public byte[] photo_server_label;
    public byte[] photo_server_key;
    public HashSet<String> domain;

    public static IdentityDetailsSyncSnapshot of(IdentityManagerSession identityManagerSession, OwnedIdentityDetails ownedIdentityDetails) {
        IdentityDetailsSyncSnapshot identityDetailsSyncSnapshot = new IdentityDetailsSyncSnapshot();
        identityDetailsSyncSnapshot.version = ownedIdentityDetails.getVersion();
        identityDetailsSyncSnapshot.serialized_details = ownedIdentityDetails.getSerializedJsonDetails();
        if (ownedIdentityDetails.getPhotoServerLabel() != null && ownedIdentityDetails.getPhotoServerKey() != null) {
            identityDetailsSyncSnapshot.photo_server_label = ownedIdentityDetails.getPhotoServerLabel().getBytes();
            identityDetailsSyncSnapshot.photo_server_key = Encoded.of(ownedIdentityDetails.getPhotoServerKey()).getBytes();
        }
        identityDetailsSyncSnapshot.domain = DEFAULT_DOMAIN;
        return identityDetailsSyncSnapshot;
    }

    public static IdentityDetailsSyncSnapshot of(IdentityManagerSession identityManagerSession, ContactIdentityDetails contactIdentityDetails) {
        IdentityDetailsSyncSnapshot identityDetailsSyncSnapshot = new IdentityDetailsSyncSnapshot();
        identityDetailsSyncSnapshot.version = contactIdentityDetails.getVersion();
        identityDetailsSyncSnapshot.serialized_details = contactIdentityDetails.getSerializedJsonDetails();
        if (contactIdentityDetails.getPhotoServerLabel() != null && contactIdentityDetails.getPhotoServerKey() != null) {
            identityDetailsSyncSnapshot.photo_server_label = contactIdentityDetails.getPhotoServerLabel().getBytes();
            identityDetailsSyncSnapshot.photo_server_key = Encoded.of(contactIdentityDetails.getPhotoServerKey()).getBytes();
        }
        identityDetailsSyncSnapshot.domain = DEFAULT_DOMAIN;
        return identityDetailsSyncSnapshot;
    }

    @JsonIgnore
    public OwnedIdentityDetails restoreOwned(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws Exception {
        AuthEncKey photoServerKey;
        UID photoServerLabel;
        if (!this.domain.contains(VERSION) || !this.domain.contains(SERIALIZED_DETAILS)) {
            Logger.e("Trying to restore an incomplete IdentityDetailsSyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        if (this.domain.contains(PHOTO_SERVER_LABEL) && this.domain.contains(PHOTO_SERVER_KEY) && this.photo_server_key != null && this.photo_server_label != null) {
            try {
                photoServerLabel = new UID(this.photo_server_label);
                photoServerKey = (AuthEncKey)new Encoded(this.photo_server_key).decodeSymmetricKey();
            }
            catch (Exception e) {
                Logger.x(e);
                photoServerLabel = null;
                photoServerKey = null;
            }
        } else {
            photoServerLabel = null;
            photoServerKey = null;
        }
        OwnedIdentityDetails ownedIdentityDetails = new OwnedIdentityDetails(identityManagerSession, ownedIdentity, this.version, this.serialized_details, null, photoServerLabel, photoServerKey);
        ownedIdentityDetails.insert();
        if (photoServerLabel != null && photoServerKey != null) {
            ServerUserData.createForOwnedIdentityDetails(identityManagerSession, ownedIdentity, photoServerLabel);
        }
        return ownedIdentityDetails;
    }

    @JsonIgnore
    public ContactIdentityDetails restoreContact(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        AuthEncKey photoServerKey;
        UID photoServerLabel;
        if (!this.domain.contains(VERSION) || !this.domain.contains(SERIALIZED_DETAILS)) {
            Logger.e("Trying to restore an incomplete IdentityDetailsSyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        if (this.domain.contains(PHOTO_SERVER_LABEL) && this.domain.contains(PHOTO_SERVER_KEY) && this.photo_server_key != null && this.photo_server_label != null) {
            try {
                photoServerLabel = new UID(this.photo_server_label);
                photoServerKey = (AuthEncKey)new Encoded(this.photo_server_key).decodeSymmetricKey();
            }
            catch (Exception e) {
                Logger.x(e);
                photoServerLabel = null;
                photoServerKey = null;
            }
        } else {
            photoServerLabel = null;
            photoServerKey = null;
        }
        ContactIdentityDetails contactIdentityDetails = new ContactIdentityDetails(identityManagerSession, contactIdentity, ownedIdentity, this.version, this.serialized_details, null, photoServerLabel, photoServerKey);
        contactIdentityDetails.insert();
        return contactIdentityDetails;
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof IdentityDetailsSyncSnapshot)) {
            return false;
        }
        IdentityDetailsSyncSnapshot other = (IdentityDetailsSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        block14: while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "version": {
                    if (Objects.equals(this.version, other.version)) break;
                    return false;
                }
                case "serialized_details": {
                    if (Objects.equals(this.serialized_details, other.serialized_details)) break;
                    return false;
                }
                case "photo_server_label": {
                    if (Arrays.equals(this.photo_server_label, other.photo_server_label)) break;
                    return false;
                }
                case "photo_server_key": {
                    try {
                        if (!(this.photo_server_key == null && other.photo_server_key != null || this.photo_server_key != null && other.photo_server_key == null) && (this.photo_server_key == null || Objects.equals(new Encoded(this.photo_server_key).decodeSymmetricKey(), new Encoded(other.photo_server_key).decodeSymmetricKey()))) continue block14;
                        return false;
                    }
                    catch (DecodingException e) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

