/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.ContactGroupV2;
import io.olvid.engine.identity.databases.ContactGroupV2Details;
import io.olvid.engine.identity.databases.ContactGroupV2Member;
import io.olvid.engine.identity.databases.ContactGroupV2PendingMember;
import io.olvid.engine.identity.databases.sync.GroupDetailsSyncSnapshot;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupV2SyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String PERMISSIONS = "permissions";
    public static final String VERSION = "version";
    public static final String DETAILS = "details";
    public static final String TRUSTED_DETAILS = "trusted_details";
    public static final String VERIFIED_ADMIN_CHAIN = "verified_admin_chain";
    public static final String MAIN_SEED = "main_seed";
    public static final String VERSION_SEED = "version_seed";
    public static final String ENCODED_ADMIN_KEY = "encoded_admin_key";
    public static final String INVITATION_NONCE = "invitation_nonce";
    public static final String LAST_MODIFICATION_TIMESTAMP = "last_modification_timestamp";
    public static final String PUSH_TOPIC = "push_topic";
    public static final String SERIALIZED_SHARED_SETTINGS = "serialized_shared_settings";
    public static final String SERIALIZED_GROUP_TYPE = "serialized_group_type";
    public static final String MEMBERS = "members";
    public static final String PENDING_MEMBERS = "pending_members";
    static HashSet<String> DEFAULT_SERVER_DOMAIN = new HashSet<String>(Arrays.asList("permissions", "version", "details", "trusted_details", "verified_admin_chain", "main_seed", "version_seed", "encoded_admin_key", "invitation_nonce", "serialized_group_type", "members", "pending_members"));
    static HashSet<String> DEFAULT_KEYCLOAK_DOMAIN = new HashSet<String>(Arrays.asList("permissions", "details", "invitation_nonce", "last_modification_timestamp", "push_topic", "serialized_shared_settings", "members", "pending_members"));
    public HashSet<String> permissions;
    public Integer version;
    public GroupDetailsSyncSnapshot details;
    public GroupDetailsSyncSnapshot trusted_details;
    public byte[] verified_admin_chain;
    public byte[] main_seed;
    public byte[] version_seed;
    public byte[] encoded_admin_key;
    public byte[] invitation_nonce;
    public Long last_modification_timestamp;
    public String push_topic;
    public String serialized_shared_settings;
    public String serialized_group_type;
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, GroupV2Member> members;
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, GroupV2PendingMember> pending_members;
    public HashSet<String> domain;

    public static GroupV2SyncSnapshot of(IdentityManagerSession identityManagerSession, ContactGroupV2 group2) throws SQLException {
        GroupV2SyncSnapshot groupV2SyncSnapshot = new GroupV2SyncSnapshot();
        groupV2SyncSnapshot.permissions = new HashSet<String>(group2.getOwnPermissionStrings());
        ContactGroupV2Details publishedDetails = ContactGroupV2Details.get(identityManagerSession, group2.getOwnedIdentity(), group2.getGroupIdentifier(), group2.getVersion());
        if (publishedDetails != null) {
            groupV2SyncSnapshot.details = GroupDetailsSyncSnapshot.of(identityManagerSession, publishedDetails);
        }
        groupV2SyncSnapshot.invitation_nonce = group2.getOwnGroupInvitationNonce();
        if (group2.getGroupIdentifier().category == 0) {
            ContactGroupV2Details trustedDetails;
            groupV2SyncSnapshot.version = group2.getVersion();
            if (group2.getTrustedDetailsVersion() != group2.getVersion().intValue() && (trustedDetails = ContactGroupV2Details.get(identityManagerSession, group2.getOwnedIdentity(), group2.getGroupIdentifier(), group2.getTrustedDetailsVersion())) != null) {
                groupV2SyncSnapshot.trusted_details = GroupDetailsSyncSnapshot.of(identityManagerSession, trustedDetails);
            }
            groupV2SyncSnapshot.verified_admin_chain = group2.getVerifiedAdministratorsChain();
            groupV2SyncSnapshot.main_seed = group2.getBlobMainSeed().getBytes();
            groupV2SyncSnapshot.version_seed = group2.getBlobVersionSeed().getBytes();
            if (group2.getGroupAdminServerAuthenticationPrivateKey() != null) {
                groupV2SyncSnapshot.encoded_admin_key = Encoded.of(group2.getGroupAdminServerAuthenticationPrivateKey()).getBytes();
            }
            groupV2SyncSnapshot.serialized_group_type = group2.getSerializedJsonGroupType();
            groupV2SyncSnapshot.last_modification_timestamp = null;
            groupV2SyncSnapshot.domain = DEFAULT_SERVER_DOMAIN;
        } else {
            groupV2SyncSnapshot.last_modification_timestamp = group2.getLastModificationTimestamp();
            groupV2SyncSnapshot.push_topic = group2.getPushTopic();
            groupV2SyncSnapshot.serialized_shared_settings = group2.getSerializedSharedSettings();
            groupV2SyncSnapshot.domain = DEFAULT_KEYCLOAK_DOMAIN;
        }
        groupV2SyncSnapshot.members = new HashMap();
        for (ContactGroupV2Member groupV2Member : ContactGroupV2Member.getAll(identityManagerSession, group2.getOwnedIdentity(), group2.getGroupIdentifier())) {
            groupV2SyncSnapshot.members.put(new ObvBytesKey(groupV2Member.getContactIdentity().getBytes()), GroupV2Member.of(groupV2Member));
        }
        groupV2SyncSnapshot.pending_members = new HashMap();
        for (ContactGroupV2PendingMember groupV2PendingMember : ContactGroupV2PendingMember.getAll(identityManagerSession, group2.getOwnedIdentity(), group2.getGroupIdentifier())) {
            groupV2SyncSnapshot.pending_members.put(new ObvBytesKey(groupV2PendingMember.getContactIdentity().getBytes()), GroupV2PendingMember.of(groupV2PendingMember));
        }
        return groupV2SyncSnapshot;
    }

    @JsonIgnore
    public ContactGroupV2 restore(IdentityManagerSession identityManagerSession, ProtocolStarterDelegate protocolStarterDelegate, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        GroupV2.BlobKeys blobKeys;
        if (!(this.domain.contains(PERMISSIONS) && this.domain.contains(DETAILS) && this.domain.contains(INVITATION_NONCE) && this.domain.contains(MEMBERS) && this.domain.contains(PENDING_MEMBERS) && (groupIdentifier.category != 0 || this.domain.contains(VERSION) && this.domain.contains(VERIFIED_ADMIN_CHAIN) && this.domain.contains(MAIN_SEED) && this.domain.contains(VERSION_SEED) && this.domain.contains(ENCODED_ADMIN_KEY)))) {
            Logger.e("Trying to restore an incomplete GroupV2SyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        ContactGroupV2Details contactGroupV2Details = this.details.restoreGroupV2(identityManagerSession, ownedIdentity, groupIdentifier, this.version == null ? 0 : this.version);
        ContactGroupV2Details trustedDetails = this.domain.contains(TRUSTED_DETAILS) && this.trusted_details != null && groupIdentifier.category == 0 ? this.trusted_details.restoreGroupV2(identityManagerSession, ownedIdentity, groupIdentifier, this.version == null ? -1 : this.version - 1) : null;
        if (groupIdentifier.category == 0) {
            ServerAuthenticationPrivateKey serverAuthenticationPrivateKey = this.encoded_admin_key != null ? (ServerAuthenticationPrivateKey)new Encoded(this.encoded_admin_key).decodePrivateKey() : null;
            blobKeys = this.main_seed == null || this.version_seed == null ? null : new GroupV2.BlobKeys(new Seed(this.main_seed), new Seed(this.version_seed), serverAuthenticationPrivateKey);
        } else {
            blobKeys = null;
        }
        ContactGroupV2 groupV2 = new ContactGroupV2(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, GroupV2.Permission.serializePermissionStrings(this.permissions), contactGroupV2Details.getVersion(), this.verified_admin_chain, blobKeys, this.invitation_nonce, false, this.domain.contains(LAST_MODIFICATION_TIMESTAMP) && this.last_modification_timestamp != null ? this.last_modification_timestamp : System.currentTimeMillis(), this.domain.contains(PUSH_TOPIC) ? this.push_topic : null, this.domain.contains(SERIALIZED_SHARED_SETTINGS) ? this.serialized_shared_settings : null, this.serialized_group_type);
        if (trustedDetails != null) {
            groupV2.trustedDetailsVersion = trustedDetails.getVersion();
        }
        groupV2.insert();
        for (Map.Entry<ObvBytesKey, GroupV2Member> entry : this.members.entrySet()) {
            Identity memberIdentity = Identity.of(entry.getKey().getBytes());
            ContactGroupV2Member.create(identityManagerSession, ownedIdentity, groupIdentifier, memberIdentity, entry.getValue().permissions, entry.getValue().invitation_nonce);
        }
        for (Map.Entry<ObvBytesKey, Object> entry : this.pending_members.entrySet()) {
            Identity pendingMemberIdentity = Identity.of(entry.getKey().getBytes());
            ContactGroupV2PendingMember.create(identityManagerSession, ownedIdentity, groupIdentifier, pendingMemberIdentity, ((GroupV2PendingMember)entry.getValue()).serialized_details, ((GroupV2PendingMember)entry.getValue()).permissions, ((GroupV2PendingMember)entry.getValue()).invitation_nonce);
        }
        try {
            protocolStarterDelegate.initiateGroupV2ReDownloadWithinTransaction(identityManagerSession.session, ownedIdentity, groupIdentifier);
        }
        catch (Exception e) {
            Logger.x(e);
        }
        return groupV2;
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        return false;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GroupV2Member {
        public HashSet<String> permissions;
        public byte[] invitation_nonce;

        private static GroupV2Member of(ContactGroupV2Member groupMember) {
            GroupV2Member groupV2Member = new GroupV2Member();
            groupV2Member.permissions = new HashSet<String>(GroupV2.Permission.deserializePermissions(groupMember.getSerializedPermissions()));
            groupV2Member.invitation_nonce = groupMember.getGroupInvitationNonce();
            return groupV2Member;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GroupV2PendingMember {
        public String serialized_details;
        public HashSet<String> permissions;
        public byte[] invitation_nonce;

        private static GroupV2PendingMember of(ContactGroupV2PendingMember pendingGroupMember) {
            GroupV2PendingMember groupV2PendingMember = new GroupV2PendingMember();
            groupV2PendingMember.serialized_details = pendingGroupMember.getSerializedContactDetails();
            groupV2PendingMember.permissions = new HashSet<String>(GroupV2.Permission.deserializePermissions(pendingGroupMember.getSerializedPermissions()));
            groupV2PendingMember.invitation_nonce = pendingGroupMember.getGroupInvitationNonce();
            return groupV2PendingMember;
        }
    }
}

