/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.ContactGroup;
import io.olvid.engine.identity.databases.ContactGroupDetails;
import io.olvid.engine.identity.databases.ContactGroupMembersJoin;
import io.olvid.engine.identity.databases.PendingGroupMember;
import io.olvid.engine.identity.databases.sync.GroupDetailsSyncSnapshot;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupV1SyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String PUBLISHED_DETAILS = "published_details";
    public static final String TRUSTED_DETAILS = "trusted_details";
    public static final String GROUP_MEMBERS_VERSION = "group_members_version";
    public static final String MEMBERS = "members";
    public static final String PENDING_MEMBERS = "pending_members";
    static HashSet<String> DEFAULT_JOINED_DOMAIN = new HashSet<String>(Arrays.asList("published_details", "trusted_details", "group_members_version", "members", "pending_members"));
    static HashSet<String> DEFAULT_OWNED_DOMAIN = new HashSet<String>(Arrays.asList("published_details", "group_members_version", "members", "pending_members"));
    public GroupDetailsSyncSnapshot published_details;
    public GroupDetailsSyncSnapshot trusted_details;
    public Long group_members_version;
    @JsonSerialize(contentUsing=ObvBytesKey.Serializer.class)
    @JsonDeserialize(contentUsing=ObvBytesKey.Deserializer.class)
    public HashSet<ObvBytesKey> members;
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, GroupV1PendingMember> pending_members;
    public HashSet<String> domain;

    public static GroupV1SyncSnapshot of(IdentityManagerSession identityManagerSession, ContactGroup group) throws SQLException {
        GroupV1SyncSnapshot groupV1SyncSnapshot = new GroupV1SyncSnapshot();
        groupV1SyncSnapshot.published_details = GroupDetailsSyncSnapshot.of(identityManagerSession, group.getPublishedDetails());
        if (group.getGroupOwner() == null) {
            groupV1SyncSnapshot.domain = DEFAULT_OWNED_DOMAIN;
        } else {
            if (group.getPublishedDetailsVersion() != group.getLatestOrTrustedDetailsVersion()) {
                groupV1SyncSnapshot.trusted_details = GroupDetailsSyncSnapshot.of(identityManagerSession, group.getLatestOrTrustedDetails());
            }
            groupV1SyncSnapshot.domain = DEFAULT_JOINED_DOMAIN;
        }
        groupV1SyncSnapshot.group_members_version = group.getGroupMembersVersion();
        groupV1SyncSnapshot.members = new HashSet();
        for (Identity memberIdentity : ContactGroupMembersJoin.getContactIdentitiesInGroup(identityManagerSession, group.getGroupOwnerAndUid(), group.getOwnedIdentity())) {
            groupV1SyncSnapshot.members.add(new ObvBytesKey(memberIdentity.getBytes()));
        }
        groupV1SyncSnapshot.pending_members = new HashMap();
        for (PendingGroupMember pendingGroupMember : PendingGroupMember.getAllInGroup(identityManagerSession, group.getGroupOwnerAndUid(), group.getOwnedIdentity())) {
            groupV1SyncSnapshot.pending_members.put(new ObvBytesKey(pendingGroupMember.getContactIdentity().getBytes()), GroupV1PendingMember.of(pendingGroupMember));
        }
        return groupV1SyncSnapshot;
    }

    @JsonIgnore
    public ContactGroup restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity groupOwnerIdentity, byte[] groupOwnerAndUid) throws Exception {
        ContactGroup contactGroup;
        if (!(this.domain.contains(GROUP_MEMBERS_VERSION) && this.domain.contains(MEMBERS) && this.domain.contains(PENDING_MEMBERS) && this.domain.contains(PUBLISHED_DETAILS))) {
            Logger.e("Trying to restore an incomplete GroupV1SyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        if (groupOwnerIdentity.equals(ownedIdentity)) {
            ContactGroupDetails publishedDetails = this.published_details.restoreGroup(identityManagerSession, ownedIdentity, groupOwnerIdentity, groupOwnerAndUid);
            contactGroup = new ContactGroup(identityManagerSession, groupOwnerAndUid, ownedIdentity, null, publishedDetails.getVersion());
            contactGroup.groupMembersVersion = this.group_members_version;
            contactGroup.insert();
        } else {
            ContactGroupDetails contactGroupDetails = this.published_details.restoreGroup(identityManagerSession, ownedIdentity, groupOwnerIdentity, groupOwnerAndUid);
            ContactGroupDetails trustedDetails = this.domain.contains(TRUSTED_DETAILS) && this.trusted_details != null && !Objects.equals(this.trusted_details.version, this.published_details.version) ? this.trusted_details.restoreGroup(identityManagerSession, ownedIdentity, groupOwnerIdentity, groupOwnerAndUid) : null;
            contactGroup = new ContactGroup(identityManagerSession, groupOwnerAndUid, ownedIdentity, groupOwnerIdentity, contactGroupDetails.getVersion());
            if (trustedDetails != null) {
                contactGroup.latestOrTrustedDetailsVersion = trustedDetails.getVersion();
            }
            contactGroup.groupMembersVersion = this.group_members_version;
            contactGroup.insert();
        }
        for (ObvBytesKey obvBytesKey : this.members) {
            Identity memberIdentity = Identity.of(obvBytesKey.getBytes());
            ContactGroupMembersJoin.create(identityManagerSession, groupOwnerAndUid, ownedIdentity, memberIdentity);
        }
        for (Map.Entry entry : this.pending_members.entrySet()) {
            Identity pendingMemberIdentity = Identity.of(((ObvBytesKey)entry.getKey()).getBytes());
            PendingGroupMember pendingGroupMember = new PendingGroupMember(identityManagerSession, groupOwnerAndUid, ownedIdentity, pendingMemberIdentity, ((GroupV1PendingMember)entry.getValue()).serialized_details);
            pendingGroupMember.declined = ((GroupV1PendingMember)entry.getValue()).declined != null && ((GroupV1PendingMember)entry.getValue()).declined != false;
            pendingGroupMember.insert();
        }
        return contactGroup;
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        return false;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GroupV1PendingMember {
        public String serialized_details;
        public Boolean declined;

        private static GroupV1PendingMember of(PendingGroupMember pendingGroupMember) {
            GroupV1PendingMember groupV1PendingMember = new GroupV1PendingMember();
            groupV1PendingMember.serialized_details = pendingGroupMember.getContactSerializedDetails();
            groupV1PendingMember.declined = pendingGroupMember.isDeclined() ? Boolean.valueOf(true) : null;
            return groupV1PendingMember;
        }
    }
}

